/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.approveRebuild.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.fi.ssc.extpoint.approve.ITaskApproveService;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.approveRebuild.MsgTypeEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.approveRebuild.helper.BillOperationHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveFailureHelper;
import kd.ssc.task.approveRebuild.helper.TaskApproveSuccessHelper;
import kd.ssc.task.business.helper.TaskCreditHelper;
import kd.ssc.task.business.helper.WorkFlowCreditHelper;
import kd.ssc.task.common.TaskApprevalUtil;
import kd.ssc.task.common.smartscheme.SmartSchemePredictMessage;
import kd.ssc.task.face.TaskFacade;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.factory.PublisherFactory;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.service.approve.ApproveService;
import kd.ssc.task.util.SSCBosUtil;

public class TaskApproveHelper {
    private static final Log log = LogFactory.getLog(TaskApproveHelper.class);
    private static final String BAR_PASS = "bar_pass";
    private static final String BAR_NOT_PASS = "bd_nopass";
    private static final String BAR_REPULSE = "bar_repulse";

    public static String getErpNumber(Long billTypeId) {
        QFilter idFilter = new QFilter("id", "=", (Object)billTypeId);
        DynamicObject billType = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"id,externalerp.id,externalerp.number,bindbill.number", (QFilter[])new QFilter[]{idFilter});
        String erpNumber = (String)billType.get("externalerp.number");
        return erpNumber;
    }

    public static Map<String, Object> doApproveOperation(String key, Map<String, String> map, DynamicObject billData, IFormView view, IDataModel model, IFormView subView) {
        Map<String, Object> resultMap;
        Map<String, Object> billOpResultMap;
        Map<String, Object> failureResult;
        String erpNumber;
        String decisionValue;
        ApproveService approveService = TaskApprevalUtil.getApproveService();
        if (approveService != null) {
            approveService.beforeApproveOperation(key, billData, map, view, model, subView, false);
        }
        Long sscId = Long.valueOf(map.get("sscId"));
        String taskIdStr = map.get("taskID");
        Long taskId = Long.valueOf(taskIdStr);
        PluginProxy pluginProxy = PluginProxy.create(null, ITaskApproveService.class, (String)"kd.ssc.task.approveRebuild.helper.TaskApproveHelper.doApproveOperationExt");
        TaskApproveHelper.beforeApproveOperation((PluginProxy<ITaskApproveService>)pluginProxy, taskId, key, map);
        String billTypeKey = map.get("billTypeKey");
        Long billTypeId = Long.valueOf(map.get("billtypeid"));
        Long taskTypeId = Long.valueOf(map.get("tasktypeid"));
        String operation = map.get("operation");
        boolean isPass = BAR_PASS.equals(key);
        int decision = BAR_NOT_PASS.equalsIgnoreCase(key) ? 2 : (BAR_REPULSE.equalsIgnoreCase(key) ? 3 : 1);
        String message = map.get("opinion");
        if (isPass) {
            decisionValue = map.getOrDefault("passDecisionValue", "Consent");
            if (map.containsKey("passDecisionValue")) {
                log.info("Extended passDecisionValue[{}] exists", (Object)decisionValue);
            }
        } else {
            decisionValue = TaskApproveHelper.getDecisionValue(Long.parseLong(map.get("decisionitemid")));
            if (StringUtils.isEmpty((CharSequence)decisionValue)) {
                decisionValue = "Reject";
                log.info("Using default because no pass decision[{}] not exists", (Object)map.get("decisionitemid"));
            }
        }
        if ("KDCC".equalsIgnoreCase(erpNumber = map.get("erpNumber")) && (failureResult = BillOperationHelper.tranServiceResultMap(billOpResultMap = BillOperationHelper.saveKDCCBillData(map, billTypeId, taskTypeId, operation))) != null) {
            return failureResult;
        }
        long hisTaskId = 0L;
        try {
            TaskFacade taskFacade = ErpFactory.getTaskFacade((String)erpNumber);
            TaskApproveHelper.sysAudit(map, taskId, isPass, message, decision, decisionValue, taskFacade);
        }
        catch (Exception e) {
            ErrorCode code;
            String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519[1]", (String)"TaskApproveHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            log.error(errorInfo, (Throwable)e);
            String errorMsg = e.getMessage();
            if (e instanceof KDException && (code = ((KDException)e).getErrorCode()).getCode() != null && code.getCode().startsWith("approve_partask") && code.getMessage() != null && !code.getMessage().isEmpty()) {
                errorMsg = code.getMessage();
            }
            TaskApproveFailureHelper.saveExceptionInfo2DB(e, "taskId = " + taskId);
            TaskApproveFailureHelper.deleteUnPassResion(taskId);
            return TaskApproveFailureHelper.getFailureResult("SSC_1002", errorMsg, MsgTypeEnum.POP);
        }
        try (TXHandle h = TX.requiresNew((String)"kd.ssc.task.approveRebuild.helper.TaskApproveHelper.doApproveOperation");){
            try {
                TaskApproveSuccessHelper.calCompletedTime(Collections.singletonList(taskId));
                hisTaskId = TaskApproveSuccessHelper.updateStateAndRecord(key, taskId, map);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("hisTaskId", hisTaskId);
                resultMap = TaskApproveSuccessHelper.getSuccessResult(data);
            }
            catch (Exception e) {
                h.markRollback();
                String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519[2]", (String)"TaskApproveHelper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                log.error(errorInfo, (Throwable)e);
                TaskApproveFailureHelper.saveExceptionInfo2DB(e, "taskId = " + taskId);
                Map<String, Object> map2 = TaskApproveFailureHelper.getFailureResult("SSC_1002", e.getMessage());
                if (h != null) {
                    if (var24_26 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var24_26.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return map2;
            }
        }
        if (taskId != 0L && hisTaskId != 0L) {
            SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.DELETE, (Long)sscId, (Long)taskId);
            SscEventDistributor.taskSyncData((String)"task_taskhistory", (DataChangeTypeEnum)DataChangeTypeEnum.INSERT, (Long)sscId, (Long)hisTaskId);
        }
        TaskApproveHelper.doApproveOperationAfter(decision, hisTaskId, map, resultMap);
        if (approveService != null) {
            approveService.afterApproveOperation(key, billData, map, view, model, subView, false, hisTaskId);
        }
        TaskApproveHelper.afterApproveOperation((PluginProxy<ITaskApproveService>)pluginProxy, hisTaskId, key, map);
        return resultMap;
    }

    private static boolean sysAudit(Map<String, String> map, Long taskId, boolean isPass, String isPassmessage, int decision, String decisionValue, TaskFacade taskFacade) throws Exception {
        return TaskApproveHelper.notEmbedBizAudit(map, taskId, isPass, isPassmessage, decision, decisionValue, taskFacade);
    }

    private static boolean notEmbedBizAudit(Map<String, String> map, Long taskId, boolean isPass, String isPassmessage, int decision, String decisionValue, TaskFacade taskFacade) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        String itemId = map.get("nodeItemId");
        paramMap.put("itemId", itemId);
        String messages = isPassmessage == null ? "" : isPassmessage;
        boolean remoteInvoke = taskFacade.approve(taskId.longValue(), isPass, messages, decision, decisionValue, paramMap);
        log.info("kd.ssc.task.approveRebuild.helper.TaskApproveHelper.notEmbedBizAudit end");
        if (!remoteInvoke) {
            ErrorCode errorCode = new ErrorCode("notEmbedBizAudit_0", "invoke notEmbedBizAudit() fail! remoteInvoke = false ");
            throw new KDException(errorCode, new Object[]{ResManager.loadKDString((String)"\u975e\u5d4c\u5165\u5f0f\u5355\u636e\u5904\u7406\u51fa\u9519", (String)"TaskApproveHelper_4", (String)"ssc-task-formplugin", (Object[])new Object[0])});
        }
        return remoteInvoke;
    }

    public static void creditSetWfVariable(String key, Map<String, String> map, Long taskId) {
        QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
        DynamicObject taskInfo = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"id,assignid,subject", (QFilter[])new QFilter[]{idFilter});
        Boolean openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByTaskId((DynamicObject)taskInfo);
        if (openCreditControl == null || !openCreditControl.booleanValue()) {
            return;
        }
        TaskCreditHelper.updateWfVariableByTaskId((String)key, map, (DynamicObject)taskInfo);
    }

    private static void doApproveOperationAfter(int decision, long hisTaskId, Map<String, String> map, Map<String, Object> resultMap) {
        if (decision == 1) {
            TaskApproveHelper.sendParTaskMessageIfNecessary(hisTaskId);
        }
        String billTypeKey = map.get("billTypeKey");
        String billId = map.get("billid");
        TaskApproveHelper.predictMQ(hisTaskId, billTypeKey);
        DynamicObject billData = TaskApproveHelper.geSourceBillData(billTypeKey, billId);
        TaskApprevalUtil.doSyncResultOperation(billTypeKey, billData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendParTaskMessageIfNecessary(long hisTaskId) {
        DynamicObject hisTask = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"sourcetaskid,assignid", (QFilter[])new QFilter("id", "=", (Object)hisTaskId).toArray());
        try (MessagePublisher parTaskPub = PublisherFactory.getParTaskPub();){
            List msgList = new ParTaskNodeServiceImpl().getNextNodeMsg(hisTask.getLong("sourcetaskid"), hisTask.getLong("assignid"));
            if (msgList != null) {
                for (ParTaskMessage msg : msgList) {
                    parTaskPub.publish((Object)msg);
                }
            }
        }
    }

    private static void predictMQ(Long taskId, String billTypeKey) {
        if (taskId == 0L) {
            log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\u5931\u8d25, taskId = 0");
            return;
        }
        boolean predic = TaskApproveHelper.getSscSettingInfo("taskpredict");
        if (predic && (billTypeKey.equals("er_tripreqbill") || billTypeKey.equals("er_dailyloanbill") || billTypeKey.equals("er_dailyreimbursebill") || billTypeKey.equals("er_tripreimbursebill"))) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_smartscheme_queue");){
                pub.publish((Object)new SmartSchemePredictMessage(Collections.singletonList(taskId), Collections.singletonList(billTypeKey)));
            }
        }
    }

    private static boolean getSscSettingInfo(String key) {
        Object params = SSCBosUtil.getSscSettingInfo((String)key, (boolean)false);
        if (params == null || !(params instanceof Boolean)) {
            log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b-\u83b7\u53d6\u914d\u7f6e\uff1a\u83b7\u53d6 " + key + "\u8bbe\u7f6e\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        return (Boolean)params;
    }

    private static String getDecisionValue(long decisionItemId) {
        if (decisionItemId == 0L) {
            return null;
        }
        DynamicObject decisionItem = BusinessDataServiceHelper.loadSingleFromCache((String)"task_decisionitem", (String)"decisionvalue", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)decisionItemId)});
        return decisionItem.getString("decisionvalue");
    }

    private static void beforeApproveOperation(PluginProxy<ITaskApproveService> pluginProxy, Long taskId, String key, Map<String, String> map) {
        pluginProxy.callReplace(p -> {
            p.beforeApproveOperation(taskId, key, map);
            return null;
        });
    }

    private static void afterApproveOperation(PluginProxy<ITaskApproveService> pluginProxy, Long hisTaskId, String key, Map<String, String> map) {
        pluginProxy.callReplace(p -> {
            p.afterApproveOperation(hisTaskId, key, map);
            return null;
        });
    }

    public static DynamicObject getTaskDo(Long taskId) {
        String entityName = "task_task";
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, personid.id, imagenumber,billtype.id, billtype.isembed, billtype.bindbill.number, billtype.bindform.number, billtype.isstoredindb,bizdata_tag, innermsg, apprevalmessage, decisionitem, qualitysamplelibrary.id, reformperson.id,unpassreasondesc, pendingopinion, rescanopinion, approveop, unpassreasondata, assignid";
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
    }

    public static DynamicObject geSourceBillData(String billType, String billId) {
        DynamicObject dataEntity = null;
        if (QueryServiceHelper.exists((String)billType, (Object)billId)) {
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType);
        }
        return dataEntity;
    }

    public static void updateTaskMsg(Long taskId, String opinion, String msg, String operation) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id, state, innerMsg, apprevalmessage", (QFilter[])new QFilter[]{filter});
        if (operation.equals("5")) {
            obj.set("state", (Object)TaskStateEnum.RESCAN.getValue());
        } else {
            obj.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        obj.set("innerMsg", (Object)msg);
        obj.set("apprevalmessage", (Object)opinion);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }
}

