/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.BillStatus;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;

public class CommonFilterUtil {
    public static final String COMMON_FILTER_SSCID_DEFAULT = "-1";
    public static final String COMMON_FILTER_SSCID_0 = "0";
    private static final Log log = LogFactory.getLog(CommonFilterUtil.class);

    public static QFilter getEnableMetaQFilterByMetaName(String metaName) {
        String point = ".";
        if (StringUtils.isBlank((String)metaName)) {
            metaName = "";
            point = "";
        }
        QFilter enableQF = new QFilter(metaName.concat(point).concat("enable"), "=", (Object)"1");
        QFilter stateQF = new QFilter(metaName.concat(point).concat("status"), "=", (Object)"C");
        return enableQF.and(stateQF);
    }

    public static QFilter getEnableDisRuleQFilter() {
        QFilter disruleDelEnable = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        QFilter orgEnable = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity1.orgrange.FBasedataId");
        QFilter userGroupEnable = new QFilter("entryentity1.usergroup.status", "=", (Object)BillStatus.AUDIT.getStatus());
        QFilter taskTypeEnable = CommonFilterUtil.getEnableMetaQFilterByMetaName("tasktype");
        QFilter billTypeEnable = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.billtype");
        return disruleDelEnable.and(orgEnable).and(userGroupEnable).and(taskTypeEnable).and(billTypeEnable);
    }

    public static List<ComboItem> getComboItems(String entityName, QFilter filter, String orderBys) {
        ArrayList<ComboItem> listcomitem = new ArrayList<ComboItem>();
        QFilter[] filters = filter == null ? null : filter.toArray();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("getComboItems-" + entityName), (String)entityName, (String)"id,name", (QFilter[])filters, (String)orderBys);){
            Row row = null;
            String caption = null;
            String value = null;
            while (ds.hasNext()) {
                row = ds.next();
                caption = row.getString("name");
                value = row.getString("id");
                listcomitem.add(new ComboItem(new LocaleString(caption), value));
            }
        }
        return listcomitem;
    }

    public static List<ComboItem> getComboItems(String entityName, QFilter filter) {
        return CommonFilterUtil.getComboItems(entityName, filter, null);
    }

    public static Set<Long> getEntityIds(String entityName, QFilter filter, String orderBys) {
        HashSet<Long> retIds = new HashSet<Long>();
        QFilter[] filters = filter == null ? null : filter.toArray();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("getEntityIds-" + entityName), (String)entityName, (String)"id", (QFilter[])filters, (String)orderBys);){
            Row row = null;
            Long id = 0L;
            while (ds.hasNext()) {
                row = ds.next();
                id = row.getLong("id");
                retIds.add(id);
            }
        }
        return retIds;
    }

    public static Set<Long> getEntityIds(String entityName, QFilter filter) {
        return CommonFilterUtil.getEntityIds(entityName, filter, null);
    }

    public static void resetComboItems(IPageCache pageCache, String cacheKey, CommonFilterColumn commonFilterColumn, String entityName, QFilter filter, String orderBys, Object sscid, boolean isDefaultSelect) {
        List taskTypeCbList = commonFilterColumn.getComboItems();
        taskTypeCbList.clear();
        String sscidKey = CacheKey.getSSCKey((Object)cacheKey, (Object)sscid);
        String cbItemStr = pageCache.get(sscidKey);
        List<Object> retComboItems = new ArrayList<ComboItem>(16);
        if (StringUtils.isNotEmpty((String)cbItemStr)) {
            retComboItems = SerializationUtils.fromJsonStringToList((String)cbItemStr, ComboItem.class);
        } else {
            if (sscid == null || COMMON_FILTER_SSCID_DEFAULT.equals(sscid.toString()) || COMMON_FILTER_SSCID_0.equals(sscid.toString())) {
                retComboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"CommonFilterUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0])), ""));
            } else {
                retComboItems = CommonFilterUtil.getComboItems(entityName, filter, orderBys);
                if (retComboItems.size() == 0) {
                    retComboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"CommonFilterUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0])), ""));
                }
            }
            cbItemStr = SerializationUtils.toJsonString(retComboItems);
            pageCache.put(sscidKey, cbItemStr);
        }
        commonFilterColumn.setComboItems(retComboItems);
        if (isDefaultSelect) {
            commonFilterColumn.setDefaultValue(((ComboItem)retComboItems.get(0)).getValue());
        } else {
            commonFilterColumn.setDefaultValue("");
        }
    }

    public static void resetComboItems(IPageCache pageCache, String cacheKey, CommonFilterColumn commonFilterColumn, String entityName, QFilter filter, Object sscid, boolean isDefaultSelect) {
        CommonFilterUtil.resetComboItems(pageCache, cacheKey, commonFilterColumn, entityName, filter, null, sscid, isDefaultSelect);
    }

    public static QFilter getDeputeOrgOfSSCCenterFilter(IPageCache pageCache, String cacheKey, Object objSSCId) {
        QFilter filter;
        if (objSSCId == null) {
            return null;
        }
        String sscIdStr = CommonFilterUtil.getSscIdListString(objSSCId);
        if (StringUtils.isEmpty((String)sscIdStr) || COMMON_FILTER_SSCID_DEFAULT.equals(sscIdStr) || COMMON_FILTER_SSCID_0.equals(sscIdStr)) {
            return null;
        }
        List<Long> sscIdList = CommonFilterUtil.getSscIdList(sscIdStr);
        String sscidKey = CacheKey.getSSCKey((Object)cacheKey, (Object)sscIdStr);
        String filterStr = pageCache.get(sscidKey);
        if (StringUtils.isNotEmpty((String)filterStr)) {
            filter = QFilter.fromSerializedString((String)filterStr);
        } else {
            HashSet deputeOrgIDs = new HashSet(sscIdList.size());
            for (Long sscId : sscIdList) {
                deputeOrgIDs.addAll(OrgRelationQueryHelper.getFromOrgList((long)sscId));
            }
            if (deputeOrgIDs.isEmpty()) {
                return null;
            }
            filter = new QFilter("id", "in", deputeOrgIDs);
            filterStr = filter.toSerializedString();
            pageCache.put(sscidKey, filterStr);
        }
        return filter;
    }

    public static QFilter getDeputeOrgOfSSCCenterFilter2(IPageCache pageCache, String cacheKey, Object objSSCId) {
        QFilter filter;
        String sscIdStr = objSSCId + "";
        if (objSSCId == null || StringUtils.isEmpty((String)sscIdStr) || COMMON_FILTER_SSCID_DEFAULT.equals(sscIdStr) || COMMON_FILTER_SSCID_0.equals(sscIdStr)) {
            return null;
        }
        Long sscId = Long.valueOf(sscIdStr);
        String sscidKey = CacheKey.getSSCKey((Object)cacheKey, (Object)sscId);
        String filterStr = pageCache.get(sscidKey);
        if (StringUtils.isNotEmpty((String)filterStr)) {
            filter = QFilter.fromSerializedString((String)filterStr);
        } else {
            List deputeOrgIDList = OrgRelationQueryHelper.getFromOrgList((long)sscId);
            if (deputeOrgIDList == null || deputeOrgIDList.size() == 0) {
                return null;
            }
            filter = new QFilter("id", "in", (Object)deputeOrgIDList);
            pageCache.put(sscidKey, filter.toSerializedString());
        }
        return filter;
    }

    public static Object handleCommonFilterNullWhenClickSwitchSSC(FilterContainerSearchClickArgs args, String sscFieldName, List<String> nullFieldValues) {
        return CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, sscFieldName, nullFieldValues, true);
    }

    public static String handleMultiSelectSSC(FilterContainerSearchClickArgs args, String sscFieldName, List<String> nullFieldValues) {
        return CommonFilterUtil.getSscIdListString(CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, sscFieldName, nullFieldValues, false));
    }

    public static Object handleCommonFilterNullWhenClickSwitchSSC(FilterContainerSearchClickArgs args, String sscFieldName, List<String> nullFieldValues, boolean single) {
        boolean isCleared = false;
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map curCommonFilterMap = args.getCurrentCommonFilter();
        if (curCommonFilterMap != null) {
            List curFieldNames = (List)curCommonFilterMap.get("FieldName");
            String curComFieldName = curFieldNames.get(0).toString();
            if (StringUtils.isNotEmpty((String)sscFieldName) && sscFieldName.equalsIgnoreCase(curComFieldName)) {
                isCleared = true;
            }
        }
        Map map = searchClickEvent.getFilterValues();
        List comSelectFilters = (List)map.get("customfilter");
        List sscId = null;
        List sscIdList = Collections.emptyList();
        if (comSelectFilters != null && comSelectFilters.size() > 0) {
            for (int i = 0; i < comSelectFilters.size(); ++i) {
                Map filterMap = (Map)comSelectFilters.get(i);
                List values = (List)filterMap.get("Value");
                List fieldNames = (List)filterMap.get("FieldName");
                String curFieldName = fieldNames.get(0).toString();
                if (StringUtils.isNotEmpty((String)sscFieldName) && sscFieldName.equalsIgnoreCase(curFieldName)) {
                    sscIdList = values;
                    sscId = values.get(0);
                    continue;
                }
                if (!nullFieldValues.contains(curFieldName) || !isCleared) continue;
                values.clear();
            }
        }
        return single ? sscId : sscIdList;
    }

    @Deprecated
    public static void filterContainerInitDefMainOrg(FilterContainer fc, CommonFilterColumn commonFilterColumn, String mainEntityName, String sscId) {
        CommonFilterUtil.filterContainerInitDefMainOrg(fc, commonFilterColumn, mainEntityName, sscId, "");
    }

    public static void filterContainerInitDefMainOrg(FilterContainer fc, CommonFilterColumn commonFilterColumn, String mainEntityName, String sscId, String appId) {
        IDataEntityProperty basedataProp = fc.getEntityType().findProperty(fc.getEntityType().getMainOrg());
        QFilter mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((BasedataProp)((BasedataProp)basedataProp), (String)mainEntityName, (String)appId);
        List<ComboItem> newItems = CommonFilterUtil.getComboItems("bos_org", mainOrgFilter);
        if (newItems != null && newItems.size() > 0) {
            List cbItems = commonFilterColumn.getComboItems();
            cbItems.clear();
            commonFilterColumn.setComboItems(newItems);
        }
        commonFilterColumn.setDefaultValue(sscId);
    }

    public static void createSmartSchemeFilter(CommonFilterColumn filterColumn, Long sscId) {
        List hadComboItems = filterColumn.getComboItems();
        ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u667a\u80fd\u8d28\u68c0\u65b9\u6848", (String)"SmartSchemeManagementListPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0])), COMMON_FILTER_SSCID_0);
        boolean exist = QueryServiceHelper.exists((String)"task_smartcheckscheme", (QFilter[])new QFilter[]{new QFilter("ssccenter", "=", (Object)sscId)});
        if (exist) {
            if (hadComboItems.size() > 1) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
                comboItems.add(comboItem);
                comboItems.addAll(hadComboItems);
                filterColumn.setComboItems(comboItems);
            } else {
                hadComboItems.add(comboItem);
            }
        }
    }

    public static List<ComboItem> handleUserGroupFilter(List<ComboItem> sscItems, boolean isFromSsc, CommonFilterDTO commonFilterDTO) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            commonFilterDTO.getPageCache().put("schemeFilter", SerializationUtils.toJsonString(sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList())));
            return sscItems;
        }
        List<Long> sscIds = sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList()).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        log.info("\u5171\u4eab\u4e2d\u5fc3\u8fc7\u6ee4\u6784\u5efa\u2014\u2014>\u6240\u6709\u5171\u4eab\u4e2d\u5fc3\uff1a" + sscIds);
        Map<String, Boolean> paramBatch = TeamLeaderApi.getParamBatch("usegrouptl", sscIds);
        log.info("\u5171\u4eab\u4e2d\u5fc3\u8fc7\u6ee4\u6784\u5efa\u2014\u2014>\u5171\u4eab\u4e2d\u5fc3\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e\uff1a" + paramBatch);
        Set<String> paramBatchKeys = paramBatch.entrySet().stream().filter(e -> (Boolean)e.getValue()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Boolean)entry.getValue())).keySet();
        log.info("\u5171\u4eab\u4e2d\u5fc3\u8fc7\u6ee4\u6784\u5efa\u2014\u2014>\u542f\u7528\u7ec4\u957f\u7ba1\u7406\u7684\u5171\u4eab\u4e2d\u5fc3\uff1a" + paramBatchKeys);
        if (paramBatchKeys.size() == 0) {
            commonFilterDTO.getPageCache().put("schemeFilter", SerializationUtils.toJsonString(sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList())));
            return sscItems;
        }
        Set<Long> orgs = isFromSsc ? TeamLeaderApi.getOrgByUserAndRole(userId, "HXLFBW8ZGNH", "HXLT47Z1L8S") : TeamLeaderApi.getOrgByUserAndRole(userId, "HXLFBW8ZGNH", "HXLT47Z1L8S", "/JFEAD2U2A1R");
        paramBatchKeys.removeIf(next -> orgs.contains(Long.valueOf(next)));
        log.info("\u5171\u4eab\u4e2d\u5fc3\u8fc7\u6ee4\u6784\u5efa\u2014\u2014>\u542f\u7528\u7ec4\u957f\u7ba1\u7406\u2014\u2014\u767b\u5f55\u4eba\u975e\u7ba1\u7406\u5458\u7684\u5171\u4eab\u4e2d\u5fc3\uff1a" + paramBatchKeys);
        if (paramBatchKeys.size() == 0) {
            commonFilterDTO.getPageCache().put("schemeFilter", SerializationUtils.toJsonString(sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList())));
            return sscItems;
        }
        HashSet<String> manageSsc = UserGroupUtil.getManageSsc(userId);
        if (manageSsc != null && manageSsc.size() > 0) {
            Iterator<String> iterator = paramBatchKeys.iterator();
            while (iterator.hasNext()) {
                if (!manageSsc.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        log.info("\u5171\u4eab\u4e2d\u5fc3\u8fc7\u6ee4\u6784\u5efa\u2014\u2014>\u542f\u7528\u7ec4\u957f\u7ba1\u7406\u2014\u2014\u767b\u5f55\u4eba\u975e\u7ba1\u7406\u5458\u2014\u2014\u767b\u5f55\u4eba\u975e\u7ec4\u957f\u89d2\u8272\u2014\u2014\u7684\u5171\u4eab\u4e2d\u5fc3\uff1a" + paramBatchKeys);
        if (paramBatchKeys.size() == 0) {
            commonFilterDTO.getPageCache().put("schemeFilter", SerializationUtils.toJsonString(sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList())));
            return sscItems;
        }
        Iterator<ComboItem> iterator1 = sscItems.iterator();
        while (iterator1.hasNext()) {
            if (!paramBatchKeys.contains(iterator1.next().getValue())) continue;
            iterator1.remove();
        }
        if (sscItems.size() == 0) {
            commonFilterDTO.getPageCache().put("isright", "false");
        }
        commonFilterDTO.getPageCache().put("schemeFilter", SerializationUtils.toJsonString(sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList())));
        log.info("\u5171\u4eab\u4e2d\u5fc3\u8fc7\u6ee4\u6784\u5efa\u2014\u2014>\u6700\u7ec8\u4f5c\u4e3a\u8fc7\u6ee4\u9879\u7684\u5171\u4eab\u4e2d\u5fc3\uff1a" + commonFilterDTO.getPageCache().get("schemeFilter"));
        return sscItems;
    }

    @Deprecated
    public static void filterContainerBeforeOrgF7Select(FilterContainer fc, List<QFilter> qFilters, String mainEntityName) {
        CommonFilterUtil.filterContainerBeforeOrgF7Select(fc, qFilters, mainEntityName, "");
    }

    public static void filterContainerBeforeOrgF7Select(FilterContainer fc, List<QFilter> qFilters, String mainEntityName, String appId) {
        IDataEntityProperty basedataProp = fc.getEntityType().findProperty(fc.getEntityType().getMainOrg());
        QFilter mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((BasedataProp)((BasedataProp)basedataProp), (String)mainEntityName, (String)appId);
        qFilters.add(mainOrgFilter);
    }

    public static void setCanRemove(List<FilterColumn> filterColumns, boolean can) {
        for (FilterColumn filterColumn : filterColumns) {
            ((CommonFilterColumn)filterColumn).setCanRemove(can);
        }
    }

    public static List<Long> getSscIdList(String sscIdListString) {
        List<Long> sscIds = Collections.emptyList();
        if (sscIdListString != null) {
            String[] strings = sscIdListString.split(",");
            sscIds = Arrays.stream(strings).mapToLong(Long::valueOf).boxed().collect(Collectors.toList());
        }
        return sscIds;
    }

    public static String getSscIdListString(Object sscId) {
        String sscIdString = "";
        if (sscId != null) {
            sscIdString = sscId instanceof List ? ((List)sscId).stream().map(Object::toString).collect(Collectors.joining(",")) : sscId.toString();
        }
        return sscIdString;
    }

    public static boolean hasSsc(Object sscId) {
        if (sscId != null) {
            if (sscId instanceof String) {
                return ((String)sscId).length() != 0;
            }
            if (sscId instanceof List) {
                return !((List)sscId).isEmpty();
            }
        }
        return false;
    }
}

