/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterRow;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.MultQualityCheckSchemeUtil;
import kd.ssc.task.common.smartscheme.SmartQualitySchemeCheck;
import kd.ssc.task.common.workcalendar.CalWorkDateUtil;
import kd.ssc.task.dis.TaskAutoDisTaskPro;
import kd.ssc.task.util.TaskDateUtil;
import kd.ssc.task.util.UserUtil;
import kd.ssc.task.workcalendar.pojo.RemainingTimeInfo;
import kd.ssc.task.workcalendar.pojo.SimpleJob;

public class QualityCheckSchemeUtil {
    private static Log log = LogFactory.getLog(QualityCheckSchemeUtil.class);
    private static final int INITCALENDARYEARRANGE = 1;
    private static final String FIELD_QUALITYMESSAGERECORD = "point,qualitycheck,ischeckok,rebackcount,handlemethod,reviewmethod, entryentity.message,entryentity.datetime,entryentity.messagetype,entryentity.usercheck, entryentity.isnewmessage";
    private static final String NUMBER_NEXT_BASEXTENDERP = "KDCC";

    public static Map<String, Object> qualityCheckByImplement(DynamicObject scheme, boolean isSmart) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        int sum = 0;
        try {
            int successCount = QualityCheckSchemeUtil.qualityCheck(scheme, isSmart);
            result.put("num", sum += successCount);
        }
        catch (Exception e) {
            sum = -1;
            result.put("num", sum);
            result.put("error", e.getMessage());
            log.error(scheme.getPkValue() + "\u62bd\u68c0\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public static int qualityCheck(DynamicObject checkScheme, boolean isSmart) {
        int retCount = 0;
        DynamicObject[] entities = QualityCheckSchemeUtil.createQualitySampleLibrary(checkScheme, isSmart);
        try {
            retCount = isSmart ? SmartQualitySchemeCheck.executeQualityCheckTask(checkScheme, entities) : MultQualityCheckSchemeUtil.excuteQualityCheckTask(checkScheme, entities);
        }
        catch (Exception e) {
            log.error("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e,QualityCheckSchemeUtil.class.qualityCheck():", (Throwable)e);
            throw e;
        }
        finally {
            QualityCheckSchemeUtil.afterExcuteOperation(checkScheme, entities, retCount);
        }
        return retCount;
    }

    public static DynamicObject[] createQualitySampleLibrary(DynamicObject checkScheme, boolean isSmart) {
        DynamicObject sampleLibInfo = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitysamplelibrary");
        String qslNumber = QualityCheckSchemeUtil.getQualitySampleLibraryNumber(checkScheme.getString("number"));
        String simplename = String.format(ResManager.loadKDString((String)"%s-\u6837\u672c\u5e93", (String)"QualityCheckSchemeUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), checkScheme.getString("number"));
        Object userId = UserUtil.getUserID();
        Date startDate = new Date(System.currentTimeMillis());
        Date startTime = TaskDateUtil.formatDate((Date)startDate, (String)"yyyy-MM-dd HH:mm");
        sampleLibInfo.set("number", (Object)qslNumber);
        sampleLibInfo.set("name", (Object)qslNumber);
        sampleLibInfo.set("simplename", (Object)simplename);
        sampleLibInfo.set("status", (Object)"C");
        sampleLibInfo.set("creator", userId);
        sampleLibInfo.set("createtime", (Object)startTime);
        sampleLibInfo.set("enable", (Object)1);
        sampleLibInfo.set("checkscheme", checkScheme.get("id"));
        sampleLibInfo.set("description", checkScheme.get("description"));
        sampleLibInfo.set("state", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        sampleLibInfo.set("expirestate", (Object)"1");
        if (isSmart) {
            sampleLibInfo.set("smartcheckscheme", checkScheme.get("id"));
            sampleLibInfo.set("issmart", (Object)"1");
        }
        long id = DB.genLongId((String)"t_tk_checksamplelibrary");
        sampleLibInfo.set("id", (Object)id);
        DynamicObject[] entities = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sampleLibInfo});
        entities = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (DynamicObjectType)sampleLibInfo.getDynamicObjectType());
        log.info(String.format("\u7f16\u7801\uff1a%s \u7684\u6837\u672c\u5e93\u751f\u6210\u6210\u529f!", qslNumber));
        return entities;
    }

    public static int createQualityCheckTask(DynamicObject[] entities, DynamicObject checkScheme, List<DynamicObject> qualityCheckSet) {
        int ret = 0;
        if (entities == null || entities.length == 0) {
            log.info("\u8d28\u68c0\u6837\u672c\u5e93\u4e0d\u80fd\u4e3a\u7a7a!");
            return ret;
        }
        if (qualityCheckSet == null || qualityCheckSet.size() == 0) {
            log.info("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\u8d28\u68c0\u4efb\u52a1!");
            return ret;
        }
        DynamicObject sampleLibrary = entities[0];
        Object sampleLibraryId = sampleLibrary.getPkValue();
        DynamicObject qualitychecktasktype = (DynamicObject)checkScheme.get("qualitychecktasktype");
        String dismethod = checkScheme.getString("dismethod");
        Object tasktypeid = qualitychecktasktype.getPkValue();
        String autoprocessforcheck = checkScheme.getString("isautoprocess");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HHmmssSSS");
        Iterator<DynamicObject> iter = qualityCheckSet.iterator();
        ArrayList<DynamicObject> needSaveTasks = new ArrayList<DynamicObject>(10);
        while (iter.hasNext()) {
            DynamicObject task = iter.next();
            DynamicObject qualityCheckTask = BusinessDataServiceHelper.newDynamicObject((String)"task_task");
            String date = sdf.format(new Date());
            qualityCheckTask.set("billno", (Object)String.format("ZJRW-%s", date));
            qualityCheckTask.set("sourcetaskid", task.get("id"));
            qualityCheckTask.set("subject", task.get("subject"));
            qualityCheckTask.set("billtype", (Object)task.getLong("billtype"));
            String billId = task.getString("billid");
            qualityCheckTask.set("billid", (Object)billId);
            if (StringUtils.isNumeric((CharSequence)billId)) {
                qualityCheckTask.set("billlongid", (Object)Long.parseLong(billId));
            }
            qualityCheckTask.set("tasktypeid", tasktypeid);
            qualityCheckTask.set("billnumber", task.get("billnumber"));
            qualityCheckTask.set("bizdata_tag", task.get("bizdata_tag"));
            qualityCheckTask.set("orgid", task.get("orgid"));
            qualityCheckTask.set("sscid", task.get("sscid"));
            qualityCheckTask.set("billstatus", (Object)"A");
            qualityCheckTask.set("pooltype", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
            qualityCheckTask.set("qualitystate", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
            qualityCheckTask.set("taskcreatetime", (Object)new Date());
            qualityCheckTask.set("creator", task.get("creator"));
            qualityCheckTask.set("source", task.get("source"));
            qualityCheckTask.set("qualitysamplelibrary", sampleLibraryId);
            qualityCheckTask.set("innermsg", task.get("innermsg"));
            qualityCheckTask.set("apprevalmessage", task.get("apprevalmessage"));
            if ("1".equals(dismethod)) {
                qualityCheckTask.set("state", (Object)TaskStateEnum.TO_BE_DIS.getValue());
            } else {
                qualityCheckTask.set("state", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
            }
            qualityCheckTask.set("tasklevelid", task.get("tasklevelid"));
            qualityCheckTask.set("createruleid", task.get("createruleid"));
            qualityCheckTask.set("imageok", task.get("imageok"));
            qualityCheckTask.set("flagmsg", task.get("flagmsg"));
            qualityCheckTask.set("createtime", (Object)new Date());
            qualityCheckTask.set("imageuploadtime", task.get("imageuploadtime"));
            qualityCheckTask.set("coefficient", task.get("coefficient"));
            qualityCheckTask.set("multistate", task.get("multistate"));
            qualityCheckTask.set("resttime", checkScheme.get("taskduration"));
            qualityCheckTask.set("level", task.get("level"));
            qualityCheckTask.set("expirestate", (Object)"1");
            qualityCheckTask.set("extenderp", task.get("extenderp"));
            qualityCheckTask.set("autoprocess", task.get("autoprocess"));
            qualityCheckTask.set("auditor", task.get("auditor"));
            qualityCheckTask.set("assignid", task.get("assignid"));
            qualityCheckTask.set("procinstid", task.get("procinstid"));
            qualityCheckTask.set("oldtaskstate", task.get("oldtaskstate"));
            qualityCheckTask.set("recyclestate", task.get("recyclestate"));
            qualityCheckTask.set("unpassreasonid", task.get("unpassreasonid"));
            qualityCheckTask.set("info", task.get("info"));
            qualityCheckTask.set("consignerid", task.get("consignerid"));
            qualityCheckTask.set("flowbackstgid", task.get("flowbackstgid"));
            qualityCheckTask.set("waittime", task.get("waittime"));
            qualityCheckTask.set("pausewaittime", task.get("pausewaittime"));
            qualityCheckTask.set("rescanwaittime", task.get("rescanwaittime"));
            qualityCheckTask.set("costwaittime", task.get("costwaittime"));
            qualityCheckTask.set("allocatecount", task.get("allocatecount"));
            qualityCheckTask.set("islastaudit", task.get("islastaudit"));
            qualityCheckTask.set("hasallocated", task.get("hasallocated"));
            qualityCheckTask.set("imagenumber", task.get("imagenumber"));
            qualityCheckTask.set("reverseoprt", task.get("reverseoprt"));
            qualityCheckTask.set("oprt", task.get("oprt"));
            qualityCheckTask.set("sysbillid", task.get("sysbillid"));
            qualityCheckTask.set("orglongnumber", task.get("orglongnumber"));
            qualityCheckTask.set("unpassreasondesc", task.get("unpassreasondesc"));
            Boolean isAutoprocess = task.getBoolean("autoprocess");
            if (!isAutoprocess.booleanValue()) {
                qualityCheckTask.set("reformperson", task.get("personid"));
            }
            qualityCheckTask.set("qualityresult", (Object)"");
            qualityCheckTask.set("autoprocessforcheck", (Object)autoprocessforcheck);
            needSaveTasks.add(qualityCheckTask);
        }
        DynamicObject[] qualityCheckTaskArray = new DynamicObject[needSaveTasks.size()];
        needSaveTasks.toArray(qualityCheckTaskArray);
        Object[] saveRet = SaveServiceHelper.save((DynamicObject[])qualityCheckTaskArray);
        if (saveRet != null && saveRet.length > 0) {
            ret = saveRet.length;
            log.info(String.format("\u8d28\u68c0\u4efb\u52a1\u751f\u6210\u6210\u529f\uff0c\u5171\u751f\u6210%s\u6761\u8d28\u68c0\u4efb\u52a1", ret));
        }
        return ret;
    }

    public static void handleDispatcherTask(DynamicObject checkScheme, DynamicObject[] entities) {
        String dismethod = checkScheme.getString("dismethod");
        if ("1".equals(dismethod)) {
            ArrayList<Object> libIds = new ArrayList<Object>(10);
            for (DynamicObject item : entities) {
                libIds.add(item.get("id"));
            }
            TaskAutoDisTaskPro taskAutoDisTaskPro = new TaskAutoDisTaskPro();
            QFilter filterSampleLibId = new QFilter("qualitysamplelibrary", "in", libIds);
            QFilter stateFil = new QFilter("state", "!=", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
            taskAutoDisTaskPro.autdoDis(filterSampleLibId.and(stateFil), DisTaskSourceEnum.AUTO_DIS_2, false);
        }
    }

    private static void afterExcuteOperation(DynamicObject checkScheme, DynamicObject[] libEntities, int retCount) {
        if (libEntities == null || libEntities.length == 0) {
            return;
        }
        if (retCount == 0) {
            ArrayList<Object> ids = new ArrayList<Object>(10);
            for (DynamicObject dy : libEntities) {
                ids.add(dy.getPkValue());
            }
            QFilter filter = new QFilter("id", "in", ids);
            QFilter quaSamplFilter = new QFilter("qualitysamplelibrary", "in", ids);
            DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{quaSamplFilter});
            DeleteServiceHelper.delete((String)"task_qualitysamplelibrary", (QFilter[])new QFilter[]{filter});
            log.info(String.format("\u8d28\u68c0\u4efb\u52a1\u751f\u62100\u6761\uff0c\u6e05\u9664\u5df2\u751f\u6210\u7684\u8d28\u68c0\u6837\u677f\u5e93\uff1a%s", ids));
        } else {
            checkScheme.set("status", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkScheme});
            String dismethod = checkScheme.getString("dismethod");
            if ("1".equals(dismethod)) {
                for (DynamicObject dy : libEntities) {
                    Object id = dy.get("id");
                    if (!QualityCheckSchemeUtil.isExistUndispatcheredTask(id)) {
                        dy.set("state", (Object)"1");
                    }
                    dy.set("totalnum", (Object)retCount);
                    dy.set("status", (Object)"C");
                }
            } else {
                for (DynamicObject dy : libEntities) {
                    dy.set("totalnum", (Object)retCount);
                    dy.set("status", (Object)"C");
                }
            }
            SaveServiceHelper.save((DynamicObject[])libEntities);
        }
    }

    public static List<DynamicObject> getNextValidTaskSet(DynamicObjectCollection nextDys, FilterObject filterObject, String formNumber) {
        DynamicObjectCollection dyVoucherCol;
        ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
        if (nextDys == null || nextDys.size() == 0) {
            return ret;
        }
        QFilter filter = filterObject == null ? null : filterObject.getQFilter();
        HashMap<Long, List> taskMap = new HashMap<Long, List>(16);
        HashSet<Long> voucherIds = new HashSet<Long>();
        for (DynamicObject task : nextDys) {
            long billId = task.getLong("billid");
            voucherIds.add(billId);
            List taskIdsForBill = taskMap.computeIfAbsent(billId, k -> new ArrayList(128));
            taskIdsForBill.add(task);
        }
        QFilter filterBillId = new QFilter("id", "in", voucherIds);
        if (filter != null) {
            filterBillId.and(filter);
        }
        if ((dyVoucherCol = QueryServiceHelper.query((String)formNumber, (String)"id", (QFilter[])filterBillId.toArray())) == null || dyVoucherCol.size() == 0) {
            return ret;
        }
        Long voucherId = 0L;
        List dyTask = null;
        for (DynamicObject item : dyVoucherCol) {
            voucherId = item.getLong("id");
            dyTask = (List)taskMap.remove(voucherId);
            if (dyTask == null) continue;
            ret.addAll(dyTask);
        }
        return ret;
    }

    public static List<DynamicObject> getEasValidTaskSet(DynamicObjectCollection easDyCols, FilterObject filterObject, String formNumber) {
        ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
        if (easDyCols == null || easDyCols.size() == 0) {
            return ret;
        }
        for (DynamicObject easTask : easDyCols) {
            String bizdata = easTask.getString("bizdata_tag");
            boolean isExist = false;
            try {
                DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(BusinessDataServiceHelper.newDynamicObject((String)formNumber).getDynamicObjectType());
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
                isExist = QualityCheckSchemeUtil.isExistFilterToEas(filterObject, dataEntity);
                if (!isExist) continue;
                ret.add(easTask);
            }
            catch (Exception e) {
                log.error(String.format("\u83b7\u53d6EAS\u5b58\u5728\u5355\u636e\u7684\u4efb\u52a1\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", e));
            }
        }
        return ret;
    }

    private static boolean isExistFilterToEas(FilterObject filterObject, DynamicObject dataEntity) {
        if (filterObject == null) {
            return true;
        }
        List filterRow = filterObject.getFilterRows();
        String filterStr = filterObject.getQFilter().toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        FilterField filterField = null;
        String entityKey = null;
        String fieldname = null;
        String key = null;
        Object value = null;
        for (int i = 0; i < filterRow.size(); ++i) {
            filterField = ((FilterRow)filterRow.get(i)).getFilterField();
            entityKey = filterField.getEntityKey();
            fieldname = filterField.getFieldName();
            key = filterField.getFullFieldName();
            if (StringUtils.isNotBlank((CharSequence)entityKey)) {
                DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection(entityKey);
                for (DynamicObject item : entities) {
                    value = item.get(fieldname);
                }
            } else {
                value = dataEntity.get(key);
            }
            map.put(key, value);
        }
        Object result = FormulaEngine.execExcelFormula((String)filterStr, map);
        return (Boolean)result;
    }

    public static String getBillIDNumber(String formId) {
        QFilter filterbindbill = new QFilter("id", "=", (Object)formId);
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{filterbindbill});
        if (formMeta == null) {
            return null;
        }
        return formMeta.getString("number");
    }

    public static DynamicObject getTaskBill(Object billTypeId) {
        if (billTypeId == null) {
            return null;
        }
        QFilter filterId = new QFilter("id", "=", billTypeId);
        String selectFields = "id, externalerp.id, bindbill.id";
        return BusinessDataServiceHelper.loadSingle((String)"task_taskbill", (String)selectFields, (QFilter[])new QFilter[]{filterId});
    }

    public static DynamicObject getExtendErp(Object erpId) {
        if (erpId == null) {
            return null;
        }
        QFilter filterErpId = new QFilter("id", "=", erpId);
        return BusinessDataServiceHelper.loadSingle((String)"bas_extenderp", (String)"id, number", (QFilter[])new QFilter[]{filterErpId});
    }

    private static String getQualitySampleLibraryNumber(String number) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        String cruDate = sdf.format(new Date());
        return String.format("%s-%s", number, cruDate);
    }

    public static Date getPlanFinishTime(DynamicObject checkScheme, Date startDate) {
        if (checkScheme == null || checkScheme.get("taskduration") == null) {
            return startDate;
        }
        int plantTime = checkScheme.getInt("taskduration");
        Date planFinishDate = new Date(startDate.getTime() + (long)(3600000 * plantTime));
        try {
            DynamicObject dySSCCenter = checkScheme.getDynamicObject("ssccenter");
            Long sscCenterId = dySSCCenter.getLong("id");
            Calendar initCalendar = Calendar.getInstance();
            initCalendar.setTime(startDate);
            initCalendar.add(1, 1);
            Date initEndDate = initCalendar.getTime();
            CalWorkDateUtil workDateUtil = CalWorkDateUtil.getInstance(sscCenterId, startDate, initEndDate, "ssc");
            planFinishDate = workDateUtil.getNextWorkTime(workDateUtil.getDailyWorkPeriods(new SimpleJob(sscCenterId)), startDate, plantTime * 60);
        }
        catch (Exception e) {
            log.error("kd.ssc.task.common.QualityCheckSchemeUtil.getPlanFinishTime:\u83b7\u53d6\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u5931\u8d25", (Throwable)e);
        }
        return planFinishDate;
    }

    public static void setStartTime(DynamicObject disTask, Date date) {
        QFilter qFilter = new QFilter("id", "=", (Object)disTask.getLong("qualitysamplelibrary.id"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_qualitysamplelibrary", (String)"checkscheme,checkbegintime,planFinishTime", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null || dynamicObject.get("checkbegintime") != null) {
            return;
        }
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitysamplelibrary");
        dyo.set("id", (Object)disTask.getLong("qualitysamplelibrary.id"));
        dyo.set("checkbegintime", (Object)date);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
    }

    public static void setStartTimeBatch(Map<DynamicObject, Date> setStartTimeMap) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<DynamicObject, Date> entry : setStartTimeMap.entrySet()) {
            DynamicObject disTask = entry.getKey();
            Date date = entry.getValue();
            QFilter qFilter = new QFilter("id", "=", (Object)disTask.getLong("qualitysamplelibrary.id"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_qualitysamplelibrary", (String)"checkscheme,checkbegintime,planFinishTime", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject == null || dynamicObject.get("checkbegintime") != null) {
                return;
            }
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitysamplelibrary");
            dyo.set("id", (Object)disTask.getLong("qualitysamplelibrary.id"));
            dyo.set("checkbegintime", (Object)date);
            dynamicObjectList.add(dyo);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
    }

    public static void setPlanEndTime(DynamicObject[] unDisTaskcol) {
        HashSet<Object> unDisTaskDynaObjIdSet = new HashSet<Object>();
        HashMap<Long, Date> receivetimeMap = new HashMap<Long, Date>();
        for (DynamicObject unDisTaskDynaObj : unDisTaskcol) {
            if (unDisTaskDynaObj.getLong("qualitysamplelibrary.id") <= 0L) continue;
            unDisTaskDynaObjIdSet.add(unDisTaskDynaObj.getPkValue());
            Date receiveTime = unDisTaskDynaObj.getDate("receivetime");
            if (receiveTime == null) continue;
            if (receivetimeMap.get(unDisTaskDynaObj.getLong("qualitysamplelibrary.id")) == null) {
                receivetimeMap.put(unDisTaskDynaObj.getLong("qualitysamplelibrary.id"), unDisTaskDynaObj.getDate("receivetime"));
                continue;
            }
            Date curDate = (Date)receivetimeMap.get(unDisTaskDynaObj.getLong("qualitysamplelibrary.id"));
            if (unDisTaskDynaObj.get("receivetime") == null || curDate.compareTo(unDisTaskDynaObj.getDate("receivetime")) >= 0) continue;
            receivetimeMap.put(unDisTaskDynaObj.getLong("qualitysamplelibrary.id"), unDisTaskDynaObj.getDate("receivetime"));
        }
        for (Map.Entry entry : receivetimeMap.entrySet()) {
            boolean planFinishTimeWriteFlag = true;
            QFilter idQFil = new QFilter("qualitysamplelibrary", "=", entry.getKey());
            DynamicObject[] libEntities = BusinessDataServiceHelper.load((String)"task_task", (String)"id,pooltype", (QFilter[])new QFilter[]{idQFil});
            for (DynamicObject dy : libEntities) {
                Object qualitystate = dy.get("pooltype");
                if (qualitystate == null || !StringUtils.equals((CharSequence)qualitystate.toString(), (CharSequence)TaskPoolTypeEnum.TO_BE_DIS.getValue()) || unDisTaskDynaObjIdSet.contains(dy.getPkValue())) continue;
                planFinishTimeWriteFlag = false;
            }
            if (!planFinishTimeWriteFlag) continue;
            DynamicObject checkScheme = QualityCheckSchemeUtil.getQualityCheckScheme(Long.parseLong(entry.getKey() + ""));
            Date planFinishTime = QualityCheckSchemeUtil.getPlanFinishTime(checkScheme, (Date)entry.getValue());
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitysamplelibrary");
            dyo.set("id", entry.getKey());
            dyo.set("planFinishTime", (Object)planFinishTime);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
        }
    }

    public static List<String> getQualityState(List<String> sampleLibState) {
        ArrayList<String> ret = new ArrayList<String>();
        if (sampleLibState == null || sampleLibState.size() == 0) {
            return ret;
        }
        for (String state : sampleLibState) {
            if ("0".equals(state)) {
                ret.add("0");
                continue;
            }
            if ("1".equals(state)) {
                ret.add("1");
                ret.add("2");
                ret.add("3");
                continue;
            }
            if ("5".equals(state)) {
                ret.add("5");
                continue;
            }
            if (!"4".equals(state)) continue;
            ret.add("4");
        }
        return ret;
    }

    public static String stateTransfer(String qualitySampLibState) {
        String poolType = TaskPoolTypeEnum.TO_BE_DIS.getValue();
        if (StringUtils.isEmpty((CharSequence)qualitySampLibState)) {
            return poolType;
        }
        switch (qualitySampLibState) {
            case "1": {
                poolType = TaskPoolTypeEnum.PROCESSING.getValue();
                break;
            }
            case "4": 
            case "5": {
                poolType = TaskPoolTypeEnum.COMPLETE.getValue();
                break;
            }
        }
        return poolType;
    }

    public static int getUnCompleteQualityCheckTask(long sampleLibId) {
        ORM orm = ORM.create();
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)sampleLibId);
        String selectFields = "id,qualitysamplelibrary,qualitystate";
        DataSet unCompleteDataSet = orm.queryDataSet("kd.ssc.task.common.QualityCheckSchemeUtil.getUnCompleteQualityCheckTask", "task_task", selectFields, new QFilter[]{filterLibId});
        if (unCompleteDataSet == null) {
            return 0;
        }
        return unCompleteDataSet.count("id", false);
    }

    public static boolean isCompleteQualityCheckLibrary(long sampleLibId) {
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)sampleLibId);
        return !QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId});
    }

    public static boolean isExistToDoQualityCheckTask(long sampleLibId) {
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)sampleLibId);
        QFilter poolTypeFil = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId, poolTypeFil});
    }

    public static boolean isExistProcessQualityCheckTask(long sampleLibId) {
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)sampleLibId);
        QFilter poolTypeFil = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        if (QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId, poolTypeFil})) {
            return true;
        }
        return QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{filterLibId});
    }

    public static void changeQualitySampleLib4DisTask(Set<Long> successSampleLibIds) {
        String algoKey = QualityCheckSchemeUtil.class + ".changeQualitySampleLib()";
        QFilter libIdFil = new QFilter("qualitysamplelibrary", "in", successSampleLibIds);
        QFilter poolTypeFil = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        DataSet resultData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_task", (String)"id,qualitysamplelibrary", (QFilter[])new QFilter[]{libIdFil, poolTypeFil}, null);
        HashSet<Long> libIds = new HashSet<Long>(8);
        for (Row row : resultData) {
            libIds.add(row.getLong("qualitysamplelibrary"));
        }
        if (!libIds.isEmpty()) {
            successSampleLibIds.removeAll(libIds);
        }
        HashMap<Long, Map<String, Object>> changeInfo = new HashMap<Long, Map<String, Object>>(8);
        HashMap<String, String> changeData = new HashMap<String, String>(1);
        changeData.put("state", "1");
        successSampleLibIds.forEach(p -> changeInfo.put((Long)p, (Map<String, Object>)changeData));
        QualityCheckSchemeUtil.batchChangeQualitySampleLib(changeInfo);
    }

    public static boolean changeQualitySampleLib(long sampleLibId, Map<String, Object> changeData) {
        if (sampleLibId == 0L || changeData == null) {
            return false;
        }
        HashMap<Long, Map<String, Object>> changeInfo = new HashMap<Long, Map<String, Object>>(1);
        changeInfo.put(sampleLibId, changeData);
        return QualityCheckSchemeUtil.batchChangeQualitySampleLib(changeInfo);
    }

    public static boolean batchChangeQualitySampleLib(Map<Long, Map<String, Object>> changeInfo) {
        DynamicObject[] sampleLibs;
        if (changeInfo == null || CollectionUtils.isEmpty(changeInfo)) {
            return false;
        }
        Set<Long> sampleLibIds = changeInfo.keySet();
        QFilter fiterSampleLibId = new QFilter("id", "in", sampleLibIds);
        String selectFields = "id,number,planfinishtime,checkbegintime,checkcompletetime,state,totalnum,completednum,expirestate";
        for (DynamicObject sampleLib : sampleLibs = BusinessDataServiceHelper.load((String)"task_qualitysamplelibrary", (String)selectFields, (QFilter[])new QFilter[]{fiterSampleLibId})) {
            Object begintime;
            Long sampleLibId = sampleLib.getLong("id");
            Map<String, Object> changeData = changeInfo.get(sampleLibId);
            if (changeData == null || CollectionUtils.isEmpty(changeData)) {
                log.warn(String.format(".batchChangeQualitySampleLib().changeData = %s, sampleLibId = %s", changeData, sampleLibId));
                continue;
            }
            Object checkbegintime = changeData.get("checkbegintime");
            Object checkcompletetime = changeData.get("checkcompletetime");
            Object state = changeData.get("state");
            Object addnum = changeData.get("addnum");
            Object delnum = changeData.get("delnum");
            if (null != checkbegintime && (begintime = sampleLib.get("checkbegintime")) == null) {
                sampleLib.set("checkbegintime", checkbegintime);
            }
            if (null != checkcompletetime) {
                sampleLib.set("checkcompletetime", checkcompletetime);
            }
            if (null != state) {
                sampleLib.set("state", state);
            }
            if (null != addnum) {
                sampleLib.set("completednum", (Object)(sampleLib.getInt("completednum") + (Integer)addnum));
            }
            if (null != delnum) {
                sampleLib.set("totalnum", (Object)(sampleLib.getInt("totalnum") - (Integer)delnum));
            }
            sampleLib.set("expirestate", changeData.get("expirestate"));
        }
        Object[] ret = SaveServiceHelper.save((DynamicObject[])sampleLibs);
        if (ret != null && ret.length > 0) {
            return true;
        }
        log.info("\u6279\u91cf\u66f4\u65b0\u8d28\u68c0\u6837\u672c\u5e93\u72b6\u6001\u5931\u8d25");
        return false;
    }

    public static boolean changeQualitySampleLib(Long libId, int delNum) {
        HashMap<String, Object> changeData = new HashMap<String, Object>(2);
        changeData.put("delnum", delNum);
        String newLibState = QualityCheckSchemeUtil.getLibState(libId);
        if (StringUtils.isNotEmpty((CharSequence)newLibState)) {
            changeData.put("state", newLibState);
        }
        changeData.put("expirestate", QualityCheckSchemeUtil.getLibExpireState(libId));
        return QualityCheckSchemeUtil.changeQualitySampleLib((long)libId, changeData);
    }

    public static String getLibState(Long libId) {
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)libId);
        QFilter filterProcess = new QFilter("pooltype", "in", Arrays.asList(TaskPoolTypeEnum.PROCESSING.getValue(), "2", "3", "6"));
        String newLibState = "";
        QFilter filterComplete = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        QFilter filterClose = new QFilter("qualitystate", "=", (Object)"5");
        QFilter filterUndistributed = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        if (QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId, filterUndistributed})) {
            newLibState = "0";
        } else if (QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId, filterProcess})) {
            newLibState = "1";
        } else if (QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{filterLibId, filterComplete})) {
            newLibState = "4";
        } else if (QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{filterLibId, filterClose})) {
            newLibState = "5";
        }
        return newLibState;
    }

    public static String getLibExpireState(Long libId) {
        QFilter filterPoolType = new QFilter("pooltype", "in", Arrays.asList(TaskPoolTypeEnum.PROCESSING, TaskPoolTypeEnum.COMPLETE));
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)libId);
        QFilter filterExpireState = new QFilter("expirestate", "=", (Object)"2");
        String expireStateEnum = QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId, filterPoolType, filterExpireState}) || QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{filterLibId, filterPoolType, filterExpireState}) ? "2" : "1";
        return expireStateEnum;
    }

    public static boolean changeQualitySampleLib(Map<Long, RemainingTimeInfo> remainingTimeInfo) {
        DynamicObject[] sampleLibs;
        if (remainingTimeInfo == null || remainingTimeInfo.size() == 0) {
            return false;
        }
        HashSet taskIds = new HashSet(8);
        remainingTimeInfo.forEach((key, value) -> {
            String expireState = value.getExpireState();
            if ("2".equals(expireState)) {
                taskIds.add(key);
            }
        });
        if (taskIds.size() == 0) {
            return false;
        }
        QFilter idFil = new QFilter("id", "in", taskIds);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_task", (String)"qualitysamplelibrary", (QFilter[])new QFilter[]{idFil});
        HashSet sampleLibIds = new HashSet(8);
        tasks.forEach(p -> sampleLibIds.add(p.getLong("qualitysamplelibrary")));
        QFilter sampleLibIdFil = new QFilter("id", "in", sampleLibIds);
        for (DynamicObject sampleLib : sampleLibs = BusinessDataServiceHelper.load((String)"task_qualitysamplelibrary", (String)"id,expirestate", (QFilter[])new QFilter[]{sampleLibIdFil})) {
            sampleLib.set("expirestate", (Object)"2");
        }
        Object[] ret = SaveServiceHelper.save((DynamicObject[])sampleLibs);
        if (ret != null && ret.length > 0) {
            log.info(String.format("\u6210\u529f\u66f4\u65b0\u6837\u672c\u5e93ID\u4e3a%s\u7684\u8d85\u671f\u72b6\u6001", sampleLibIds));
            return true;
        }
        return false;
    }

    public static boolean changeQualityCheckHistoryTaskState(long sampleLibId, Map<String, Object> changeData) {
        DynamicObject[] historyTasks;
        if (sampleLibId == 0L || changeData == null) {
            return false;
        }
        Object state = changeData.get("state");
        QFilter fiterSampleLibId = new QFilter("qualitysamplelibrary", "=", (Object)sampleLibId);
        String selectFields = "id,qualitysamplelibrary,qualitystate";
        for (DynamicObject item : historyTasks = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)selectFields, (QFilter[])new QFilter[]{fiterSampleLibId})) {
            item.set("qualitystate", state);
        }
        Object[] ret = SaveServiceHelper.save((DynamicObject[])historyTasks);
        if (ret != null && ret.length > 0) {
            log.info(String.format("\u6210\u529f\u66f4\u8d28\u68c0\u4efb\u52a1\u6837\u672c\u5e93ID\u4e3a%s\u72b6\u6001,\u53d8\u66f4\u4fe1\u606f\u4e3a\uff1a%s", sampleLibId, changeData));
            return true;
        }
        return false;
    }

    public static boolean isExistUndispatcheredTask(List<Object> libraryIds) {
        QFilter filderId = new QFilter("qualitysamplelibrary", "in", libraryIds);
        QFilter filterPoolType = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        ORM orm = ORM.create();
        return orm.exists("task_task", new QFilter[]{filderId, filterPoolType});
    }

    public static boolean isExistUndispatcheredTask(Object libId) {
        return QualityCheckSchemeUtil.isExistUndispatcheredTask(Collections.singletonList(libId));
    }

    public static int getDispatcherResult(Object[] selectedRowIds) {
        if (selectedRowIds == null || selectedRowIds.length == 0) {
            return 0;
        }
        QFilter filterId = new QFilter("id", "in", (Object)selectedRowIds);
        QFilter filterPerson = new QFilter("personid", ">", (Object)0);
        ORM orm = ORM.create();
        int count = orm.queryDataSet("kd.ssc.task.common.QualityCheckSchemeUtil.getDispatcherResult", "task_task", "id", new QFilter[]{filterId, filterPerson}).count("id", false);
        if (count > 0 && count == selectedRowIds.length) {
            return 2;
        }
        if (count > 0 && count < selectedRowIds.length) {
            return 1;
        }
        return 0;
    }

    public static Set<Long> getExtractedTaskByOtherSchemes(Long checkSchemeId) {
        HashSet<Long> extractedTaskIds = new HashSet<Long>();
        DynamicObject[] sampleLibraries = null;
        QFilter[] filters = null;
        if (checkSchemeId != null) {
            filters = new QFilter("checkscheme", "=", (Object)checkSchemeId).toArray();
        }
        if ((sampleLibraries = BusinessDataServiceHelper.load((String)"task_qualitysamplelibrary", (String)"id", filters)) != null && sampleLibraries.length > 0) {
            DynamicObject[] historyTasks;
            ArrayList<Long> libIds = new ArrayList<Long>(10);
            for (DynamicObject object : sampleLibraries) {
                libIds.add(object.getLong("id"));
            }
            QFilter filterLibId = new QFilter("qualitysamplelibrary", "in", libIds);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"id,sourcetaskid", (QFilter[])new QFilter[]{filterLibId});
            if (tasks != null && tasks.length > 0) {
                for (DynamicObject task : tasks) {
                    extractedTaskIds.add(task.getLong("sourcetaskid"));
                }
            }
            if ((historyTasks = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"id,sourcetaskid", (QFilter[])new QFilter[]{filterLibId})) != null && historyTasks.length > 0) {
                for (DynamicObject task : historyTasks) {
                    extractedTaskIds.add(task.getLong("sourcetaskid"));
                }
            }
        }
        return extractedTaskIds;
    }

    public static boolean isQualityCheckTask(Object[] selectedRowIds, String entityName) {
        QFilter filterId = new QFilter("id", "in", (Object)selectedRowIds);
        QFilter filterLibId = new QFilter("qualitysamplelibrary", ">", (Object)0);
        ORM orm = ORM.create();
        return orm.exists(entityName, new QFilter[]{filterId, filterLibId});
    }

    public static DynamicObject[] getSampleLibrarysBySchemeId(Object[] schemeIds) {
        if (schemeIds == null || schemeIds.length == 0) {
            return null;
        }
        QFilter filterId = new QFilter("checkscheme", "in", (Object)schemeIds);
        String selectFields = "id,number,checkscheme,state";
        DynamicObject[] sampleLibraryArray = BusinessDataServiceHelper.load((String)"task_qualitysamplelibrary", (String)selectFields, (QFilter[])new QFilter[]{filterId});
        return sampleLibraryArray;
    }

    public static boolean deleteUnassignedTask(Object[] libIds) {
        if (libIds == null || libIds.length == 0) {
            return false;
        }
        QFilter filterLibId = new QFilter("qualitysamplelibrary", "in", (Object)libIds);
        QFilter filterUnassignedState = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        int ret = DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{filterLibId, filterUnassignedState});
        return ret > 0;
    }

    public static List<DynamicObject> getUnqualifiedCheckPoint(Long quaCheckTaskID, Long sampleLibraryId) {
        Long smartSchemeId;
        Long schemeId;
        ArrayList<DynamicObject> failPoints = new ArrayList<DynamicObject>(8);
        QFilter filterLibId = new QFilter("id", "=", (Object)sampleLibraryId);
        DynamicObject sampleLibrary = QueryServiceHelper.queryOne((String)"task_qualitysamplelibrary", (String)"checkscheme,issmart,smartcheckscheme", (QFilter[])new QFilter[]{filterLibId});
        if (sampleLibrary == null) {
            return failPoints;
        }
        boolean isSmart = sampleLibrary.getBoolean("issmart");
        Map<Long, DynamicObject> checkPoints = QualityCheckSchemeUtil.getQuaCheckPointByScheme(isSmart, schemeId = Long.valueOf(sampleLibrary.getLong("checkscheme")), smartSchemeId = Long.valueOf(sampleLibrary.getLong("smartcheckscheme")));
        if (checkPoints.isEmpty()) {
            return failPoints;
        }
        Map<Long, DynamicObject> messageMap = QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(checkPoints.keySet(), quaCheckTaskID, Collections.singletonList("0"));
        for (Map.Entry<Long, DynamicObject> entry : checkPoints.entrySet()) {
            Long pointId = entry.getKey();
            if (QualityCheckSchemeUtil.isCheckSuccessPoints(messageMap.get(pointId))) continue;
            failPoints.add(entry.getValue());
        }
        return failPoints;
    }

    private static Map<Long, DynamicObject> getQuaCheckPointByScheme(boolean isSmart, Long schemeId, Long smartSchemeId) {
        QFilter filterSchemeId;
        HashMap<Long, DynamicObject> checkPoints = new HashMap<Long, DynamicObject>(8);
        DynamicObjectCollection entries = null;
        if (isSmart) {
            filterSchemeId = new QFilter("id", "=", (Object)smartSchemeId);
            DynamicObject smartScheme = BusinessDataServiceHelper.loadSingle((String)"task_smartcheckscheme", (String)"cpentry.cpname,cpentry.cpdescription", (QFilter[])new QFilter[]{filterSchemeId});
            if (smartScheme == null) {
                return checkPoints;
            }
            entries = smartScheme.getDynamicObjectCollection("cpentry");
        } else {
            filterSchemeId = new QFilter("id", "=", (Object)schemeId);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"task_qualitycheckscheme", (String)"cpentry.cpname,cpentry.cpdescription", (QFilter[])new QFilter[]{filterSchemeId});
            if (scheme == null) {
                return checkPoints;
            }
            entries = scheme.getDynamicObjectCollection("cpentry");
        }
        for (DynamicObject item : entries) {
            DynamicObject cp = item.getDynamicObject(1);
            if (cp == null) continue;
            checkPoints.put(cp.getLong("id"), cp);
        }
        return checkPoints;
    }

    public static Map<Long, DynamicObject> getCheckPointRecordColOrderByTime(Set<Long> pointIds, long taskid, List<String> messageTypes) {
        return QualityCheckSchemeUtil.getCheckPointRecordColOrderByTime(pointIds, taskid, messageTypes, null);
    }

    public static Map<Long, DynamicObject> getCheckPointRecordColOrderByTime(Set<Long> pointIds, long taskid, List<String> messageTypes, QFilter otherFilter) {
        DynamicObject[] checkRecords;
        QFilter filterPoint = new QFilter("point", "in", pointIds);
        QFilter filterCheck = new QFilter("qualitycheck", "=", (Object)taskid);
        QFilter filterMessageType = new QFilter("entryentity.messagetype", "in", messageTypes);
        if (otherFilter != null) {
            filterPoint.and(otherFilter);
        }
        if ((checkRecords = BusinessDataServiceHelper.load((String)"task_qualitymessagerecord", (String)FIELD_QUALITYMESSAGERECORD, (QFilter[])new QFilter[]{filterPoint, filterCheck, filterMessageType}, (String)"entryentity.datetime desc")) == null || checkRecords.length == 0) {
            return new HashMap<Long, DynamicObject>();
        }
        HashMap<Long, DynamicObject> retMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject item : checkRecords) {
            if (retMap.containsKey(item.getLong("point"))) continue;
            retMap.put(item.getLong("point"), item);
        }
        return retMap;
    }

    public static boolean isCheckSuccessPoints(DynamicObject checkPoint) {
        if (checkPoint == null) {
            return false;
        }
        boolean ischeckok = checkPoint.getBoolean("ischeckok");
        String reviewmethod = checkPoint.getString("reviewmethod");
        String rebackcount = checkPoint.getString("rebackcount");
        if ("4".equals(reviewmethod) && "0".equalsIgnoreCase(rebackcount)) {
            return true;
        }
        if (!ischeckok) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)reviewmethod)) {
            return true;
        }
        return "2".equals(reviewmethod) && "1".equalsIgnoreCase(rebackcount);
    }

    public static boolean isRectifyPassPoints(DynamicObject checkPoint) {
        if (checkPoint == null) {
            return false;
        }
        String reviewmethod = checkPoint.getString("reviewmethod");
        String rebackcount = checkPoint.getString("rebackcount");
        return "1".equals(reviewmethod) && "1".equals(rebackcount);
    }

    public static DynamicObject getQualityCheckScheme(long libId) {
        DynamicObject library = BusinessDataServiceHelper.loadSingle((Object)libId, (String)"task_qualitysamplelibrary");
        DynamicObject scheme = StringUtils.isBlank((CharSequence)(library.getBoolean("issmart") + "")) || !library.getBoolean("issmart") ? BusinessDataServiceHelper.loadSingle((Object)library.getLong("checkscheme.id"), (String)"task_qualitycheckscheme") : BusinessDataServiceHelper.loadSingle((Object)library.getLong("smartcheckscheme.id"), (String)"task_smartcheckscheme");
        return scheme;
    }

    public static Map<Long, DynamicObject> getLibMapSchemeObject(Collection<Long> libIds) {
        DynamicObject[] libraryList = BusinessDataServiceHelper.load((String)"task_qualitysamplelibrary", (String)"id,issmart,checkscheme,smartcheckscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", libIds)});
        HashMap<Long, Long> smartMapLibIds = new HashMap<Long, Long>(libIds.size() / 2);
        HashMap<Long, Long> noSmartMapIds = new HashMap<Long, Long>(libIds.size() / 2);
        for (DynamicObject library : libraryList) {
            if (StringUtils.isBlank((CharSequence)(library.getBoolean("issmart") + "")) || !library.getBoolean("issmart")) {
                noSmartMapIds.put(library.getLong("checkscheme.id"), library.getLong("id"));
                continue;
            }
            smartMapLibIds.put(library.getLong("smartcheckscheme.id"), library.getLong("id"));
        }
        HashMap<Long, DynamicObject> libMapScheme = new HashMap<Long, DynamicObject>(libIds.size());
        QualityCheckSchemeUtil.querySchemaIds(smartMapLibIds, libMapScheme, "task_smartcheckscheme");
        QualityCheckSchemeUtil.querySchemaIds(noSmartMapIds, libMapScheme, "task_qualitycheckscheme");
        return libMapScheme;
    }

    private static void querySchemaIds(Map<Long, Long> schemeMapLibIds, Map<Long, DynamicObject> libMapScheme, String entityName) {
        DynamicObject[] schemes;
        if (schemeMapLibIds.isEmpty()) {
            return;
        }
        for (DynamicObject scheme : schemes = BusinessDataServiceHelper.load((Object[])schemeMapLibIds.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
            long schemeId = scheme.getLong("id");
            Long libId = schemeMapLibIds.get(schemeId);
            libMapScheme.put(libId, scheme);
        }
    }

    public static String getPauseType(Long taskId) {
        QFilter filterId = new QFilter("qctaskid", "=", (Object)taskId);
        DynamicObject pauseRecord = BusinessDataServiceHelper.loadSingle((String)"task_qcpauserecord", (String)"orgtype", (QFilter[])new QFilter[]{filterId});
        if (pauseRecord == null) {
            return "";
        }
        return pauseRecord.getString("orgtype");
    }

    public static String getQualityCheckPageWhenPause(Long taskId) {
        String pauseType;
        String tagPage = null;
        switch (pauseType = QualityCheckSchemeUtil.getPauseType(taskId)) {
            case "1": {
                tagPage = "task_quality_docheck";
                break;
            }
            case "2": {
                tagPage = "task_quality_dorectify";
                break;
            }
            case "3": {
                tagPage = "task_quality_doreview";
                break;
            }
        }
        return tagPage;
    }

    public static DynamicObject getQualityCheckSchemeByLibId(Long libid) {
        QFilter idFilter = new QFilter("id", "=", (Object)libid);
        DynamicObject dyLibrary = BusinessDataServiceHelper.loadSingle((String)"task_qualitysamplelibrary", (String)"checkscheme", (QFilter[])new QFilter[]{idFilter});
        if (dyLibrary == null) {
            return null;
        }
        Object schemeId = dyLibrary.get("checkscheme.id");
        QFilter schemeIdFilter = new QFilter("id", "=", schemeId);
        return BusinessDataServiceHelper.loadSingle((String)"task_qualitycheckscheme", (String)"isautoprocess,disrule", (QFilter[])new QFilter[]{schemeIdFilter});
    }

    public static Map<Long, DynamicObject> getCheckPointMap(Set<Long> pointIds) {
        HashMap<Long, DynamicObject> retMap = new HashMap<Long, DynamicObject>();
        QFilter filter = new QFilter("id", "in", pointIds);
        DynamicObjectCollection ckPointCols = QueryServiceHelper.query((String)"task_checkingpoint", (String)"id,number,name,description,defcorrect", (QFilter[])new QFilter[]{filter});
        if (ckPointCols == null || ckPointCols.size() == 0) {
            return retMap;
        }
        for (DynamicObject item : ckPointCols) {
            retMap.put(item.getLong("id"), item);
        }
        return retMap;
    }

    public static Long getSSCIDByQualityScheme(Object qualitySchemeId) {
        QFilter idFilter = new QFilter("id", "=", qualitySchemeId);
        DynamicObject dyScheme = QueryServiceHelper.queryOne((String)"task_qualitycheckscheme", (String)"ssccenter", (QFilter[])idFilter.toArray());
        if (dyScheme != null) {
            return dyScheme.getLong("ssccenter");
        }
        return 0L;
    }

    public static boolean isUsedByCheckScheme(Long sscId, String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        QFilter sscFilter = new QFilter("ssccenter", "=", (Object)sscId);
        QFilter numberFilter = new QFilter("cpentry.cpnumber", "=", (Object)number);
        return QueryServiceHelper.exists((String)"task_qualitycheckscheme", (QFilter[])new QFilter[]{sscFilter, numberFilter});
    }

    public static List<DynamicObject> getLatestTask(List<DynamicObject> tasks, boolean latest) {
        if (!latest || tasks == null || tasks.isEmpty()) {
            return tasks;
        }
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(tasks.size());
        for (DynamicObject task : tasks) {
            long billId = task.getLong("billid");
            DynamicObject object = (DynamicObject)billMap.get(billId);
            if (object != null) {
                Date t1 = object.getDate("completetime");
                Date t2 = task.getDate("completetime");
                if (t2.after(t1)) {
                    billMap.put(billId, task);
                    continue;
                }
                if (!t2.equals(t1)) continue;
                task = object.getLong("id") > task.getLong("id") ? object : task;
                billMap.put(billId, task);
                continue;
            }
            billMap.put(billId, task);
        }
        return new ArrayList<DynamicObject>(billMap.values());
    }
}

