/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.common.TaskPropertyEnum;

public class TaskTypeUtil {
    public static List<ComboItem> getQualityTaskTypeList(QFilter[] filters) {
        ArrayList<ComboItem> cbList = new ArrayList<ComboItem>(10);
        DynamicObject[] taskTypes = TaskTypeUtil.getTaskType(filters);
        if (taskTypes == null || taskTypes.length == 0) {
            return cbList;
        }
        for (DynamicObject taskRow : taskTypes) {
            String caption = taskRow.getString("name");
            String value = taskRow.getString("id");
            cbList.add(new ComboItem(new LocaleString(caption), value));
        }
        return cbList;
    }

    public static List<String> getTaskTypeIds(QFilter[] filters) {
        ArrayList<String> resultlist = new ArrayList<String>(10);
        DynamicObject[] taskTypes = TaskTypeUtil.getTaskType(filters);
        if (taskTypes == null || taskTypes.length == 0) {
            return resultlist;
        }
        for (DynamicObject taskRow : taskTypes) {
            String id = taskRow.getString("id");
            resultlist.add(id);
        }
        return resultlist;
    }

    public static DynamicObject[] getTaskType(QFilter[] filters) {
        String selectFields = "id, name, qualityjudge";
        return BusinessDataServiceHelper.load((String)"task_tasktype", (String)selectFields, (QFilter[])filters);
    }

    public static boolean isQualityCheckTaskType(Object id) {
        if (id == null || id.equals("")) {
            return false;
        }
        QFilter filterId = new QFilter("id", "=", (Object)Long.valueOf(id + ""));
        QFilter filterJudge = new QFilter("qualityjudge", "=", (Object)"1");
        ORM orm = ORM.create();
        return orm.exists("task_tasktype", new QFilter[]{filterId, filterJudge});
    }

    public static boolean containTaskProperty(List<Long> taskTypeList, TaskPropertyEnum taskPropertyEnum) {
        if (CollectionUtils.isNotEmpty(taskTypeList)) {
            DynamicObject[] taskTypes;
            QFilter idFilter = new QFilter("id", "in", taskTypeList);
            for (DynamicObject taskType : taskTypes = TaskTypeUtil.getTaskType(new QFilter[]{idFilter})) {
                String filterJudge = taskType.getString("qualityjudge");
                if (!filterJudge.equals(taskPropertyEnum.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

