/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.smartscheme;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.common.smartscheme.SmartQualityCheckPredict;
import kd.ssc.task.common.smartscheme.SmartSchemePredictMessage;

public class SmartSchemePredictConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(SmartSchemePredictConsumer.class);

    public void onMessage(Object message, String messageId, boolean isResend, MessageAcker messageAcker) {
        log.info("\u6210\u529f\u8fdb\u5165\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + SerializationUtils.toJsonString((Object)message) + ", " + messageId);
        if (StringUtils.isBlank((CharSequence)(message + ""))) {
            log.error("\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a\uff08\u6216\u4e3anull\uff09,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(messageId);
            return;
        }
        SmartSchemePredictMessage smartSchemePredictMessage = (SmartSchemePredictMessage)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)message), SmartSchemePredictMessage.class);
        try {
            this.predict(smartSchemePredictMessage);
            log.info("\u4fe1\u606f\u6210\u529f\u6d88\u8d39:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + SerializationUtils.toJsonString((Object)message) + ", " + messageId);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            this.createMqErr(message, e, "kd.ssc.task.common.smartscheme.SmartQualityCheckPredict.predict: Message Consume Failed");
        }
        messageAcker.ack(messageId);
    }

    private void createMqErr(Object message, Exception e, String mqexceptionmsg) {
        DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)"task_mq_faile");
        mqErrDyObj.set("mqregion", (Object)"ssc");
        mqErrDyObj.set("mqqueue", (Object)"kd.ssc.task.ssc_smartscheme_queue");
        mqErrDyObj.set("mqexceptionmsg", (Object)mqexceptionmsg);
        mqErrDyObj.set("mqexceptionstack_tag", (Object)ExceptionUtil.getStackTrace((Throwable)e));
        mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
        mqErrDyObj.set("mqparam_tag", (Object)SerializationUtils.toJsonString((Object)message));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
    }

    private void predict(SmartSchemePredictMessage smartSchemePredictMessage) throws Exception {
        try {
            String result = SmartQualityCheckPredict.predict(smartSchemePredictMessage.getTaskIds(), smartSchemePredictMessage.getBillTypeNumbers().toArray(new String[0]));
            if (result != null) {
                String predictResult;
                log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\u7ed3\u679c" + result);
                JSONObject resultJson = JSONObject.parseObject((String)result);
                if (resultJson.get((Object)"err").equals("ok") && StringUtils.isNotBlank((CharSequence)(predictResult = resultJson.getString("result")))) {
                    DynamicObject[] tasks;
                    JSONObject resultObject = (JSONObject)resultJson.getJSONArray("result").get(0);
                    QFilter filter = new QFilter("id", "in", smartSchemePredictMessage.getTaskIds());
                    for (DynamicObject dyo : tasks = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"id,sourcetaskid,predictlevel,predictvalue", (QFilter[])new QFilter[]{filter})) {
                        dyo.set("predictlevel", resultObject.get((Object)"level"));
                        dyo.set("predictvalue", (Object)new BigDecimal(resultObject.get((Object)"prediction") + ""));
                    }
                    if (tasks.length > 0) {
                        SaveServiceHelper.save((DynamicObject[])tasks);
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\u5f02\u5e38" + e.getMessage());
            throw e;
        }
    }
}

