/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.teamleader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import org.apache.commons.lang3.StringUtils;

public class TeamLeaderApi {
    private static final Log log = LogFactory.getLog(TeamLeaderApi.class);

    @Deprecated
    public static Map<Long, Set<String>> getOrgRoleAssignMap(Long pUserId) {
        HashMap<Long, Set<String>> orgRoleAssignMap = new HashMap<Long, Set<String>>();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_userrole", (String)"role,org,includesuborg", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId)});
        if (doc == null || doc.isEmpty()) {
            return orgRoleAssignMap;
        }
        HashSet<Long> orgIncludeSubOrg = new HashSet<Long>();
        for (DynamicObject dObj : doc) {
            long curOrgId = dObj.getLong("org");
            String roleId = dObj.getString("role");
            boolean includeSubOrg = dObj.getBoolean("includesuborg");
            orgRoleAssignMap.computeIfAbsent(curOrgId, k -> new HashSet()).add(roleId);
            if (!includeSubOrg) continue;
            orgIncludeSubOrg.add(curOrgId);
        }
        for (Long curOrgId : orgIncludeSubOrg) {
            ArrayList<Long> curOrgList = new ArrayList<Long>();
            curOrgList.add(curOrgId);
            Set roleIds = (Set)orgRoleAssignMap.get(curOrgId);
            List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), curOrgList, (boolean)false);
            if (allSubordinateOrgs == null || allSubordinateOrgs.size() == 0) continue;
            for (Long subOrgId : allSubordinateOrgs) {
                orgRoleAssignMap.computeIfAbsent(subOrgId, k -> new HashSet()).addAll(roleIds);
            }
        }
        return orgRoleAssignMap;
    }

    public static Set<Long> getOrgByUserAndRole(Long userId, String ... roleId) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"perm_userrole", (String)"role,org,includesuborg", (QFilter[])new QFilter("user", "=", (Object)userId).and(new QFilter("role", "in", (Object)roleId)).toArray());
        if (collection == null || collection.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> resultSet = new HashSet<Long>(collection.size());
        ArrayList<Long> orgIncludeSubOrg = new ArrayList<Long>();
        for (DynamicObject obj : collection) {
            Long orgId = obj.getLong("org");
            resultSet.add(orgId);
            if (!obj.getBoolean("includesuborg")) continue;
            orgIncludeSubOrg.add(orgId);
        }
        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIncludeSubOrg, (boolean)false);
        resultSet.addAll(allSubordinateOrgs);
        return resultSet;
    }

    public static boolean isAdminRole(String sscId, Long userId, String ... roleId) {
        if (sscId == null || roleId.length == 0) {
            return false;
        }
        if (!TeamLeaderApi.isOpenTeamleader(sscId) || PermissionServiceHelper.isSuperUser((long)userId)) {
            return true;
        }
        Set<Long> orgs = TeamLeaderApi.getOrgByUserAndRole(userId, roleId);
        return orgs.contains(Long.valueOf(sscId));
    }

    public static boolean isAdminRole(Collection<Long> sscIds, Long userId, String ... roleId) {
        if (sscIds == null || sscIds.isEmpty() || roleId.length == 0) {
            return false;
        }
        Set<Long> orgs = TeamLeaderApi.getOrgByUserAndRole(userId, roleId);
        for (Long sscId : sscIds) {
            if (!TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId)) || PermissionServiceHelper.isSuperUser((long)userId)) {
                return true;
            }
            if (!orgs.contains(sscId)) continue;
            return true;
        }
        return false;
    }

    public static void showForm(IFormView view, Map<String, String> paramMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "task_errorpage");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submitintab_");
        if (paramMap.size() > 0) {
            String key = new ArrayList<String>(paramMap.keySet()).get(0);
            showParameter.setCaption(ResManager.loadKDString((String)String.valueOf(paramMap.get(key)), (String)key, (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        showParameter.setHasRight(true);
        view.showForm(showParameter);
    }

    public static boolean isTeamleader(String orgId, Long userId) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)Long.valueOf(orgId));
        qFilter.and("entryentity.userfield", "=", (Object)userId);
        qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return groups != null && groups.length != 0;
    }

    @Deprecated
    public static List<ComboItem> getSscenters(Long userid, String formId) {
        return TeamLeaderApi.getSscenters(userid, formId, "ssc");
    }

    public static List<ComboItem> getSscenters(Long userid, String formId, String appId) {
        HasPermOrgResult hasPermOrgs;
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        QFilter qFilter = (hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userid, (String)"12", (String)appId, (String)formId, (String)"47150e89000000ac")).hasAllOrgPerm() || PermissionServiceHelper.isSuperUser((long)userid) ? new QFilter("fisscc", "=", (Object)Character.valueOf('1')) : new QFilter("id", "in", TeamLeaderApi.siftNopermissionSscIds(userid, hasPermOrgs.getHasPermOrgs()));
        String algoKey = TeamLeaderApi.class + "_getSscenters()_0";
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                ComboItem citem = new ComboItem();
                citem.setCaption(new LocaleString(row.getString(1)));
                citem.setValue(row.getString(0));
                list.add(citem);
            }
        }
        return list;
    }

    private static List<Long> siftNopermissionSscIds(Long userId, List<Long> sscIds) {
        ArrayList<Long> sscIds_ = new ArrayList<Long>(sscIds.size());
        QFilter idFilter = new QFilter("id", "in", sscIds);
        String algoKey = TeamLeaderApi.class + "siftNopermissionSscIds()_0";
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id,name,fisscc", (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : orgDataSet) {
                if (!row.getBoolean(2).booleanValue()) continue;
                sscIds_.add(row.getLong(0));
            }
        }
        Map<String, Boolean> paramBatch = TeamLeaderApi.getParamBatch("usegrouptl", sscIds_);
        Set<String> paramBatchKeys = paramBatch.entrySet().stream().filter(e -> (Boolean)e.getValue()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Boolean)entry.getValue())).keySet();
        if (paramBatchKeys.size() == 0) {
            return sscIds_;
        }
        Set<Long> orgs = TeamLeaderApi.getOrgByUserAndRole(userId, "HXLFBW8ZGNH");
        if (!orgs.isEmpty()) {
            paramBatchKeys.removeIf(next -> orgs.contains(Long.valueOf(next)));
        }
        if (paramBatchKeys.size() == 0) {
            return sscIds_;
        }
        HashSet<String> manageSsc = UserGroupUtil.getManageSsc(userId);
        if (manageSsc != null && manageSsc.size() > 0) {
            Iterator<String> iterator = paramBatchKeys.iterator();
            while (iterator.hasNext()) {
                if (!manageSsc.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        if (paramBatchKeys.size() == 0) {
            return sscIds_;
        }
        Iterator iterator1 = sscIds_.iterator();
        while (iterator1.hasNext()) {
            if (!paramBatchKeys.contains(iterator1.next() + "")) continue;
            iterator1.remove();
        }
        return sscIds_;
    }

    public static boolean getBooleanParam(String paramKey, long orgId, boolean defVal) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        boolean result = defVal;
        if (null != params) {
            result = (Boolean)params;
        }
        return result;
    }

    public static Map<String, Boolean> getParamBatch(String paramKey, List<Long> orgIds) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", null, Long.valueOf(0L));
        log.info("TeamLeaderApi.getParamBatch\u67e5\u8be2\u542f\u7528\u7ec4\u957f\u7ba1\u7406\u7684\u7ec4\u7ec7\uff1a" + orgIds);
        Map stringMapMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, orgIds);
        log.info("TeamLeaderApi.getParamBatch\u67e5\u8be2\u542f\u7528\u7ec4\u957f\u7ba1\u7406\u7684\u7ec4\u7ec7\u2014\u2014\u7ed3\u679c\uff1a" + stringMapMap);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        stringMapMap.forEach((key, value) -> {
            Object paramK;
            if (value != null && (paramK = value.get(paramKey)) instanceof Boolean) {
                map.put((String)key, (Boolean)paramK);
            }
        });
        return map;
    }

    public static boolean isOpenTeamleader(String orgId) {
        return TeamLeaderApi.getBooleanParam("usegrouptl", Long.parseLong(orgId), false);
    }
}

