/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.task.dis.QulityJob;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.util.ResultBuildUtil;
import kd.ssc.task.service.distask.WorkLoadService;

public class QuailtyUserMatchRuleServiceImpl
implements MatchRuleService {
    private DisRequestCtx ctx;

    @Override
    public MatchRuleResult match(long taskId, MatchRuleResult result) {
        result.setSuccess(false);
        WorkLoadService workload = this.getRequestCtx().getWorkload();
        long groupId = this.getRequestCtx().getUsergroupId();
        QulityJob qulityJob = this.getRequestCtx().getQualityJob();
        DynamicObject task = this.getRequestCtx().getDisTask();
        assert (task.getLong("qualitysamplelibrary.id") > 0L);
        if (this.getRequestCtx().getDisType() == DisTypeEnum.MANUAL_GET) {
            return this.matchByManualGet(result, groupId, qulityJob.getQjobSourcePerson(task));
        }
        WorkerStatusPojo qTaskSourcePerson = workload.deleteQTaskSPerson(groupId, qulityJob.getQjobSourcePerson(task));
        long person = workload.getMatchPerson(groupId, task.getString("billnumber"));
        if (qTaskSourcePerson != null) {
            workload.addQTaskSPerson(groupId, qTaskSourcePerson);
            this.buildFailedResult(result, qTaskSourcePerson.getUserId(), ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u4e0d\u5206\u914d\u7ed9\u539f\u5ba1\u5355\u4efb\u52a1\u5ba1\u6279\u4eba\u5ba1\u6838", (String)"QuailtyUserMatchRuleServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if (person == -1L) {
            this.buildFailedResult(result, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u7ec4\u65e0\u4eba\u5728\u5c97\u6216\u8005\u5728\u5c97\u4eba\u5458\u90fd\u5df2\u6ee1\u8d1f\u8377\uff0c\u4efb\u52a1\u65e0\u6cd5\u5206\u914d\u7ed9\u8be5\u7528\u6237\u7ec4", (String)"QuailtyUserMatchRuleServiceImpl_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            result.setMatchRuleId(this.getRequestCtx().getCurrentRuleId());
            result.setMatchGroupId(groupId);
            result.setMatchPersonId(person);
            result.setSuccess(true);
            this.buildSuccessResult(result);
        }
        return result;
    }

    private MatchRuleResult matchByManualGet(MatchRuleResult result, long groupId, Long qTaskSourcePerson) {
        long userId = this.getRequestCtx().getUserId();
        WorkerStatusPojo curGroupWorkStatus = this.getRequestCtx().getGroup2WorkerStatusPojo().get(groupId);
        if (curGroupWorkStatus == null) {
            this.buildFailedResult(result, userId, ResManager.loadKDString((String)"\u5728\u5f53\u524d\u9879\u76ee\u7ec4\u4e0b\uff0c\u672a\u627e\u5230\u8be5\u7528\u6237\u7684\u8d1f\u8377\u7edf\u8ba1\u4fe1\u606f", (String)"QuailtyUserMatchRuleServiceImpl_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if (curGroupWorkStatus.getTaskTotal() >= curGroupWorkStatus.getTaskUpper()) {
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u8d85\u8d1f\u8377\uff0c\u5904\u7406\u4e2d\u4efb\u52a1\u6570\uff1a%1$s, \u8d1f\u8377\u4e0a\u9650\uff1a%2$s", (String)"QuailtyUserMatchRuleServiceImpl_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), curGroupWorkStatus.getTaskTotal(), curGroupWorkStatus.getTaskUpper());
            this.buildFailedResult(result, userId, message);
        } else if (qTaskSourcePerson == null) {
            this.buildFailedResult(result, ResManager.loadKDString((String)"\u539f\u5ba1\u5355\u4efb\u52a1\u5ba1\u6279\u4eba\u4e3a\u7a7a", (String)"QuailtyUserMatchRuleServiceImpl_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if (qTaskSourcePerson == userId) {
            this.buildFailedResult(result, qTaskSourcePerson, ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u4e0d\u5206\u914d\u7ed9\u539f\u5ba1\u5355\u4efb\u52a1\u5ba1\u6279\u4eba\u5ba1\u6838", (String)"QuailtyUserMatchRuleServiceImpl_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            result.setSuccess(true);
            result.setMatchRuleId(this.getRequestCtx().getCurrentRuleId());
            result.setMatchGroupId(this.getRequestCtx().getUsergroupId());
            result.setMatchPersonId(this.getRequestCtx().getUserId());
            this.buildSuccessResult(result);
            curGroupWorkStatus.setTaskTotal(curGroupWorkStatus.getTaskTotal() + 1);
        }
        return result;
    }

    private void buildFailedResult(MatchRuleResult result, long userId, String message) {
        result.setSuccess(false);
        DisRequestCtx requestCtx = this.getRequestCtx();
        JSONObject uDetail = ResultBuildUtil.getOrDefault_u_detail(result.getDetail(), requestCtx.getCurrentRuleId(), requestCtx.getUsergroupId(), requestCtx.getUserId());
        uDetail.put("userId", (Object)userId);
        uDetail.put("message", (Object)message);
    }

    private void buildFailedResult(MatchRuleResult result, String message) {
        result.setSuccess(false);
        DisRequestCtx requestCtx = this.getRequestCtx();
        JSONObject gDetail = ResultBuildUtil.getOrDefault_g_detail(result.getDetail(), requestCtx.getCurrentRuleId(), requestCtx.getUsergroupId());
        gDetail.put("matched", (Object)false);
        gDetail.put("message", (Object)message);
    }

    private void buildSuccessResult(MatchRuleResult result) {
        JSONObject r_detail = ResultBuildUtil.getOrDefault_r_detail(result.getDetail(), this.getRequestCtx().getCurrentRuleId());
        r_detail.put("matched", (Object)true);
        JSONObject g_detail = ResultBuildUtil.getOrDefault_g_detail(result.getDetail(), this.getRequestCtx().getCurrentRuleId(), this.getRequestCtx().getUsergroupId());
        g_detail.put("matched", (Object)true);
    }

    @Override
    public DisRequestCtx getRequestCtx() {
        return this.ctx;
    }

    @Override
    public void setRequestCtx(DisRequestCtx ctx) {
        this.ctx = ctx;
    }
}

