/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.util;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.monitor.util.ExceptionSaveUtil;
import kd.ssc.task.disRebuild.disenum.DisExceptionEnum;

public class DisExceptionUtil {
    private static final Log log = LogFactory.getLog(DisExceptionUtil.class);
    private static final int LOG_LENGTH = 5000;

    public static void saveMonitorException(Long taskId, DisTypeEnum disType, Throwable e) {
        log.info("\u5206\u914d\u5f02\u5e38,\u4efb\u52a1id:" + taskId + ",disType:" + disType.getValue(), (Object)e);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
        if (task == null) {
            log.error("\u5f02\u5e38\u7684\u5171\u4eab\u4efb\u52a1\u4e0d\u5b58\u5728,taskId\uff1a", (Object)taskId);
            return;
        }
        Long scenarioId = DisExceptionUtil.findDisScenario(e);
        if (scenarioId == null || scenarioId == 0L) {
            log.error("\u627e\u5bfb\u9884\u7f6e\u5f02\u5e38\u573a\u666f\u5931\u8d25,scenarioId\uff1a", (Object)scenarioId);
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)scenarioId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject scenarioDefDo = BusinessDataServiceHelper.loadSingle((String)"ssc_scenario_def", (QFilter[])new QFilter[]{idFilter, enableFilter});
        if (scenarioDefDo == null) {
            return;
        }
        long sscId = task.getLong("sscid.id");
        long billTypeId = task.getLong("billtype.id");
        long taskTypeId = task.getLong("tasktypeid.id");
        String billId = task.getString("billid");
        String billNumber = task.getString("billnumber");
        String monitorRetry = DisExceptionUtil.buildMonitorRetry("kd.ssc.task.disRebuild.util.DisExceptionUtil", "createTask", disType);
        String bizAttribute = DisExceptionUtil.buildBizAttribute(disType);
        ExceptionSaveUtil.saveMonitorException((long)scenarioId, (long)taskId, (long)sscId, (long)billTypeId, (long)taskTypeId, (String)billId, (String)billNumber, (Throwable)e, (String)monitorRetry, (String)bizAttribute);
    }

    public static String buildMonitorRetry(String className, String method, DisTypeEnum disType) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("className", className);
        param.put("method", method);
        param.put("disType", disType.getValue());
        return SerializationUtils.toJsonString(param);
    }

    public static String buildBizAttribute(DisTypeEnum disType) {
        String bizAttribute = null;
        if (disType != null) {
            switch (disType) {
                case AUTO_DIS: {
                    bizAttribute = ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d", (String)"DisExceptionUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                case MANUAL_DIS: {
                    bizAttribute = ResManager.loadKDString((String)"\u624b\u5de5\u5206\u914d\u4e0e\u91cd\u5206\u914d", (String)"DisExceptionUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                case MANUAL_GET: {
                    bizAttribute = ResManager.loadKDString((String)"\u4e3b\u52a8\u83b7\u53d6", (String)"DisExceptionUtil_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                case NOPASS_DIS: {
                    bizAttribute = ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u9700\u8f6c\u4e3a\u4eba\u5de5\u5ba1\u6838\u3002", (String)"DisExceptionUtil_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
        }
        return bizAttribute;
    }

    public static Long findDisScenario(Throwable e) {
        String code = DisExceptionEnum.BIZERROR.getCode();
        if (e instanceof KDException) {
            code = ((KDException)e).getErrorCode().getCode();
        }
        Long scenarioId = 2L;
        if (StringUtils.isNotEmpty((String)code)) {
            if (DisExceptionEnum.BIZERROR.getCode().equals(code)) {
                scenarioId = 2L;
            } else if (DisExceptionEnum.NOTMATCHED.getCode().equals(code)) {
                scenarioId = 3L;
            } else if (DisExceptionEnum.SYNCHRONIZEDERROR.getCode().equals(code)) {
                scenarioId = 4L;
            }
        }
        return scenarioId;
    }
}

