/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class RobertUserGroupUtil {
    private static final String ENTITY = "task_usergroup";

    public static boolean isRobort(long sscId, long groupId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("id", "=", (Object)groupId), new QFilter("isrobots", "=", (Object)true), new QFilter("createorg", "=", (Object)sscId)};
        return QueryServiceHelper.exists((String)ENTITY, (QFilter[])qFilters);
    }

    public static boolean isRobort(long sscId, long groupId, long userId) {
        String selectFields = "entryentity.userfield.id";
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("id", "=", (Object)groupId), new QFilter("isrobots", "=", (Object)true), new QFilter("createorg", "=", (Object)sscId)};
        DynamicObjectCollection users = QueryServiceHelper.query((String)ENTITY, (String)selectFields, (QFilter[])qFilters);
        if (users != null && !users.isEmpty()) {
            for (DynamicObject dyo : users) {
                if (dyo.getLong(selectFields) != userId) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkRedistribution(boolean isRobot, Long person, long group) {
        QFilter userEnabled;
        QFilter enableFilter;
        if (!isRobot) {
            return true;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)group);
        DynamicObject userGroupDo = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)"id,isrobots,entryentity.userfield,redistributionnew", (QFilter[])new QFilter[]{idFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), userEnabled = new QFilter("entryentity.usestatus", "=", (Object)"1")});
        if (userGroupDo != null) {
            boolean redistribution;
            boolean isRobots = userGroupDo.getBoolean("isrobots");
            String redistributionNew = userGroupDo.getString("redistributionnew");
            boolean bl = redistribution = StringUtils.isNotEmpty((String)redistributionNew) && redistributionNew.contains("1");
            if (isRobots && redistribution) {
                DynamicObjectCollection clos = userGroupDo.getDynamicObjectCollection("entryentity");
                for (DynamicObject clo : clos) {
                    Long userId = clo.getLong("userfield.id");
                    if (!userId.equals(person)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean checkRedistributionByLocalNode(boolean isRobot, String autoProcessResult, DynamicObject robertGroupDo) {
        if (!isRobot && StringUtils.isNotEmpty((String)autoProcessResult) && autoProcessResult.contains("0") && robertGroupDo != null) {
            String redistributionNew = robertGroupDo.getString("redistributionnew");
            return StringUtils.isNotEmpty((String)redistributionNew) && redistributionNew.contains("0");
        }
        return false;
    }

    public static DynamicObject getRobertGroup(long sscId) {
        QFilter sscFilter = new QFilter("createorg", "=", (Object)sscId);
        QFilter robertFilter = new QFilter("isrobots", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{sscFilter, robertFilter, enableFilter};
        DynamicObject robertGroupDo = null;
        if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])filters)) {
            robertGroupDo = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)"id,isrobots,entryentity.userfield,entryentity.usestatus,redistributionnew", (QFilter[])new QFilter[]{sscFilter, robertFilter, enableFilter});
        }
        return robertGroupDo;
    }

    public static Map<Long, DynamicObject> getRobertGroupMap(long sscId) {
        QFilter sscFilter = new QFilter("createorg", "=", (Object)sscId);
        QFilter robertFilter = new QFilter("isrobots", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{sscFilter, robertFilter, enableFilter};
        HashMap<Long, DynamicObject> robertGroupMap = null;
        if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])filters)) {
            DynamicObject[] sscGroups = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,isrobots,entryentity.userfield,entryentity.usestatus,redistributionnew", (QFilter[])new QFilter[]{sscFilter, robertFilter, enableFilter});
            robertGroupMap = new HashMap<Long, DynamicObject>(sscGroups.length);
            for (DynamicObject group : sscGroups) {
                Long groupId = group.getLong("id");
                robertGroupMap.put(groupId, group);
            }
        }
        return robertGroupMap;
    }
}

