/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class BillOperationConfigFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String entityNumber = (String)showParam.getCustomParam("entityNumber");
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        this.initEntryEntity(entityNumber);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if ("btn_ok".equals(key)) {
            this.returnData();
        }
    }

    private void initEntryEntity(String entityNumber) {
        IDataModel model = this.getModel();
        ArrayList<Map<String, Object>> allOperation = this.getAllOperation(entityNumber);
        model.batchCreateNewEntryRow("operationentity", allOperation.size());
        int i = 0;
        String lang = RequestContext.get().getLang().toString();
        model.beginInit();
        for (Map<String, Object> opMap : allOperation) {
            LinkedHashMap nameMap = (LinkedHashMap)opMap.get("name");
            model.setValue("opname", nameMap.get(lang), i);
            model.setValue("opkey", opMap.get("key"), i);
            model.setValue("optype", opMap.get("type"), i);
            ++i;
        }
        model.endInit();
    }

    private ArrayList<Map<String, Object>> getAllOperation(String entityNumber) {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId();
        List operateStrs = metadataService.loadEntityAllOperationMeta(entityTypeId);
        ArrayList<Map<String, Object>> iOperates = new ArrayList<Map<String, Object>>(operateStrs.size());
        for (String operateStr : operateStrs) {
            iOperates.add((Map<String, Object>)SerializationUtils.fromJsonString((String)operateStr, Map.class));
        }
        return iOperates;
    }

    private void returnData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("operationentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().close();
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(2);
        DynamicObject operationEntity = this.getModel().getEntryRowEntity("operationentity", selectRows[0]);
        String opKey = operationEntity.getString("opkey");
        String opName = operationEntity.getString("opname");
        returnData.put("opKey", opKey);
        returnData.put("opName", opName);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

