/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;
import kd.ssc.task.common.DisRuleDataSyncHelper;
import kd.ssc.task.formplugin.imports.TaskImportHelper;

public class DisRuleFormPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String ENTRYENTITY2 = "entryentity2";
    Map<String, DynamicObject> number2TaskTypeMap;
    Map<String, DynamicObject> number2BillTypeMap;
    private static String ORGTYPE = "10";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
        this.addClickListeners(new String[]{"editusericon", "usergroupaddicon"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        AbstractGrid grid1 = (AbstractGrid)this.getView().getControl(ENTRYENTITY1);
        grid.addRowClickListener((RowClickEventListener)this);
        grid1.addRowClickListener((RowClickEventListener)this);
        BasedataEdit tasktype = (BasedataEdit)this.getControl("tasktype");
        tasktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billtype = (BasedataEdit)this.getControl("billtype");
        billtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit priEdit = (TextEdit)this.getControl("filterrule");
        priEdit.addButtonClickListener((ClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (e.getSource() instanceof DeleteEntry && ((DeleteEntry)e.getSource()).getOperateKey().equals("deleteentry2") && this.getModel().getEntryRowCount(ENTRYENTITY2) == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DisRuleFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            e.cancel = true;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        switch (e.getOperateKey()) {
            case "deleteentry2": {
                DynamicObjectCollection bosOrgIDCol = this.getModel().getEntryEntity(ENTRYENTITY2);
                ArrayList<Long> orgIdList = new ArrayList<Long>();
                for (DynamicObject bosOrgDyObj : bosOrgIDCol) {
                    orgIdList.add(bosOrgDyObj.getDynamicObject("orgname").getLong("id"));
                }
                this.setOrgRangeSelected(orgIdList);
                break;
            }
            case "save": {
                boolean isSuccess;
                if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) break;
                if (this.getModel().getEntryEntity(ENTRYENTITY1).size() > 0) {
                    AbstractGrid grid1 = (AbstractGrid)this.getView().getControl(ENTRYENTITY1);
                    grid1.selectRows(0);
                }
                if (!(isSuccess = e.getOperationResult().isSuccess())) break;
                DynamicObject disRuleObj = this.getModel().getDataEntity();
                DisRuleDataSyncHelper dataSyncHelper = new DisRuleDataSyncHelper();
                dataSyncHelper.keepDataSync(disRuleObj);
                break;
            }
            case "dis_user_org_add": {
                if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) break;
                this.openAddOrgView();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeProperty = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if (changeProperty.equals("filterrule")) {
            Object newFilterRule = changeData.getNewValue();
            int changeIndex = changeData.getRowIndex();
            if (kd.bos.config.client.util.StringUtils.isBlank((String)(newFilterRule + ""))) {
                model.setValue("filterrule", (Object)"", changeIndex);
                model.setValue("filterrulejson_tag", (Object)"{\"filterRow\":[],\"forList\":false}", changeIndex);
                model.setValue("applycreditleveljoson_tag", (Object)"{\"filterRow\":[],\"forList\":false}", changeIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "ssccenter"});
        } else if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
        if (((DynamicObjectCollection)this.getModel().getValue(ENTRYENTITY1)).isEmpty()) {
            return;
        }
        CardEntry entryentity = (CardEntry)this.getControl(ENTRYENTITY1);
        entryentity.selectRows(0);
    }

    private void openAddOrgView() {
        String sscID = this.getSscID();
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setCustomParam("sscid", (Object)sscID);
        parameEdit.setFormId("task_dis_org_user_input");
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dis_user_org_add");
        parameEdit.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameEdit);
    }

    private String getSscID() {
        String sscID = "";
        Object ssc = this.getModel().getValue("ssccenter");
        if (ssc != null) {
            sscID = ((DynamicObject)ssc).getString("id");
        }
        return sscID;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("filterrule".equals(key)) {
            int index;
            IDataModel model = this.getModel();
            DynamicObject billType = (DynamicObject)model.getValue("billtype", index = model.getEntryCurrentRowIndex("entryentity"));
            if (billType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"DisRuleFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String taskBill = this.getTaskBill(billType);
            if (kd.bos.config.client.util.StringUtils.isEmpty((String)taskBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u4e1a\u52a1\u5355\u636e\u7ed1\u5b9a\u7684\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u4e1a\u52a1\u5355\u636e\u7ed1\u5b9a\u7684\u5355\u636e\u662f\u5426\u5b58\u5728\u3002", (String)"DisRuleFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getBillFilter(taskBill, index);
        } else if ("editusericon".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY1);
            this.editSelectedOrgRange(rowIndex);
        } else if ("usergroupaddicon".equals(key)) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYENTITY1);
            if (entries == null || entries.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u7528\u6237\u7ec4\u4e0e\u7ec4\u7ec7\u914d\u7f6e\u7684\u589e\u52a0\u6309\u94ae\uff0c\u65b0\u589e\u7528\u6237\u7ec4\u7ec7\u8303\u56f4\u5206\u5f55\u3002", (String)"DisRuleFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY1);
            this.showSelecteOrgF7(rowIndex);
        }
    }

    private String getTaskBill(DynamicObject billType) {
        Object id = billType.getPkValue();
        QFilter qf = new QFilter("id", "=", id);
        DynamicObject dycBindBill = BusinessDataServiceHelper.loadSingle((String)"task_taskbill", (String)"bindbill", (QFilter[])new QFilter[]{qf});
        if (dycBindBill == null) {
            return "";
        }
        return dycBindBill.getString("bindbill.number");
    }

    private void getBillFilter(String taskBill, int index) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_disrulef7");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCustomParam("taskBill", (Object)taskBill);
        showParameter.setCustomParam("json", this.getModel().getValue("filterrulejson_tag", index));
        showParameter.setCustomParam("creditleveljson", this.getModel().getValue("applycreditleveljoson_tag", index));
        showParameter.setCustomParam("fromWhere", (Object)"disrule");
        showParameter.setCustomParam("sscid", (Object)this.getSscID());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "filterrule");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals("dis_user_org_add")) {
            this.setOrgUserEntryHead(e);
            this.setOrgUserEntryBody(e);
            int entryCount = this.getModel().getEntryRowCount(ENTRYENTITY1);
            CardEntry entryentity = (CardEntry)this.getControl(ENTRYENTITY1);
            entryentity.selectRows(entryCount - 1);
        } else if ("filterrule".equals(e.getActionId())) {
            Map ret = (Map)e.getReturnData();
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            String filter = (String)ret.get("filter");
            String filter1 = (String)ret.get("filter1");
            String creditLevelJson = (String)ret.get("filterCondition1");
            String andLogic = "";
            String operateLogic = "";
            StringBuffer sbFilter = new StringBuffer();
            if (kd.bos.config.client.util.StringUtils.isNotEmpty((String)filter1) && kd.bos.config.client.util.StringUtils.isNotEmpty((String)creditLevelJson)) {
                sbFilter.append('(');
                sbFilter.append(filter1);
                sbFilter.append(')');
                FilterCondition fc2 = (FilterCondition)SerializationUtils.fromJsonString((String)creditLevelJson, FilterCondition.class);
                List filterRows = fc2.getFilterRow();
                andLogic = ((SimpleFilterRow)filterRows.get(filterRows.size() - 1)).getLogic();
                operateLogic = "0".equals(andLogic) ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"DisRuleFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"DisRuleFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                sbFilter.append(operateLogic);
            }
            if (kd.bos.config.client.util.StringUtils.isNotEmpty((String)filter) && kd.bos.config.client.util.StringUtils.isNotEmpty((String)creditLevelJson)) {
                sbFilter.append('(');
                sbFilter.append(filter);
                sbFilter.append(')');
            } else {
                int startIndex = sbFilter.lastIndexOf(operateLogic);
                if (startIndex > 0) {
                    sbFilter = sbFilter.delete(startIndex, sbFilter.length());
                }
            }
            model.setValue("filterrule", (Object)sbFilter.toString(), rowIndex);
            model.setValue("filterrulejson_tag", ret.get("filterCondition"), rowIndex);
            model.setValue("applycreditleveljoson_tag", ret.get("filterCondition1"), rowIndex);
        } else if ("orgrangeSelected".equals(e.getActionId())) {
            List<Long> disOrgIdList = this.getSelectedOrgIDs(e);
            this.buildOrgEntryCardByDisOrgIDs(disOrgIdList);
            this.setOrgRangeSelected(disOrgIdList);
        }
    }

    private void setOrgRangeSelected(List<Long> disOrgIdList) {
        Map<Long, DynamicObject> orgRangeMap = this.buildMultBaseDataValue(disOrgIdList, "bos_org");
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY1);
        this.getModel().setValue("orgrange", orgRangeMap, rowIndex);
    }

    private void setOrgUserEntryBody(ClosedCallBackEvent e) {
        Map returnMap = (Map)e.getReturnData();
        List orgList = (List)returnMap.get("orglist");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY2);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("orgname", new Object[0]);
        for (Long key : orgList) {
            vs.addRow(new Object[]{key});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY2, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY2);
    }

    private void buildOrgEntryCardByDisOrgIDs(List<Long> disOrgIdList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRYENTITY2);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("orgname", new Object[0]);
        for (long key : disOrgIdList) {
            vs.addRow(new Object[]{key});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY2, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY2);
    }

    private void setOrgUserEntryHead(ClosedCallBackEvent e) {
        Map returnMap = (Map)e.getReturnData();
        String userGroup = returnMap.get("usergroupid").toString();
        String remark = returnMap.get("remark").toString();
        Map<Object, Object> orgRangeMap = new HashMap();
        List<Long> orgIDList = this.buildIDList(returnMap);
        orgRangeMap = this.buildMultBaseDataValue(orgIDList, "bos_org");
        int[] rows = new int[]{0};
        Object rowNumber = returnMap.get("rowindex");
        if (rowNumber != null) {
            rows[0] = Integer.parseInt(rowNumber.toString());
        } else {
            rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY1, 1);
        }
        this.getModel().setValue("orgrange", orgRangeMap, rows[0]);
        this.getModel().setValue("usergroup", (Object)Long.valueOf(userGroup), rows[0]);
        this.getModel().setValue("remark", (Object)remark, rows[0]);
    }

    private List<Long> buildIDList(Map<String, Object> returnMap) {
        List orgList = (List)returnMap.get("orglist");
        return orgList;
    }

    private Map<Long, DynamicObject> buildMultBaseDataValue(List<Long> orgIDList, String metaType) {
        HashMap<Long, DynamicObject> mulBaseDataValueMap = new HashMap<Long, DynamicObject>();
        if (orgIDList == null || orgIDList.isEmpty()) {
            return mulBaseDataValueMap;
        }
        if (kd.bos.config.client.util.StringUtils.isNull((String)metaType)) {
            return mulBaseDataValueMap;
        }
        QFilter orgFilter = new QFilter("id", "in", orgIDList);
        ORM orm = ORM.create();
        DataSet orgset = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query multbaseDataValue", metaType, "id,number,name", new QFilter[]{orgFilter});
        DynamicObjectCollection dycol = ORMUtil.toDynamicObjectCollection((DataSet)orgset, (String)metaType);
        for (DynamicObject orgOjb : dycol) {
            mulBaseDataValueMap.put(orgOjb.getLong("id"), orgOjb);
        }
        return mulBaseDataValueMap;
    }

    public void entryRowClick(RowClickEvent arg0) {
        if (arg0.getSource() instanceof CardEntry && ((CardEntry)arg0.getSource()).getKey().equals(ENTRYENTITY1)) {
            int rowIndex = arg0.getRow();
            List<Long> disOrgIDList = this.getOrgRangeListIDs(rowIndex);
            boolean isChanged = this.getModel().getDataChanged();
            this.buildOrgEntryCardByDisOrgIDs(disOrgIDList);
            if (!isChanged) {
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int rowCount;
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if (ENTRYENTITY1.equals(entryName) && (rowCount = model.getEntryRowCount(ENTRYENTITY1)) == 0) {
            model.deleteEntryData(ENTRYENTITY2);
        }
    }

    private void editSelectedOrgRange(int rowIndex) {
        HashMap<String, Object> cusParamMap = new HashMap<String, Object>();
        String remark = this.getRemarkValue(rowIndex);
        List<Long> disOrgIDList = this.getOrgRangeListIDs(rowIndex);
        Long userGroupID = this.getUserGroupID(rowIndex);
        cusParamMap.put("orgrang", this.fromLongToStr(disOrgIDList));
        cusParamMap.put("usergroup", userGroupID);
        cusParamMap.put("remark", remark);
        cusParamMap.put("rowindex", rowIndex + "");
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setFormId("task_dis_org_user_input");
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        parameEdit.setCustomParam("sscid", (Object)this.getSscID());
        parameEdit.setCustomParam("dis_editmap", cusParamMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dis_user_org_add");
        parameEdit.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameEdit);
    }

    private List<String> fromLongToStr(List<Long> LongList) {
        ArrayList<String> strList = new ArrayList<String>(10);
        for (Long l : LongList) {
            strList.add(kd.bos.config.client.util.StringUtils.valueOf(Long.class, (Object)l));
        }
        return strList;
    }

    private Long getUserGroupID(int rowIndex) {
        long userGroupID = -1L;
        IDataModel model = this.getModel();
        DynamicObject userGroupDyObj = (DynamicObject)model.getValue("usergroup", rowIndex);
        if (userGroupDyObj != null) {
            userGroupID = userGroupDyObj.getLong("id");
        }
        return userGroupID;
    }

    private String getRemarkValue(int rowIndex) {
        String remark = "";
        IDataModel model = this.getModel();
        Object remarkObj = model.getValue("remark", rowIndex);
        remark = remarkObj == null ? "" : remarkObj.toString();
        return remark;
    }

    private List<Long> getOrgRangeListIDs(int rowIndex) {
        ArrayList<Long> disOrgIDList = new ArrayList<Long>();
        IDataModel model = this.getModel();
        DynamicObjectCollection disOrgCol = (DynamicObjectCollection)model.getValue("orgrange", rowIndex);
        if (disOrgCol == null) {
            return disOrgIDList;
        }
        for (DynamicObject dyobj : disOrgCol) {
            disOrgIDList.add(dyobj.getLong("fbasedataid_id"));
        }
        return disOrgIDList;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String sscID = this.getSscID();
        if (kd.bos.config.client.util.StringUtils.isEmpty((String)sscID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"DisRuleFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String key = edit.getKey();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("tasktype".equals(key)) {
            QFilter orgFilter = new QFilter("orgfield", "=", (Object)Long.valueOf(sscID));
            showParameter.getListFilterParameter().setFilter(orgFilter);
        } else if ("billtype".equals(key)) {
            ListFilterParameter parameter = showParameter.getListFilterParameter();
            parameter.setFilter(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscID)));
            parameter.setFilter(new QFilter("effective", "in", (Object)new String[]{"1", "2"}));
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            HashSet<Long> selectedIds = new HashSet<Long>(entries.size());
            for (DynamicObject dynObj : entries) {
                if (dynObj == null) continue;
                selectedIds.add(dynObj.getLong("billtype.id"));
            }
            if (selectedIds.size() > 0) {
                parameter.setFilter(new QFilter("id", "not in", selectedIds));
            }
        }
    }

    private void showSelecteOrgF7(int rowIndex) {
        Object objSSCCenter = this.getModel().getValue("ssccenter");
        if (objSSCCenter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"DisRuleFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        Long sscId = ((DynamicObject)objSSCCenter).getLong("id");
        ListShowParameter lsp = OrgF7ViewShowHelper.buildOrgShowFormParameter((boolean)true, null, (Long)sscId);
        List<Long> disOrgIDList = this.getOrgRangeListIDs(rowIndex);
        if (!disOrgIDList.isEmpty()) {
            lsp.setSelectedRows(disOrgIDList.toArray());
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgrangeSelected"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<Long> getSelectedOrgIDs(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (ListSelectedRow row : returnData) {
            Long id = (Long)row.getPrimaryKeyValue();
            orgIdList.add(id);
        }
        return orgIdList;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        HashSet<String> taskTypeNumbers = new HashSet<String>();
        HashSet<String> billTypeNumbers = new HashSet<String>();
        for (Map rowMap : e.getSourceDataList()) {
            JSONObject row = (JSONObject)rowMap;
            taskTypeNumbers.add(row.getJSONObject("tasktype").getString("number"));
            for (Object obj : row.getJSONArray("entryentity")) {
                billTypeNumbers.add(((JSONObject)obj).getJSONObject("billtype").getString("number"));
            }
        }
        String sscNumber = SscDistributeCache.get((String)"sscNumber");
        DynamicObject ssc = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)sscNumber).toArray());
        this.getPageCache().put("sscId", ssc.getString("id"));
        DynamicObject[] taskTypes = BusinessDataServiceHelper.load((String)"task_tasktype", (String)"id,number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", taskTypeNumbers), new QFilter("orgfield", "=", (Object)ssc.getLong("id"))});
        this.number2TaskTypeMap = Arrays.stream(taskTypes).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        DynamicObject[] billTypes = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"id,number,effective", (QFilter[])new QFilter[]{new QFilter("number", "in", billTypeNumbers), new QFilter("ssccenter", "=", (Object)ssc.getLong("id"))});
        this.number2BillTypeMap = Arrays.stream(billTypes).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        JSONObject row = (JSONObject)e.getSourceData();
        TaskImportHelper.checkUniqueForFieldInFile((AbstractFormPlugin)this, "number", row.getString("number"), e);
        TaskImportHelper.checkUniqueForFieldInFile((AbstractFormPlugin)this, "name", row.getJSONObject("name").getString(RequestContext.get().getLang().toString()), e);
        for (Object entryObj : row.getJSONArray("entryentity")) {
            JSONObject entry = (JSONObject)entryObj;
            try {
                entry.getJSONObject("filterrulejson_tag");
            }
            catch (Exception e1) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u5206\u914d\u89c4\u5219\u8be6\u60c5\u5b57\u6bb5\u7684JSON\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DisRuleFormPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                entry.getJSONObject("applycreditleveljoson_tag");
            }
            catch (Exception e2) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u63d0\u5355\u4eba\u4fe1\u7528\u7b49\u7ea7\u8be6\u60c5\u5b57\u6bb5\u7684JSON\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DisRuleFormPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        long sscId = Long.parseLong(this.getPageCache().get("sscId"));
        for (Object entry : row.getJSONArray(ENTRYENTITY1)) {
            JSONObject orgRange = ((JSONObject)entry).getJSONObject("orgrange");
            if (orgRange == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"DisRuleFormPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]), row.getString("number")));
                return;
            }
            this.checkOrg4Ssc(sscId, (AbstractFormPlugin)this, ((JSONObject)entry).getJSONObject("orgrange").getString("number"), e);
            JSONObject userGroup = ((JSONObject)entry).getJSONObject("usergroup");
            if (userGroup == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u7528\u6237\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"DisRuleFormPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), row.getString("number")));
                return;
            }
            this.checkUserGroup4Ssc(sscId, userGroup.getString("number"), e);
        }
        JSONObject taskType = row.getJSONObject("tasktype");
        DynamicObject taskTypeObj = this.number2TaskTypeMap.get(taskType.getString("number"));
        if (taskTypeObj == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\uff08%s\uff09\u4e0d\u5b58\u5728\uff1b", (String)"DisRuleFormPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskType.getString("number")));
        } else if (!taskTypeObj.getBoolean("enable")) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\uff08%s\uff09\u5df2\u7981\u7528\uff1b", (String)"DisRuleFormPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskType.getString("number")));
        } else {
            taskType.put("id", (Object)taskTypeObj.getLong("id"));
        }
        JSONArray billTypeEntity = row.getJSONArray("entryentity");
        for (int i = 0; i < billTypeEntity.size(); ++i) {
            JSONObject billType = billTypeEntity.getJSONObject(i).getJSONObject("billtype");
            DynamicObject billTypeObj = this.number2BillTypeMap.get(billType.getString("number"));
            if (billTypeObj == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\uff08%s\uff09\u4e0d\u5b58\u5728\uff1b", (String)"DisRuleFormPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), billType.getString("number")));
                continue;
            }
            if (!billTypeObj.getBoolean("effective")) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\uff08%s\uff09\u5df2\u5931\u6548\uff1b", (String)"DisRuleFormPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), billType.getString("number")));
                continue;
            }
            billType.put("id", (Object)billTypeObj.getLong("id"));
        }
    }

    private void checkOrg4Ssc(long sscId, AbstractFormPlugin plugin, String orgNumbers, BeforeImportDataEventArgs e) {
        List orgList;
        if (StringUtils.isEmpty((CharSequence)orgNumbers)) {
            return;
        }
        FormShowParameter formShowParameter = plugin.getView().getFormShowParameter();
        Object orgListObj = formShowParameter.getCustomParam("orgList");
        if (orgListObj == null) {
            orgList = OrgRelationQueryHelper.getFromOrgList((long)sscId);
            formShowParameter.setCustomParam("orgList", (Object)orgList);
        } else {
            orgList = (List)orgListObj;
        }
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "in", (Object)orgNumbers.split(",")).toArray());
        for (DynamicObject org : orgs) {
            if (orgList.contains(org.getLong("id"))) continue;
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e2d\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u672a\u59d4\u6258\u8be5\u5171\u4eab\u4e2d\u5fc3\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u5173\u7cfb\u3002", (String)"DisRuleFormPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]), org.getString("number")));
            return;
        }
    }

    private void checkUserGroup4Ssc(long sscId, String groupNumber, BeforeImportDataEventArgs e) {
        if (groupNumber == null) {
            return;
        }
        DynamicObject group = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id,number,enable", (QFilter[])new QFilter("number", "=", (Object)groupNumber).and(new QFilter("createorg", "=", (Object)sscId)).toArray());
        if (group == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7528\u6237\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"DisRuleFormPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), groupNumber));
            return;
        }
        if (!group.getBoolean("enable")) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7528\u6237\u7ec4\u5df2\u7981\u7528\u3002", (String)"DisRuleFormPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]), groupNumber));
        }
    }
}

