/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ConfigServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.face.TaskFacade;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class TaskApprovalHistoryPlugin
extends AbstractFormPlugin {
    private static String EASSUBMIT_VALUE = "0";
    private static String EASAPPROVAL_VALUE = "1";
    private static String EASCURRENT_VALUE = "2";
    private static String UASE_NULL = "userIsNull_";
    private static String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";
    private static final Log log = LogFactory.getLog(TaskApprovalHistoryPlugin.class);

    public void initialize() {
        ControlTypes.register(ApprovalRecord.class);
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long taskid = Long.parseLong(formShowParameter.getCustomParam("taskid").toString());
        long billtypeid = Long.parseLong(formShowParameter.getCustomParam("billtypeid").toString());
        boolean isHist = Boolean.parseBoolean(formShowParameter.getCustomParam("isHist").toString());
        String erpNumber = this.getErpNumber(billtypeid);
        String entityName = isHist ? "task_taskhistory" : "task_task";
        try {
            DynamicObject task;
            if (taskid > 0L && (task = ORM.create().getById(entityName, (Object)taskid)) != null && task.get("procinstid") != null && task.get("billid") != null) {
                String billid = task.getString("billid");
                String procinstId = task.get("procinstid").toString();
                String externalerpNum = task.getString("billtype.externalerp.number");
                if ("KDCC".equalsIgnoreCase(externalerpNum)) {
                    this.setNextAuditRecord(billid);
                } else {
                    this.setExtendBillAuditRecord(isHist, erpNumber, billid, procinstId, taskid);
                }
            }
        }
        catch (Exception e1) {
            log.error("\u8bbe\u7f6e\u5ba1\u6279\u8bb0\u5f55\u62a5\u9519", (Throwable)e1);
            if (e1.getMessage() != null && e1.getMessage().startsWith(UASE_NULL)) {
                String[] mesgs = e1.getMessage().split("_");
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u7528\u6237%s\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"TaskApprovalHistoryPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), mesgs.length > 1 ? mesgs[1] : ""));
            }
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e1});
        }
    }

    private void setExtendBillAuditRecord(boolean isHist, String erpNumber, String billid, String procinstId, long taskid) throws Exception {
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)erpNumber);
        log.info("kd.ssc.task.formplugin.TaskApprovalHistoryPlugin.setExtendBillAuditRecord billid:" + billid + ";procinstId:" + procinstId);
        String recorde = taskFacade.getApprovalOpinion(billid, procinstId, taskid);
        log.info("kd.ssc.task.formplugin.TaskApprovalHistoryPlugin.setExtendBillAuditRecord recorde:" + recorde);
        log.info("kd.ssc.task.formplugin.TaskApprovalHistoryPlugin.setExtendBillAuditRecord end");
        this.setTaskApproveHst(recorde, isHist, billid);
    }

    private void setNextAuditRecord(String billid) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("isPC", "true");
        ((ApprovalRecord)this.getControl("approvalrecordap")).setParameters(parameters);
        ((ApprovalRecord)this.getControl("approvalrecordap")).setBusinessKey(billid);
    }

    protected String getErpNumber(long billtypeid) {
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        String erpNumber = (String)billType.get("externalerp.number");
        return erpNumber;
    }

    public void setTaskApproveHst(String data, boolean isHist, String billID) throws Exception {
        if (data == null || data.trim().length() == 0) {
            return;
        }
        ArrayList<Map<String, Object>> approvalRecordItems = new ArrayList<Map<String, Object>>();
        JSONArray jsonList = JSONArray.fromObject((Object)data);
        DynamicObject imageScanRecorde = this.getImageScanRecorde(billID);
        for (int i = jsonList.size() - 1; i >= 0; --i) {
            JSONObject approveHst = jsonList.getJSONObject(i);
            String type = approveHst.getString("type");
            HashMap<String, Object> approvalRecordItem = new HashMap<String, Object>();
            if (EASSUBMIT_VALUE.equals(type)) {
                approvalRecordItem.put("group", "startGroup");
                approvalRecordItem.put("groupDecisionType", "approve");
            } else if (EASAPPROVAL_VALUE.equals(type)) {
                approvalRecordItem.put("group", "approved");
                approvalRecordItem.put("groupDecisionType", "approve");
            } else if (EASCURRENT_VALUE.equals(type)) {
                if (isHist) continue;
                approvalRecordItem.put("group", "currentGroup");
                approvalRecordItem.put("groupDecisionType", "wait");
            }
            this.setScanUserNode(imageScanRecorde, approveHst, approvalRecordItems);
            ArrayList<Map<String, Object>> childrenItems = new ArrayList<Map<String, Object>>();
            childrenItems.add(this.createChildrenItem(approveHst));
            approvalRecordItem.put("children", childrenItems);
            approvalRecordItems.add(approvalRecordItem);
        }
        if (approvalRecordItems.size() == jsonList.size()) {
            this.appScanUserNode(imageScanRecorde, approvalRecordItems);
        }
        if (!approvalRecordItems.isEmpty()) {
            ((ApprovalRecord)this.getControl("approvalrecordap")).setData(approvalRecordItems);
        }
    }

    public Map<String, Object> createChildrenItem(JSONObject approveHst) throws Exception {
        HashMap<String, Object> childrenItem = new HashMap<String, Object>();
        String personName = approveHst.getString("personname");
        String personNumber = approveHst.getString("personnumber");
        Object personId = approveHst.get("personid");
        DynamicObject user = this.getIERPUser(personId + "", personName, personNumber);
        if (user == null) {
            childrenItem.put("userName", this.getRecordeUserName(approveHst, user));
        } else {
            childrenItem.put("openId", user.get("useropenid"));
            childrenItem.put("avatar", user.get("picturefield"));
            childrenItem.put("userName", this.getRecordeUserName(approveHst, user));
        }
        String type = approveHst.getString("type");
        String resultName = "";
        if (approveHst.containsKey((Object)"positionname")) {
            resultName = this.createPositionNameHtml(approveHst.getString("positionname"));
        }
        if (EASSUBMIT_VALUE.equals(type)) {
            childrenItem.put("decisionType", "approve");
            childrenItem.put("resultName", String.format(ResManager.loadKDString((String)"%s\uff1a\u540c\u610f", (String)"TaskApprovalHistoryPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), resultName));
            String time = this.getRecordeDateStr(approveHst);
            if (time != null) {
                childrenItem.put("time", time);
            }
        } else if (EASAPPROVAL_VALUE.equals(type)) {
            boolean ispass = Boolean.parseBoolean(approveHst.getString("ispass"));
            if (ispass) {
                resultName = String.format(ResManager.loadKDString((String)"%s\uff1a\u540c\u610f", (String)"TaskApprovalHistoryPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), resultName);
                childrenItem.put("decisionType", "approve");
            } else {
                resultName = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u540c\u610f", (String)"TaskApprovalHistoryPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), resultName);
                childrenItem.put("decisionType", "reject");
            }
            childrenItem.put("resultName", resultName);
            String time = this.getRecordeDateStr(approveHst);
            if (time != null) {
                childrenItem.put("time", time);
            }
            if (approveHst.containsKey((Object)"opinion")) {
                childrenItem.put("message", approveHst.getString("opinion"));
            }
        } else if (EASCURRENT_VALUE.equals(type)) {
            childrenItem.put("decisionType", "wait");
            childrenItem.put("resultName", String.format(ResManager.loadKDString((String)"%s\uff1a\u5904\u7406\u4e2d", (String)"TaskApprovalHistoryPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), resultName));
        }
        return childrenItem;
    }

    private DynamicObject getIERPUser(String personid, String personName, String personNumber) {
        SysIntegrationServiceHelper sysHelper = new SysIntegrationServiceHelper();
        long externalSysID = 1L;
        String dataTypeNumber = "bos_person";
        Map map = SysIntegrationServiceHelper.getInternalData((Long)externalSysID, (String)dataTypeNumber, (String)personid, (String)personNumber, (String)personName);
        return ORM.create().getById("bos_user", map.get("id"));
    }

    private String getRecordeDateStr(JSONObject approveHst) {
        if (approveHst.containsKey((Object)"createtime")) {
            long timestamp = approveHst.getLong("createtime");
            Date time = new Date();
            time.setTime(timestamp);
            SimpleDateFormat bf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String formatTime = bf.format(time);
            return formatTime;
        }
        return null;
    }

    private Date getRecordeDate(JSONObject approveHst) {
        if (approveHst.containsKey((Object)"createtime")) {
            long timestamp = approveHst.getLong("createtime");
            Date time = new Date();
            time.setTime(timestamp);
            return time;
        }
        return null;
    }

    private String getRecordeUserName(JSONObject approveHst, DynamicObject user) {
        StringBuilder message = new StringBuilder();
        message.append(approveHst.containsKey((Object)"aactdefname") ? approveHst.getString("aactdefname") + " " : "");
        if (user == null) {
            message.append(approveHst.getString("personname"));
        } else {
            message.append(user.get("name"));
        }
        return message.toString();
    }

    private DynamicObject getImageScanRecorde(String billID) {
        DynamicObject obj;
        QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)billID)};
        DynamicObjectCollection cols = ORM.create().query("task_billimagemap", "id,billid,scanuserid,scantime,nextscanuserid", filters, "scantime desc");
        DynamicObject dynamicObject = obj = cols == null || cols.isEmpty() ? null : (DynamicObject)cols.get(0);
        if (obj != null) {
            obj.set("nextscanuserid", (Object)this.getIERPUser(obj.getString("scanuserid"), null, null));
        }
        return obj;
    }

    private void setScanUserNode(DynamicObject imageScanRecorde, JSONObject approveHst, List<Map<String, Object>> approvalRecordItems) {
        if (imageScanRecorde == null) {
            return;
        }
        Date scantime = imageScanRecorde.getDate("scantime");
        Date recordeDate = this.getRecordeDate(approveHst);
        DynamicObject nextscanuser = imageScanRecorde.getDynamicObject("nextscanuserid");
        if (scantime != null && recordeDate != null && scantime.compareTo(recordeDate) > 0 && nextscanuser != null) {
            this.insertScanUserNode(imageScanRecorde, approvalRecordItems);
        }
    }

    private void appScanUserNode(DynamicObject imageScanRecorde, List<Map<String, Object>> approvalRecordItems) {
        if (imageScanRecorde == null) {
            return;
        }
        Date scantime = imageScanRecorde.getDate("scantime");
        DynamicObject nextscanuser = imageScanRecorde.getDynamicObject("nextscanuserid");
        if (scantime != null && nextscanuser != null) {
            this.insertScanUserNode(imageScanRecorde, approvalRecordItems);
        }
    }

    private void insertScanUserNode(DynamicObject imageScanRecorde, List<Map<String, Object>> approvalRecordItems) {
        HashMap<String, Object> approvalRecordItem = new HashMap<String, Object>();
        approvalRecordItem.put("group", "approved");
        approvalRecordItem.put("groupDecisionType", "approve");
        ArrayList<Map<String, Object>> childrenItems = new ArrayList<Map<String, Object>>();
        childrenItems.add(this.createScanUserNode(imageScanRecorde));
        approvalRecordItem.put("children", childrenItems);
        approvalRecordItems.add(approvalRecordItem);
        imageScanRecorde.set("nextscanuserid", null);
    }

    private Map<String, Object> createScanUserNode(DynamicObject imageScanRecorde) {
        HashMap<String, Object> childrenItem = new HashMap<String, Object>();
        DynamicObject nextscanuser = imageScanRecorde.getDynamicObject("nextscanuserid");
        StringBuilder userNameBuff = new StringBuilder();
        userNameBuff.append(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf%s", (String)"TaskApprovalHistoryPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), " " + nextscanuser.get("name")));
        childrenItem.put("openId", nextscanuser.get("useropenid"));
        if (nextscanuser.getLong("id") != 0L) {
            Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(nextscanuser.getLong("id")), (boolean)true);
            String imgURL = (String)userAvatarPathMap.get(nextscanuser.getLong("id"));
            if (StringUtils.isBlank((CharSequence)imgURL)) {
                childrenItem.put("avatar", COMMON_URL);
            } else {
                childrenItem.put("avatar", imgURL);
            }
        }
        childrenItem.put("userName", userNameBuff.toString());
        childrenItem.put("decisionType", "approve");
        String positionNameHtml = this.createPositionNameHtml(ResManager.loadKDString((String)"\u5f71\u50cf\u626b\u63cf\u5458", (String)"TaskApprovalHistoryPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        childrenItem.put("resultName", String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0a\u4f20\u5f71\u50cf\u6210\u529f", (String)"TaskApprovalHistoryPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), positionNameHtml));
        childrenItem.put("time", imageScanRecorde.getDate("scantime"));
        return childrenItem;
    }

    private String createPositionNameHtml(String positionname) {
        String url = (String)ConfigServiceHelper.getGlobalConfiguration((String)"fileserver");
        url = url + "FI/SSC/zhiwu_0_Jg2f0mi25x2e31DoU8.png";
        return " <img src=\"" + url + "\"  title=\"" + positionname + "\" /> ";
    }
}

