/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.ssc.task.formplugin.util.AchieveUtil;
import kd.ssc.task.formplugin.util.ViewFlowchartUtil;
import kd.ssc.task.util.SscLicenseUtil;

public class AchieveEvaluteListPlugin
extends AbstractListPlugin {
    private static final Set<String> operations = new HashSet<String>(5);
    private static final String OP_ADDNEW = "addnew";
    private static final String SSC_CHOOSEPLANPERIOD = "ssc_chooseplanperiod";

    public void preOpenForm(PreOpenFormEventArgs e) {
        SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"ssc_achieveevalute");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String reportType = (String)this.getView().getFormShowParameter().getCustomParams().get("reportType");
        if ("myReport".equals(reportType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbladdnew", "tblaudit", "tblunaud", "tbldel"});
        }
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection collection = super.getData(start, limit);
                ArrayList ids = new ArrayList();
                collection.forEach(v -> ids.add(String.valueOf(v.getPkValue())));
                if (ids.size() > 0) {
                    AchieveEvaluteListPlugin.this.setNextAuditor(collection, ids);
                }
                return collection;
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (operations.contains(itemKey) && !AchieveUtil.codeRule("ssc_achieveevalute")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6216\u5df2\u7981\u7528\u7ee9\u6548\u62a5\u544a\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"AchieveEvaluteListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ArrayList<QFilter> cusFilters = new ArrayList<QFilter>();
        String reportType = (String)this.getView().getFormShowParameter().getCustomParams().get("reportType");
        if ("userReport".equals(reportType)) {
            QFilter assessTypeFilter = new QFilter("assessdimension", "=", (Object)"2");
            cusFilters.add(assessTypeFilter);
        } else if ("myReport".equals(reportType)) {
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter userFilter = new QFilter("applicant", "=", (Object)currUserId);
            cusFilters.add(userFilter);
        }
        e.setCustomQFilters(cusFilters);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OP_ADDNEW.equals(operateKey) && operationResult.isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(SSC_CHOOSEPLANPERIOD);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            IListView listView = (IListView)this.getView();
            List sscIds = listView.getSelectedMainOrgIds();
            Long sscId = (Long)sscIds.get(0);
            showParameter.setCustomParam("sscid", (Object)(sscId + ""));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SSC_CHOOSEPLANPERIOD));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (SSC_CHOOSEPLANPERIOD.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fileldName = args.getHyperLinkClickEvent().getFieldName();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if ("nextauditor".equals(fileldName)) {
            args.setCancel(true);
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7ee9\u6548\u8bc4\u4ef7\u5355\u3002", (String)"AchieveEvaluteListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Object billid = selectedRows.get(0).getPrimaryKeyValue();
            ListShowParameter listshow = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listshow.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billid);
        }
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> ids) {
        Map<String, String> nextAuditor = ViewFlowchartUtil.getNextAuditor(ids);
        collection.forEach(v -> {
            String id = String.valueOf(v.getPkValue());
            v.set("nextauditor", (Object)(nextAuditor.get(id) == null ? "" : nextAuditor.get(id)));
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object source = formShowParameter.getCustomParam("source");
        if (source == null) {
            return;
        }
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!source.toString().equals("scheme") || !"sscid.name".equals(fieldName)) continue;
            Object sscId = formShowParameter.getCustomParam("sscid");
            if (sscId == null) {
                return;
            }
            commonFilterColumn.setDefaultValue(sscId.toString());
        }
    }

    static {
        operations.addAll(Arrays.asList("tbladdnew", "tblsubmit", "tblunsubm", "tblaudit", "tblunaudit"));
    }
}

