/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AchievePropTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private Map<String, String> propNameCache;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        TreeView tree = (TreeView)this.getView().getControl("propTree");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String entityNumber = (String)paramter.getCustomParam("entityNumber");
        String entityName = (String)paramter.getCustomParam("entityName");
        String field = (String)paramter.getCustomParam("fieldConfiguration");
        TreeNode root = this.createEntityPropertyTree(entityNumber, entityName, null, field);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map mapEntry = entityType.getAllEntities();
        for (Map.Entry entry : mapEntry.entrySet()) {
            TreeNode entryNode = new TreeNode();
            EntityType entityTypeEntry = (EntityType)entry.getValue();
            String key = (String)entry.getKey();
            if (entityNumber.equals(key)) continue;
            entryNode = this.createEntityPropertyTree(key, entityTypeEntry.getDisplayName().toString(), entityTypeEntry, field);
            root.addChild(entryNode);
        }
        TreeView tree = (TreeView)this.getControl("proptree");
        root.setIsOpened(Boolean.TRUE.booleanValue());
        tree.addNode(root);
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put("selectNode", nodeId);
        String parentNodes = this.getPageCache().get("parentNodes");
        List list = (List)SerializationUtils.fromJsonString((String)parentNodes, List.class);
        this.getView().setEnable(Boolean.valueOf(!list.contains(nodeId)), new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            HashMap<String, String> returnData = new HashMap<String, String>();
            String nodeId = this.getPageCache().get("selectNode");
            if (StringUtils.isEmpty((CharSequence)nodeId)) {
                this.getView().close();
            }
            returnData.put("number", nodeId);
            this.propNameCache = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("propNameCache"), Map.class);
            returnData.put("name", this.propNameCache.get(nodeId));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private TreeNode createEntityPropertyTree(String entityNumber, String entityName, EntityType entityTypeEntry, String fieldconfiguration) {
        TreeNode root;
        block6: {
            root = new TreeNode();
            try {
                MainEntityType entityType = null;
                DataEntityPropertyCollection proColl = null;
                if (entityTypeEntry == null) {
                    root.setId("root");
                    root.setText(entityName);
                    entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    proColl = entityType.getProperties();
                } else {
                    if (entityTypeEntry instanceof SubEntryType && entityTypeEntry.getParent() != null && entityTypeEntry.getParent().getParent() != null) {
                        entityNumber = entityTypeEntry.getParent().getName() + "." + entityNumber;
                    }
                    root.setId(entityNumber);
                    root.setText(entityName);
                    proColl = entityTypeEntry.getProperties();
                }
                List<TreeNode> children = this.generatePropChildren(root.getId(), proColl, fieldconfiguration, entityTypeEntry != null);
                root.setChildren(children);
                String parentNodes = this.getPageCache().get("parentNodes");
                List<String> parentNodeList = new ArrayList<String>(4);
                if (parentNodes != null) {
                    parentNodeList = (List)SerializationUtils.fromJsonString((String)parentNodes, List.class);
                }
                parentNodeList.add(root.getId());
                this.getPageCache().put("parentNodes", SerializationUtils.toJsonString(parentNodeList));
            }
            catch (KDException e) {
                root.setId("root");
                if (!e.getErrorCode().equals((Object)BosErrorCode.entityMetaDataNotExist)) break block6;
                root.setText(e.getLocalizedMessage());
            }
        }
        return root;
    }

    private List<TreeNode> generatePropChildren(String parentID, DataEntityPropertyCollection proColl, String fieldconfiguration, boolean isEntry) {
        String propNameCacheString = this.getPageCache().get("propNameCache");
        if (this.propNameCache == null) {
            this.propNameCache = propNameCacheString != null ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)propNameCacheString, Map.class) : new HashMap<String, String>(16);
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (IDataEntityProperty prop : proColl) {
            DynamicProperty dp;
            if (prop instanceof DynamicLocaleProperty || prop instanceof PKFieldProp || prop instanceof EntryProp) continue;
            boolean fieldmapping = true;
            switch (fieldconfiguration) {
                case "sum": 
                case "max": 
                case "min": 
                case "avg": {
                    if (prop instanceof DecimalProp) break;
                    fieldmapping = false;
                    break;
                }
                case "0": {
                    if (prop instanceof DateTimeProp) break;
                    fieldmapping = false;
                    break;
                }
                case "1": 
                case "2": {
                    if (prop instanceof BasedataProp || prop instanceof BigIntProp || prop instanceof TextProp) break;
                    fieldmapping = false;
                }
            }
            if (!fieldmapping) continue;
            String propName = prop.getName();
            if (isEntry && "seq".equals(propName)) continue;
            TreeNode node = new TreeNode();
            node.setParentid(parentID);
            if ("root".equals(parentID)) {
                node.setId(propName);
            } else {
                node.setId(parentID + "." + propName);
            }
            node.setText(propName);
            if (prop instanceof DynamicProperty && (dp = (DynamicProperty)prop).getDisplayName() != null) {
                node.setText(dp.getDisplayName().toString());
            }
            this.propNameCache.put(node.getId(), node.getText());
            nodeList.add(node);
        }
        this.getPageCache().put("propNameCache", SerializationUtils.toJsonString(this.propNameCache));
        return nodeList;
    }
}

