/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.condition.ConFieldTypeEnum;
import kd.ssc.task.business.condition.ConditionDataQueryHelper;
import kd.ssc.task.business.condition.ConditionFilterHelper;

public class ConditionF7SelectFormPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_NEXT = "btnnext";
    private static final String PANEL_F7 = "f7contentpanel";
    private static final String PANEL_NEXT = "netxsteppanel";
    private static final String OP_CHECK_SAVE = "check_save";
    private static final String CB_SELECT_PROP = "callback_selectProp";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_NEXT, "billfield"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFormVisible(Boolean.FALSE);
        this.showF7Form();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setShowTitle(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_NEXT.equals(key)) {
            IListView f7View = (IListView)this.getView().getView(this.getPageCache().get("f7ViewPageId"));
            if (!f7View.getSelectedRows().isEmpty()) {
                Object[] selectedIds = f7View.getSelectedRows().getPrimaryKeyValues();
                this.setFormVisible(Boolean.TRUE);
                this.buildEntryData((Long)selectedIds[0]);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ConditionF7SelectFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("billfield".equals(key)) {
            this.showPropSelectForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        if (CB_SELECT_PROP.equals(actionId)) {
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("billfield", (Object)name, currentRowIndex);
            model.setValue("billfieldnumber", (Object)number, currentRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        IFormView view = this.getView();
        String operateKey = eventArgs.getOperateKey();
        if (OP_CHECK_SAVE.equals(operateKey) && eventArgs.getOperationResult().isSuccess() && this.saveConfigData()) {
            IListView f7View = (IListView)this.getView().getView(this.getPageCache().get("f7ViewPageId"));
            Object[] selectedIds = f7View.getSelectedRows().getPrimaryKeyValues();
            view.returnDataToParent(selectedIds[0]);
            view.close();
        }
    }

    private void showF7Form() {
        IFormView view = this.getView();
        ListShowParameter lsp = CoreShowFormHelper.createShowListForm((String)"ssc_apply_condition", (boolean)false);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.getOpenStyle().setTargetKey(PANEL_F7);
        lsp.getOpenStyle().setInlineStyleCss(null);
        lsp.setShowApproved(true);
        lsp.setShowUsed(true);
        lsp.addCustPlugin("kd.ssc.task.formplugin.condition.HideF7ToolPanelPlugin");
        List qFilters = lsp.getListFilterParameter().getQFilters();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        qFilters.add(enableFilter);
        this.getPageCache().put("f7ViewPageId", lsp.getPageId());
        view.showForm((FormShowParameter)lsp);
    }

    private void showPropSelectForm() {
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        String entityNumber = ((DynamicObject)model.getValue("sourcebill", currentRowIndex)).getString("number");
        DynamicObject conField = (DynamicObject)model.getValue("confield", currentRowIndex);
        String fieldType = conField.getString("fieldtype");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ssc_entitytree");
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        showParameter.setCustomParam("conFieldType", (Object)fieldType);
        if (ConFieldTypeEnum.BASE_DATA.getValue().equals(fieldType)) {
            showParameter.setCustomParam("baseDataType", (Object)conField.getString("basedatatype.number"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CB_SELECT_PROP));
        this.getView().showForm(showParameter);
    }

    private void setFormVisible(Boolean nextStep) {
        IFormView view = this.getView();
        view.setVisible(nextStep, new String[]{PANEL_NEXT});
        view.setVisible(nextStep, new String[]{BTN_OK});
        view.setVisible(Boolean.valueOf(nextStep == false), new String[]{PANEL_F7});
        view.setVisible(Boolean.valueOf(nextStep == false), new String[]{BTN_NEXT});
    }

    private void buildEntryData(Long conditionId) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter fsp = view.getFormShowParameter();
        String bindbill = (String)fsp.getCustomParam("bindbill");
        if (StringUtils.isEmpty((String)bindbill)) {
            return;
        }
        Set conditionFields = ConditionFilterHelper.getFieldsOfCondition((Long)conditionId);
        Map fieldIds = ConditionDataQueryHelper.queryFieldIdByNumber((Set)conditionFields);
        if (fieldIds.isEmpty()) {
            return;
        }
        QFilter joinFilter = QFilter.join((String)"id", (String)"ssc_confield_mapping.confield", (QFilter)new QFilter("ssc_confield_mapping.sourcebill", "=", (Object)bindbill));
        QFilter ableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter fieldFilter = new QFilter("id", "in", fieldIds.values());
        String selectField = "id confield,R.id mId,R.sourcebill sourcebill,R.billfield billfield,R.billfieldnumber billfieldnumber";
        selectField = selectField.replaceAll("R", "ssc_confield_mapping");
        DynamicObjectCollection mappingCol = QueryServiceHelper.query((String)"ssc_condition_field", (String)selectField, (QFilter[])new QFilter[]{joinFilter, ableFilter, fieldFilter});
        Set distributed = mappingCol.stream().map(m -> m.getString("sourcebill") + "-" + m.getString("confield")).collect(Collectors.toSet());
        for (Long conField : fieldIds.values()) {
            if (distributed.contains(bindbill + "-" + conField)) continue;
            int index = model.createNewEntryRow("entryentity");
            model.setValue("sourcebill", (Object)bindbill, index);
            model.setValue("confield", (Object)conField, index);
        }
        if (mappingCol.size() > 0) {
            int i = 0;
            for (int index : model.batchCreateNewEntryRow("entryentity", mappingCol.size())) {
                DynamicObject mapping = (DynamicObject)mappingCol.get(i);
                model.setValue("id", (Object)mapping.getLong("mId"), index);
                model.setValue("sourcebill", (Object)mapping.getString("sourcebill"), index);
                model.setValue("confield", (Object)mapping.getLong("confield"), index);
                model.setValue("billfield", (Object)mapping.getString("billfield"), index);
                model.setValue("billfieldnumber", (Object)mapping.getString("billfieldnumber"), index);
                ++i;
            }
        }
    }

    private boolean saveConfigData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (!model.getDataChanged()) {
            return true;
        }
        DynamicObjectCollection mappingCol = model.getEntryEntity("entryentity");
        List changedRows = mappingCol.stream().filter(c -> c.getDataEntityState().isBizChanged()).collect(Collectors.toList());
        if (changedRows.size() > 0) {
            OperationResult operationResult;
            ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(changedRows.size());
            HashMap<Long, DynamicObject> updateTempData = new HashMap<Long, DynamicObject>(changedRows.size());
            for (DynamicObject changedRow : changedRows) {
                long mappingId = changedRow.getLong("id");
                String billField = changedRow.getString("billfield");
                String billFieldNumber = changedRow.getString("billfieldnumber");
                if (mappingId > 0L && StringUtils.isNotEmpty((String)billFieldNumber)) {
                    updateTempData.put(mappingId, changedRow);
                    continue;
                }
                if (mappingId != 0L || !StringUtils.isNotEmpty((String)billFieldNumber)) continue;
                DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"ssc_confield_mapping");
                newData.set("confield", changedRow.get("confield"));
                newData.set("sourcebill", changedRow.get("sourcebill"));
                newData.set("billfield", (Object)billField);
                newData.set("billfieldnumber", (Object)billFieldNumber);
                saveData.add(newData);
            }
            if (updateTempData.size() > 0) {
                DynamicObject[] load;
                for (DynamicObject row : load = BusinessDataServiceHelper.load((Object[])updateTempData.keySet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_confield_mapping"))) {
                    Long id = row.getLong("id");
                    DynamicObject temp = (DynamicObject)updateTempData.get(id);
                    if (temp == null) continue;
                    row.set("billfield", temp.get("billfield"));
                    row.set("billfieldnumber", temp.get("billfieldnumber"));
                    saveData.add(row);
                }
            }
            if (saveData.size() > 0 && !(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ssc_confield_mapping", (DynamicObject[])saveData.toArray(new DynamicObject[0]), null)).isSuccess()) {
                view.showTipNotification(operationResult.getMessage());
                return false;
            }
        }
        return true;
    }
}

