/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.condition.ConFieldTypeEnum;

public class ConditionFieldListPlugin
extends AbstractListPlugin {
    private static final String OP_FIELD_MAPPING = "fieldmapping";
    private static final String OP_MAPPING_CON2BILL = "confield2billfield";
    private static final String OP_MAPPING_BILL2CON = "billfield2confield";

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        if (OP_FIELD_MAPPING.equals(operateKey)) {
            this.showFieldMappingList();
        } else if (OP_MAPPING_CON2BILL.equals(operateKey) || OP_MAPPING_BILL2CON.equals(operateKey)) {
            this.showFieldMappingForm(operateKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String actionId = event.getActionId();
        if (OP_MAPPING_CON2BILL.equals(actionId) && (returnData = event.getReturnData()) != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConditionFieldListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void showFieldMappingList() {
        IListView view = (IListView)this.getView();
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setFormId("bos_list");
        lsp.setBillFormId("ssc_confield_mapping");
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            QFilter filter = new QFilter("confield", "in", (Object)selectedRows.getPrimaryKeyValues());
            lsp.getListFilterParameter().setFilter(filter);
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showFieldMappingForm(String opKey) {
        ListSelectedRow currentSelectedRowInfo;
        IListView view = (IListView)this.getView();
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("ssc_" + opKey);
        if (OP_MAPPING_CON2BILL.equals(opKey) && (currentSelectedRowInfo = view.getCurrentSelectedRowInfo()) != null) {
            fsp.setCustomParam("defConField", currentSelectedRowInfo.getPrimaryKeyValue());
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opKey));
        }
        view.showForm(fsp);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        block9: {
            DynamicObject[] queryValues = e.getQueryValues();
            if (queryValues.length <= 0) break block9;
            boolean containCombo = queryValues[0].getDataEntityType().getProperties().containsKey((Object)"comboitem");
            boolean containJson = queryValues[0].getDataEntityType().getProperties().containsKey((Object)"comboitemjson_tag");
            if (containCombo) {
                if (containJson) {
                    for (DynamicObject data : queryValues) {
                        String itemsJson;
                        String fieldType = data.getString("fieldtype");
                        if (!ConFieldTypeEnum.COMBO.getValue().equals(fieldType) || StringUtils.isEmpty((String)(itemsJson = data.getString("comboitemjson_tag")))) continue;
                        StringBuilder sb = new StringBuilder();
                        JSONObject extraInfo = JSON.parseObject((String)itemsJson);
                        JSONArray items = extraInfo.getJSONArray("items");
                        for (Object item : items) {
                            JSONObject item_ = (JSONObject)item;
                            sb.append(item_.getString("Value")).append(":").append(item_.getString("Caption")).append(",");
                        }
                        if (sb.length() <= 0) continue;
                        sb.deleteCharAt(sb.length() - 1);
                        data.set("comboitem", (Object)sb.toString());
                    }
                } else {
                    List comboData = Arrays.stream(queryValues).filter(d -> ConFieldTypeEnum.COMBO.getValue().equals(d.getString("fieldtype"))).collect(Collectors.toList());
                    if (comboData.size() > 0) {
                        Set ids = comboData.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
                        QFilter filter = new QFilter("id", "in", ids);
                        DynamicObjectCollection data = QueryServiceHelper.query((String)"ssc_condition_field", (String)"id,comboitemjson_tag", (QFilter[])filter.toArray());
                        if (data == null) {
                            return;
                        }
                        Map<Long, String> jsonMap = data.stream().collect(Collectors.toMap(f -> f.getLong("id"), f -> f.getString("comboitemjson_tag")));
                        for (DynamicObject combo : comboData) {
                            String itemsJson = jsonMap.get(combo.getLong("id"));
                            if (StringUtils.isEmpty((String)itemsJson)) continue;
                            StringBuilder sb = new StringBuilder();
                            JSONObject extraInfo = JSON.parseObject((String)itemsJson);
                            JSONArray items = extraInfo.getJSONArray("items");
                            for (Object item : items) {
                                JSONObject item_ = (JSONObject)item;
                                sb.append(item_.getString("Value")).append(":").append(item_.getString("Caption")).append(",");
                            }
                            if (sb.length() <= 0) continue;
                            sb.deleteCharAt(sb.length() - 1);
                            combo.set("comboitem", (Object)sb.toString());
                        }
                    }
                }
            }
        }
    }
}

