/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.business.condition.ConFieldTypeEnum;

public class ConditionMappingFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ConditionMappingFormPlugin.class);

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObject conField = (DynamicObject)model.getValue("confield");
        DynamicObject sourceBill = (DynamicObject)model.getValue("sourcebill");
        String fieldNumber = (String)model.getValue("billfieldnumber");
        if (ObjectUtils.isEmpty((Object)conField) || ObjectUtils.isEmpty((Object)sourceBill) || StringUtils.isBlank((CharSequence)fieldNumber)) {
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)conField.getLong("id"));
        DynamicObject field = QueryServiceHelper.queryOne((String)"ssc_condition_field", (String)"fieldtype,basedatatype.number", (QFilter[])idFilter.toArray());
        if (field == null) {
            log.info("error data import,confield is not in system.");
            return;
        }
        String entityNumber = sourceBill.getString("number");
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            IDataEntityProperty prop = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldNumber);
            if (prop == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0d\u5b58\u5728key\u4e3a%2$s\u7684\u5c5e\u6027\u3002", (String)"ConditionMappingFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), entityNumber, fieldNumber));
                return;
            }
            ConFieldTypeEnum typeEnum = ConFieldTypeEnum.getTypeEnum((String)field.getString("fieldtype"));
            if (typeEnum == null) {
                return;
            }
            if (typeEnum.getPropType().isAssignableFrom(prop.getClass())) {
                if (ConFieldTypeEnum.BASE_DATA == typeEnum) {
                    String baseEntityId = ((BasedataProp)prop).getBaseEntityId();
                    if (!field.getString("basedatatype.number").equalsIgnoreCase(baseEntityId)) {
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027%2$s\u4e0e\u6761\u4ef6\u5b57\u6bb5\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ConditionMappingFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), entityNumber, fieldNumber));
                    }
                }
            } else {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0a\u7684\u5c5e\u6027%2$s\u4e0e\u6761\u4ef6\u5b57\u6bb5\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ConditionMappingFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), entityNumber, fieldNumber));
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

