/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.credit;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.PermissionItemEnum;
import kd.ssc.task.formplugin.util.SscUtil;

public class CreditApplicationFormPlugin
extends AbstractFormPlugin
implements FilterContainerInitListener,
SearchClickListener,
RowClickEventListener {
    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("task_creditappwaittime");
        fc.addFilterContainerInitListener((FilterContainerInitListener)this);
        fc.addSearchClickListener((SearchClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showRuleForm(0);
    }

    public void click(SearchClickEvent e) {
        Map filterValues = e.getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        for (Map map : customfilter) {
            if (!"createorg.id".equals(((List)map.get("FieldName")).get(0))) continue;
            this.getPageCache().put("createorg", String.valueOf(((List)map.get("Value")).get(0)));
            this.showRuleForm(0);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent e) {
        List commonFilter = e.getCommonFilterColumns();
        for (FilterColumn column : commonFilter) {
            String sscid;
            CommonFilterColumn commColumn = (CommonFilterColumn)column;
            if (!"createorg.name".equals(commColumn.getFieldName())) continue;
            List defaultValues = commColumn.getDefaultValues();
            List comboItems = commColumn.getComboItems();
            if ((defaultValues == null || defaultValues.size() == 0) && comboItems != null && comboItems.size() > 0) {
                commColumn.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
            if (StringUtils.isNotEmpty((String)(sscid = this.getPageCache().get("createorg")))) {
                commColumn.setDefaultValue(sscid);
                continue;
            }
            this.getPageCache().put("createorg", String.valueOf(commColumn.getDefaultValues().get(0)));
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        if ("refresh".equals(key)) {
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && ("donothing_save".equals(key) || "donothing_disable".equals(key) || "donothing_enable".equals(key) || "newentry".equals(key) || "deleteentry".equals(key))) {
            String pageId = this.getPageCache().get("pageId");
            IFormView childView = this.getView().getView(pageId);
            childView.invokeOperation(key);
            this.getView().sendFormAction(childView);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        super.entryRowClick(e);
        this.showRuleForm(0);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String mark;
        super.beforeClosed(e);
        String pageId = this.getPageCache().get("pageId");
        IFormView childView = this.getView().getView(pageId);
        if (childView.getModel().getDataChanged() && ((mark = this.getPageCache().get("mark")) == null || !"1".equals(mark))) {
            ConfirmCallBackListener close = new ConfirmCallBackListener("close");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"CreditChangeRuleFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, close);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("close".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("mark", "1");
            this.getView().close();
        }
    }

    private void showRuleForm(int selectRow) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_creditappwaittime_l");
        showParam.getOpenStyle().setShowType(ShowType.InContainer);
        showParam.getOpenStyle().setTargetKey("content");
        showParam.setCustomParam("sscid", (Object)this.getSscidFilter());
        this.getPageCache().put("pageId", showParam.getPageId());
        this.getView().showForm(showParam);
    }

    private String getSscidFilter() {
        String sscid = this.getPageCache().get("createorg");
        if (StringUtils.isEmpty((String)sscid)) {
            throw new KDBizException(new ErrorCode("ssc-creditapp", ResManager.loadKDString((String)"\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreditLevelListPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        return sscid;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_creditappwaittime", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"CreditApplicationFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkUserRight(PermissionItemEnum itemEnum, BeforeDoOperationEventArgs args) {
        int hasPerm;
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Long sscId = Long.parseLong(this.getPageCache().get("createorg"));
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((String)appId)) {
            appId = "ssc";
        }
        if ((hasPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)"12", (String)appId, (String)"task_creditappwaittime", (String)itemEnum.getId())) == 1) {
            return;
        }
        String errStr = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6743\u9650\u3002", (String)"CreditApplicationFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(String.format(errStr, itemEnum.getName()));
        args.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "newentry": {
                this.checkUserRight(PermissionItemEnum.ADDROW, args);
                break;
            }
            case "deleteentry": {
                this.checkUserRight(PermissionItemEnum.DELETEROW, args);
                break;
            }
            case "donothing_save": {
                this.checkUserRight(PermissionItemEnum.SAVE, args);
                break;
            }
            case "donothing_disable": {
                this.checkUserRight(PermissionItemEnum.DISABLE, args);
                break;
            }
            case "donothing_enable": {
                this.checkUserRight(PermissionItemEnum.ENABLE, args);
                break;
            }
        }
    }
}

