/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.credit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.credit.SubScoreRuleHelper;

public class TaskBeakRuleFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SELECT_SUBSCORE_RULE = "selectsubscorerule";
    private static final String SELECTBREAKRULE = "selectbreakrule";
    private static final String TASK_QUALITY_DOCHECK = "task_quality_docheck";
    private static final String TASK_QUALITY_DORECTITY = "task_quality_dorectify";
    private static final String TASK_QUALITY_DOREVIEW = "task_quality_doreview";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit baseData = (BasedataEdit)this.getControl(SELECT_SUBSCORE_RULE);
        baseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"save", "submit", "submitandnext"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Long taskid = Long.valueOf(showParam.getCustomParam("taskid").toString());
        if (TASK_QUALITY_DOCHECK.equals(showParam.getFormId()) || TASK_QUALITY_DORECTITY.equals(showParam.getFormId()) || TASK_QUALITY_DOREVIEW.equals(showParam.getFormId())) {
            taskid = Long.valueOf(showParam.getCustomParam("sourcetaskid").toString());
            this.setBreakRuleControl(taskid);
        } else {
            this.setBreakRuleControl(taskid);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String fromPage = (String)showParam.getCustomParam("from");
        Long taskid = Long.valueOf(showParam.getCustomParam("taskid").toString());
        String poolType = (String)showParam.getCustomParam("pooltype");
        String poolType_Mytask = (String)showParam.getCustomParam("pooltype-mytask");
        String poolTypeParam = StringUtils.isEmpty((String)poolType) ? poolType_Mytask : poolType;
        IFormView view = this.getView();
        if ("admin".equals(fromPage) || "2".equals(poolType_Mytask)) {
            view.setEnable(Boolean.FALSE, new String[]{"checkpointpanelap"});
        }
        if ("admin".equals(fromPage)) {
            view.setEnable(Boolean.FALSE, new String[]{SELECTBREAKRULE});
        } else if (StringUtils.isNotEmpty((String)poolType_Mytask) && "1".equals(poolType_Mytask)) {
            if (TASK_QUALITY_DOCHECK.equals(showParam.getFormId()) || TASK_QUALITY_DORECTITY.equals(showParam.getFormId()) || TASK_QUALITY_DOREVIEW.equals(showParam.getFormId())) {
                view.setEnable(Boolean.FALSE, new String[]{SELECTBREAKRULE});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{SELECTBREAKRULE});
            }
        } else {
            view.setEnable(Boolean.FALSE, new String[]{SELECTBREAKRULE});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        if (SELECT_SUBSCORE_RULE.equals(baseData.getKey())) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            Long taskid = Long.valueOf(showParam.getCustomParam("taskid").toString());
            String poolType = (String)showParam.getCustomParam("pooltype");
            if (StringUtils.isEmpty((String)poolType)) {
                poolType = (String)showParam.getCustomParam("pooltype-mytask");
            }
            List<Long> billRelationSubScoreRule = this.getBillRelationSubScoreRule(taskid, poolType);
            QFilter typeFil = new QFilter("id", "in", billRelationSubScoreRule);
            ListShowParameter listShowParam = (ListShowParameter)e.getFormShowParameter();
            listShowParam.getListFilterParameter().setQFilters(Collections.singletonList(typeFil));
        }
    }

    private void setBreakRuleControl(Long taskid) {
        String algoKey = TaskBeakRuleFormPlugin.class + ".setBreakRuleControl()";
        QFilter taskidFil = new QFilter("histaskid", "=", (Object)taskid);
        HashSet<Long> breakRules = new HashSet<Long>(8);
        HashSet<Long> subscorerules = new HashSet<Long>(8);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_crebreakrulerecord", (String)"breakrule, subscorerule", (QFilter[])new QFilter[]{taskidFil}, null);){
            for (Row row : dSet) {
                breakRules.add(row.getLong("breakrule"));
                subscorerules.add(row.getLong("subscorerule"));
            }
        }
        IDataModel model = this.getModel();
        model.beginInit();
        if (breakRules.size() > 0) {
            this.getModel().setValue(SELECTBREAKRULE, (Object)breakRules.toArray());
        }
        if (subscorerules.size() > 0) {
            this.getModel().setValue(SELECT_SUBSCORE_RULE, (Object)subscorerules.toArray());
        }
        model.endInit();
    }

    private List<Long> getBillRelationSubScoreRule(Long taskid, String pooltype) {
        return SubScoreRuleHelper.getBillRelationSubScoreRuleByTask((Long)taskid, (String)pooltype);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        String taskId = this.getPageCache().get("taskid");
        DynamicObjectCollection breakRules = (DynamicObjectCollection)this.getModel().getValue(SELECT_SUBSCORE_RULE);
        ArrayList<Long> breaskRuleIds = new ArrayList<Long>();
        for (DynamicObject dynObj : breakRules) {
            breaskRuleIds.add(dynObj.getLong("fbasedataid_id"));
        }
        switch (fieldKey) {
            case "save": {
                this.deleteTempSubScoreRule(Long.valueOf(taskId));
                this.saveTempSubscoreRule(Long.valueOf(taskId), breaskRuleIds);
                break;
            }
            case "submit": 
            case "submitandnext": {
                this.deleteTempSubScoreRule(Long.valueOf(taskId));
                break;
            }
        }
    }

    private void saveTempSubscoreRule(Long taskid, List<Long> subScoreRuleIdList) {
        ArrayList<DynamicObject> breakRecords = new ArrayList<DynamicObject>(10);
        for (Long subScoreRuleId : subScoreRuleIdList) {
            DynamicObject breakRule = BusinessDataServiceHelper.newDynamicObject((String)"task_crebreakrulerecord");
            breakRule.set("histaskid", (Object)taskid);
            breakRule.set("subscorerule", (Object)subScoreRuleId);
            breakRecords.add(breakRule);
        }
        if (breakRecords.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])breakRecords.toArray(new DynamicObject[0]));
        }
    }

    private void deleteTempSubScoreRule(Long taskid) {
        QFilter taskIdFilter = new QFilter("histaskid", "=", (Object)taskid);
        DeleteServiceHelper.delete((String)"task_crebreakrulerecord", (QFilter[])new QFilter[]{taskIdFilter});
    }
}

