/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.business.task.TaskInitWizardHelper;
import kd.ssc.task.formplugin.imports.InitOperationEnum;
import kd.ssc.task.formplugin.imports.TaskImportOperation;
import org.apache.commons.lang3.StringUtils;

public class TaskInitWizardFormPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener {
    public static final String EXPORT_ON_PAGE_OPEN = "invokeExport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getControl("inititemsentry")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getControl("inititemsentry")).addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && "refresh".equals(key)) {
            this.setMoreVisible();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("inititemsentry")) {
            if (evt.getRow() == -1) {
                return;
            }
            DynamicObject f7 = ((EntryGrid)evt.getSource()).getEntryData().getDataEntitys()[evt.getRow()];
            DynamicObject initItem = f7.getDynamicObject("inititem");
            DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue("org");
            if (orgDynObj == null) {
                return;
            }
            String billFormId = initItem.getString("number");
            String billFormName = initItem.getString("name");
            this.getView().getFormShowParameter().setCustomParam("billFormId", (Object)billFormId);
            this.getView().getFormShowParameter().setCustomParam("billFormName", (Object)billFormName);
            String sscId = orgDynObj.getString("id");
            this.getView().getFormShowParameter().setCustomParam("sscId", (Object)sscId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("org".equals(propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null) {
                this.getModel().setValue("org", oldValue);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMoreVisible();
    }

    private void setMoreVisible() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("inititemsentry");
        Map configMap = TaskInitWizardHelper.queryConfig();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("inititemsentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynObj = (DynamicObject)entryEntity.get(i);
            if (dynObj == null || dynObj.getDynamicObject("inititem") == null) {
                entryGrid.hideOperateItems("more", i, Arrays.asList(InitOperationEnum.TASK_IMPORT.getOpKey(), InitOperationEnum.TASK_EXPORT.getOpKey()));
                continue;
            }
            String initItemNum = dynObj.getDynamicObject("inititem").getString("number");
            DynamicObject configDynObj = (DynamicObject)configMap.get(initItemNum);
            if (configDynObj == null) {
                entryGrid.hideOperateItems("more", i, Arrays.asList(InitOperationEnum.TASK_IMPORT.getOpKey(), InitOperationEnum.TASK_EXPORT.getOpKey()));
                continue;
            }
            this.hideOperationItems(entryGrid, i, configDynObj.getString("operation"));
        }
    }

    private void hideOperationItems(EntryGrid grid, int row, String opStr) {
        ArrayList<String> opList = new ArrayList<String>(2);
        for (InitOperationEnum op : InitOperationEnum.values()) {
            if (opStr.contains("," + op.ordinal() + ",")) continue;
            opList.add(op.getOpKey());
        }
        if (opList.isEmpty()) {
            return;
        }
        grid.hideOperateItems("more", row, opList);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String opKey = ((Donothing)source).getOperateKey();
            if (InitOperationEnum.TASK_EXPORT.getOpKey().equals(opKey)) {
                this.checkExportOrImportPermission("4730fc9f000004ae");
                this.showList((String)this.getView().getFormShowParameter().getCustomParam("billFormId"));
            }
        } else if (source instanceof TaskImportOperation) {
            this.checkExportOrImportPermission("4730fc9f000003ae");
        }
    }

    private void checkExportOrImportPermission(String permissionItem) {
        String permissionName;
        DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue("org");
        if (orgDynObj == null) {
            return;
        }
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
        String billFormName = (String)this.getView().getFormShowParameter().getCustomParam("billFormName");
        String sscId = orgDynObj.getString("id");
        String appId = this.getView().getFormShowParameter().getAppId();
        if (kd.bos.util.StringUtils.isBlank((String)appId)) {
            appId = "ssc";
        }
        appId = AppMetadataCache.getAppInfo((String)appId).getId();
        long currUserId = RequestContext.get().getCurrUserId();
        int isPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)Long.parseLong(sscId), (String)"12", (String)appId, (String)billFormId, (String)permissionItem);
        String string = permissionName = StringUtils.equals((CharSequence)permissionItem, (CharSequence)"4730fc9f000003ae") ? ResManager.loadKDString((String)"\u5f15\u5165", (String)"TaskInitWizardFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f15\u51fa", (String)"TaskInitWizardFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        if (isPermission == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskInitWizardFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), billFormName, permissionName));
        }
    }

    private void showList(String f7Number) {
        BaseShowParameter parameter;
        if ("task_taskquantcoefficient".equals(f7Number) || "task_dealopinionsopen".equals(f7Number)) {
            parameter = new BaseShowParameter();
            parameter.setFormId(f7Number);
        } else {
            ListShowParameter listParameter = new ListShowParameter();
            listParameter.setBillFormId(f7Number);
            if ("task_usergroup".equals(f7Number)) {
                listParameter.setMultiSelect(false);
            }
            parameter = listParameter;
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("sscId", this.getView().getFormShowParameter().getCustomParam("sscId"));
        parameter.getCustomParams().put(EXPORT_ON_PAGE_OPEN, "1");
        parameter.getCustomParams().put("billFormId", this.getView().getFormShowParameter().getCustomParam("billFormId"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (!StringUtils.equals((CharSequence)evt.getFieldName(), (CharSequence)"inititem")) {
            return;
        }
        DynamicObject f7 = ((EntryGrid)evt.getSource()).getEntryData().getDataEntitys()[evt.getRowIndex()];
        DynamicObject initItem = f7.getDynamicObject("inititem");
        DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue("org");
        if (orgDynObj == null) {
            return;
        }
        String billFormId = initItem.getString("number");
        String billFormName = initItem.getString("name");
        String sscId = orgDynObj.getString("id");
        if (billFormId.startsWith("ssc") || billFormId.startsWith("task")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            if (kd.bos.util.StringUtils.isBlank((String)appId)) {
                appId = "ssc";
            }
            appId = AppMetadataCache.getAppInfo((String)appId).getId();
            long currUserId = RequestContext.get().getCurrUserId();
            int isPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)Long.parseLong(sscId), (String)"12", (String)appId, (String)billFormId, (String)"47150e89000000ac");
            if (isPermission == 0) {
                String permissionName = ResManager.loadKDString((String)"\u67e5\u770b", (String)"TaskInitWizardFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u9009\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskInitWizardFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), billFormName, permissionName));
            }
        }
    }
}

