/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.ExportExcel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptReductionAccountFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String FIELD_TASKHISTORY = "id,sscid,billtype,billtype.isembed,billtype.isstoredindb,oprt,billid,pooltype,state,subject,tasktypeid,bizdata_tag,qualitystate,apprevalmessage,imagenumber,billnumber,innermsg,sourcetaskid";
    private List<FilterColumn> commonFilters = null;
    private static final String KEY_RPTREDUCTION_FIRSTROAD = "rptReductionFirstRoad";

    public void beforeQuery(ReportQueryParam queryParam) {
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        for (FilterColumn filterColumn : this.commonFilters) {
            QFilter filter;
            FilterItemInfo oItemInfo;
            FilterInfo oFilterInfo;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("tasktype".equalsIgnoreCase(fieldName)) {
                oFilterInfo = queryParam.getFilter();
                oItemInfo = oFilterInfo.getFilterItem("sharecenter.id");
                if (oItemInfo == null) continue;
                String comType = oItemInfo.getCompareType();
                Object sscFilterValue = oItemInfo.getValue();
                QFilter idFilter = new QFilter("orgfield.id", comType, sscFilterValue);
                QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscFilterValue, false);
                continue;
            }
            if (!"org".equalsIgnoreCase(fieldName) || (oItemInfo = (oFilterInfo = queryParam.getFilter()).getFilterItem("sharecenter.id")) == null) continue;
            Object sscFilterValue = oItemInfo.getValue();
            if (sscFilterValue instanceof List) {
                List sscValues = (List)sscFilterValue;
                filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscValues.get(0));
                for (int i = 1; i < sscValues.size(); ++i) {
                    filter.or(CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscValues.get(i)));
                }
            } else {
                filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityOrgFilter", sscFilterValue);
            }
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityOrg", commonFilterColumn, "bos_org", filter, sscFilterValue, false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof ExportExcel) {
            int isPermission;
            Long sscId = Long.parseLong(this.getPageCache().get("rptReductionAccountSSC"));
            Long userId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            if (kd.bos.util.StringUtils.isBlank((String)appId)) {
                appId = "ssc";
            }
            if ((isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)"12", (String)appId, (String)"task_reductionaccount", (String)"4730fc9f000004ae")) != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6838\u51cf\u91d1\u989d\u7edf\u8ba1\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"RptReductionAccountFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        ReportList reportlist = (ReportList)this.getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscid = "-1";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)KEY_RPTREDUCTION_FIRSTROAD)) == null) {
            for (FilterColumn filterColumn : this.commonFilters) {
                QFilter filter;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sharecenter".equalsIgnoreCase(fieldName)) {
                    List sscItems = commonFilterColumn.getComboItems();
                    Long orgId = RequestContext.get().getOrgId();
                    sscid = TaskRptHelper.getDefSscId(sscItems, orgId);
                    commonFilterColumn.setDefaultValue(sscid);
                    commonFilterColumn.setDefValue(sscid);
                    commonFilterColumn.setMustInput(true);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)KEY_RPTREDUCTION_FIRSTROAD), "true");
                    this.getPageCache().put("rptReductionAccountSSC", sscid);
                    continue;
                }
                if ("completetime".equalsIgnoreCase(fieldName)) {
                    filterColumn.setDefaultValue("63");
                    continue;
                }
                if ("billtypename".equalsIgnoreCase(fieldName) && StringUtils.isNotEmpty((String)sscid)) {
                    filter = new QFilter("ssccenter.id", "=", (Object)Long.valueOf(sscid));
                    QFilter filterBillTypeId = RptReductionAccountFormPlugin.getBillType(Arrays.asList("er_dailyloanbill", "er_dailyreimbursebill", "er_tripreimbursebill"));
                    if (filterBillTypeId != null) {
                        filter = filter.and(filterBillTypeId);
                    }
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "rptReductionAccountBillType", commonFilterColumn, "task_taskbill", filter, sscid, false);
                    continue;
                }
                if (!"org".equalsIgnoreCase(fieldName) || !StringUtils.isNotEmpty((String)sscid)) continue;
                filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptReductionAccountOrgFilter", sscid);
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptReductionAccountOrg", commonFilterColumn, "bos_org", filter, sscid, false);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        List<String> nullFieldValues = Arrays.asList("org.id", "billtypename.id");
        Object sscId = CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, "sharecenter.id", nullFieldValues);
        for (FilterColumn filterColumn : this.commonFilters) {
            QFilter filter;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("billtypename".equalsIgnoreCase(fieldName)) {
                if (sscId == null || sscId.equals("")) continue;
                filter = new QFilter("ssccenter.id", "=", (Object)Long.valueOf(sscId + ""));
                QFilter filterBillTypeId = RptReductionAccountFormPlugin.getBillType(Arrays.asList("er_dailyloanbill", "er_dailyreimbursebill", "er_tripreimbursebill"));
                if (filterBillTypeId != null) {
                    filter = filter.and(filterBillTypeId);
                }
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptReductionAccountBillType", commonFilterColumn, "task_taskbill", filter, sscId, false);
                continue;
            }
            if (!"org".equalsIgnoreCase(fieldName) || sscId == null) continue;
            filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptReductionAccountOrgFilter", sscId);
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptReductionAccountOrg", commonFilterColumn, "bos_org", filter, sscId, false);
        }
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if ("sharecenter.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put("rptReductionAccountSSC", sscId.toString());
            List filterItems = this.getQueryParam().getFilter().getFilterItems();
            Iterator iterator = filterItems.iterator();
            while (iterator.hasNext()) {
                FilterItemInfo next = (FilterItemInfo)iterator.next();
                if ("sharecenter.id".equals(next.getPropName()) || "completetime".equals(next.getPropName())) continue;
                iterator.remove();
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String name = args.getFieldName();
        String sscIDStr = this.getPageCache().get("rptReductionAccountSSC");
        if (StringUtils.isNotEmpty((String)sscIDStr) && "org.id".equals(name)) {
            OrgF7ViewShowHelper.beforeFilterContainerF7((BeforeFilterF7SelectEvent)args, (Long)Long.parseLong(sscIDStr));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperlinkclickevent) {
        String fieldName = hyperlinkclickevent.getFieldName();
        DynamicObject selectData = hyperlinkclickevent.getRowData();
        if (selectData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u6570\u636e\u3002", (String)"RptReductionAccountFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("billno".equalsIgnoreCase(fieldName)) {
            String taskid = selectData.getString("taskid");
            if (StringUtils.isEmpty((String)taskid)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5728\u5171\u4eab\u4efb\u52a1\u6c60\u4e2d\u672a\u67e5\u8be2\u5230\u60a8\u9009\u62e9\u7684\u4efb\u52a1\u3002", (String)"RptReductionAccountFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dyTask = this.getTaskHistoryData(Long.valueOf(taskid));
            String operationnumber = dyTask.getString("oprt");
            long billtypeid = dyTask.getLong("billtype");
            long sourcetaskid = dyTask.getLong("sourcetaskid");
            DynamicObject dyTaskBill = this.getTaskBillData(billtypeid);
            if (dyTaskBill == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e1a\u52a1\u5355\u636e\u3002", (String)"RptReductionAccountFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String billType = dyTaskBill.getString("bindbill.number");
            String bindform = dyTaskBill.getString("bindform.number");
            this.openVoucherDialog(dyTask, billType, bindform, operationnumber, "2", sourcetaskid);
        }
    }

    private DynamicObject getTaskHistoryData(Long pkid) {
        QFilter filter = new QFilter("id", "=", (Object)pkid);
        return QueryServiceHelper.queryOne((String)"task_taskhistory", (String)FIELD_TASKHISTORY, (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getTaskBillData(long billid) {
        QFilter filter = new QFilter("id", "=", (Object)billid);
        return QueryServiceHelper.queryOne((String)"task_taskbill", (String)"bindbill.number,bindform.number", (QFilter[])new QFilter[]{filter});
    }

    private void openVoucherDialog(DynamicObject task, String billType, String bindform, String operationnumber, String poolType, long sourcetaskid) {
        String bizdata_tagStr;
        FormShowParameter parameEdit = new FormShowParameter();
        String formId = "task_approve";
        Object bizdata_tag = task.get("bizdata_tag");
        String bizdata = null;
        if (bizdata_tag != null && !StringUtils.isEmpty((String)(bizdata_tagStr = bizdata_tag.toString()))) {
            bizdata = bizdata_tagStr;
        }
        parameEdit.setFormId(formId);
        parameEdit.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameEdit.getOpenStyle().setTargetKey("_submaintab_");
        parameEdit.setStatus(OperationStatus.VIEW);
        parameEdit.setCustomParam("taskid", (Object)task.getLong("id"));
        parameEdit.setCustomParam("tasktypeid", (Object)((Long)task.get("tasktypeid")));
        parameEdit.setCustomParam("billtypeid", (Object)task.getLong("billtype"));
        parameEdit.setCustomParam("billid", (Object)task.getString("billid"));
        parameEdit.setCustomParam("bizdata", (Object)bizdata);
        parameEdit.setCustomParam("apprevalmessage", (Object)task.getString("apprevalmessage"));
        parameEdit.setCustomParam("innermsg", (Object)task.getString("innermsg"));
        parameEdit.setCustomParam("state", (Object)task.getString("state"));
        parameEdit.setCustomParam("billnumber", (Object)billType);
        parameEdit.setCustomParam("bindform", (Object)bindform);
        parameEdit.setCustomParam("operationnumber", (Object)operationnumber);
        parameEdit.setCustomParam("pooltype-mytask", (Object)poolType);
        parameEdit.setCustomParam("pooltype", (Object)poolType);
        parameEdit.setCustomParam("sourcetaskid", (Object)sourcetaskid);
        parameEdit.setCustomParam("isembed", (Object)task.getBoolean("billtype.isembed"));
        parameEdit.setCustomParam("imageNumber", (Object)task.getString("imagenumber"));
        parameEdit.setCustomParam("sscid", (Object)task.getString("sscid"));
        parameEdit.setCustomParam("sourcebillnumber", (Object)task.getString("billnumber"));
        this.getView().showForm(parameEdit);
    }

    public static QFilter getBillType(List<String> formNumbers) {
        HashSet<String> formIds = new HashSet<String>(16);
        QFilter filterNumber = new QFilter("number", "in", formNumbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"RptReductionAccountFormPlugin.getVourcherIds", (String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{filterNumber}, null);){
            Iterator rows = ds.iterator();
            Row data = null;
            String id = null;
            while (rows != null && rows.hasNext()) {
                data = (Row)rows.next();
                id = data.getString("id");
                formIds.add(id);
            }
        }
        if (formIds == null || formIds.size() == 0) {
            return null;
        }
        HashSet<Long> billTypeIds = new HashSet<Long>(16);
        QFilter filterForm = new QFilter("bindbill", "in", formIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"RptReductionAccountFormPlugin.getBillTypeIds", (String)"task_taskbill", (String)"id,bindbill", (QFilter[])new QFilter[]{filterForm}, null);){
            Iterator rows = ds.iterator();
            Row data = null;
            String id = null;
            while (rows != null && rows.hasNext()) {
                data = (Row)rows.next();
                id = data.getString("id");
                if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)id)) continue;
                billTypeIds.add(Long.valueOf(id));
            }
        }
        if (billTypeIds == null || billTypeIds.size() == 0) {
            return null;
        }
        return new QFilter("id", "in", billTypeIds);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_reductionaccount", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptReductionAccountFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

