/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;

public class RptTaskUnpassReasonPlugin
extends AbstractReportListDataPlugin {
    private Boolean istasktypedim = Boolean.FALSE;
    private Boolean isorgdim = Boolean.FALSE;
    private Boolean ishandlepersondim = Boolean.FALSE;
    private Boolean isbilltypedim = Boolean.FALSE;

    private String init(ReportQueryParam param) {
        FilterItemInfo filterItem = param.getFilter().getFilterItem("dimension");
        List value = (List)filterItem.getValue();
        FilterInfo filterinfo = param.getFilter();
        String taskbillId = filterinfo.getString("taskbill.id");
        int valuesize = value.size();
        if (value.contains("all")) {
            value.add("tasktypedim");
            value.add("orgdim");
            value.add("handlepersondim");
            value.add("billtypedim");
        }
        this.istasktypedim = value.contains("tasktypedim");
        this.isorgdim = value.contains("orgdim");
        this.ishandlepersondim = value.contains("handlepersondim");
        this.isbilltypedim = value.contains("billtypedim");
        return this.setBindBillNumber(taskbillId, valuesize);
    }

    private String setBindBillNumber(String taskbillId, int size) {
        String cacheBindbillNumber = "";
        if (size == 1) {
            SscDistributeCache.put((String)"cacheBindbillNumber", (Object)cacheBindbillNumber);
            return cacheBindbillNumber;
        }
        if (taskbillId != null && !taskbillId.startsWith("[")) {
            String entityName = "task_taskbill";
            String selectFields = "bindbill.number";
            QFilter filter = new QFilter("id", "=", (Object)taskbillId);
            DynamicObject queryResult = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter});
            String bindbillNumber = (String)queryResult.get("bindbill.number");
            if (bindbillNumber.equals("er_tripreimbursebill")) {
                cacheBindbillNumber = "er_tripreimbursebill";
            } else if (bindbillNumber.equals("er_dailyreimbursebill")) {
                cacheBindbillNumber = "er_dailyreimbursebill";
            }
        }
        SscDistributeCache.put((String)"cacheBindbillNumber", (Object)cacheBindbillNumber);
        return cacheBindbillNumber;
    }

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        String[] groupByTaskNoBill;
        ArrayList<String> groupByTaskList;
        String bindbillNumber = this.init(param);
        DataSet unpassReasonSet = null;
        DataSet taskUnpassSet = null;
        DataSet taskUnpassCopySet = null;
        DataSet taskTotalSet = null;
        JoinDataSet joinDataSet = null;
        DataSet unionSet = null;
        unpassReasonSet = this.getUnpassReasonSet(param, object);
        taskUnpassSet = this.getTaskUnpassSet(param, object);
        taskTotalSet = this.getTaskTotalSet(param, object);
        taskUnpassCopySet = taskUnpassSet.copy();
        String[] groupByTask = this.getGroupBy(param, "taskUnpassFlag");
        String[] groupByReason = this.getGroupBy(param, "reasonOnlyFlag");
        String[] groupByUnpassReason = this.getGroupBy(param, "unpassReasonFlag");
        ArrayList<String> groupList = new ArrayList<String>(Arrays.asList(groupByUnpassReason));
        if (bindbillNumber.equals("er_tripreimbursebill")) {
            groupList.add(groupList.size() - 2, "triptypename");
            groupList.remove("billid");
            DataSet tripreimbursebillSet = this.getTripreimbursebillSet();
            groupByTaskList = new ArrayList<String>(Arrays.asList(groupByTask));
            groupByTaskList.add("triptypename");
            groupByTaskNoBill = groupByTask;
            groupByTask = groupByTaskList.toArray(new String[groupByTaskList.size()]);
            taskUnpassSet = taskUnpassSet.join(tripreimbursebillSet, JoinType.INNER).on("billid", "tripreimbursebillid").select(groupByTask).finish();
            taskTotalSet = taskTotalSet.join(tripreimbursebillSet, JoinType.INNER).on("billid", "tripreimbursebillid").select(groupByTask).finish();
            unpassReasonSet = taskUnpassCopySet.join(unpassReasonSet, JoinType.INNER).on("sourcetaskid", "taskid").select(groupByTaskNoBill, groupByReason).finish().join(tripreimbursebillSet, JoinType.INNER).on("billid", "tripreimbursebillid").select(groupList.toArray(new String[groupList.size()])).finish().groupBy(groupList.toArray(new String[groupList.size()])).count("unpasscount").finish();
        } else if (bindbillNumber.equals("er_dailyreimbursebill")) {
            groupList.add(groupList.size() - 2, "expenseitemname");
            groupList.remove("billid");
            DataSet dailyreimbursebillSet = this.getDailyreimbursebillSet();
            groupByTaskList = new ArrayList<String>(Arrays.asList(groupByTask));
            groupByTaskList.add("expenseitemname");
            groupByTaskNoBill = groupByTask;
            groupByTask = groupByTaskList.toArray(new String[groupByTaskList.size()]);
            taskUnpassSet = taskUnpassSet.join(dailyreimbursebillSet, JoinType.INNER).on("billid", "dailyreimbursebillid").select(groupByTask).finish();
            taskTotalSet = taskTotalSet.join(dailyreimbursebillSet, JoinType.INNER).on("billid", "dailyreimbursebillid").select(groupByTask).finish();
            unpassReasonSet = taskUnpassCopySet.join(unpassReasonSet, JoinType.INNER).on("sourcetaskid", "taskid").select(groupByTaskNoBill, groupByReason).finish().join(dailyreimbursebillSet, JoinType.INNER).on("billid", "dailyreimbursebillid").select(groupList.toArray(new String[groupList.size()])).finish().groupBy(groupList.toArray(new String[groupList.size()])).count("unpasscount").finish();
        } else {
            unpassReasonSet = taskUnpassCopySet.join(unpassReasonSet, JoinType.INNER).on("sourcetaskid", "taskid").select(groupByTask, groupByReason).finish().groupBy(groupByUnpassReason).count("unpasscount").finish();
        }
        String[] groupByTaskNoBill2 = Arrays.copyOfRange(groupByTask, 1, groupByTask.length);
        taskUnpassSet = taskUnpassSet.groupBy(groupByTaskNoBill2).count("taskunpasscount").finish();
        taskTotalSet = taskTotalSet.groupBy(groupByTaskNoBill2).count("tasktotalcount").finish();
        joinDataSet = unpassReasonSet.join(taskUnpassSet, JoinType.INNER);
        if (this.istasktypedim.booleanValue()) {
            joinDataSet.on("tasktypeid", "tasktypeid");
        }
        if (this.isbilltypedim.booleanValue()) {
            joinDataSet.on("billtypeid", "billtypeid");
        }
        if (this.isorgdim.booleanValue()) {
            joinDataSet.on("orgid", "orgid");
        }
        if (this.ishandlepersondim.booleanValue()) {
            joinDataSet.on("personid", "personid");
        }
        if (bindbillNumber.equals("er_tripreimbursebill")) {
            joinDataSet.on("triptypename", "triptypename");
        } else if (bindbillNumber.equals("er_dailyreimbursebill")) {
            joinDataSet.on("expenseitemname", "expenseitemname");
        }
        groupList.add("unpasscount");
        unionSet = joinDataSet.select(groupList.toArray(new String[groupList.size()]), new String[]{"taskunpasscount"}).finish();
        joinDataSet = unionSet.join(taskTotalSet, JoinType.INNER);
        if (this.istasktypedim.booleanValue()) {
            joinDataSet.on("tasktypeid", "tasktypeid");
        }
        if (this.isbilltypedim.booleanValue()) {
            joinDataSet.on("billtypeid", "billtypeid");
        }
        if (this.isorgdim.booleanValue()) {
            joinDataSet.on("orgid", "orgid");
        }
        if (this.ishandlepersondim.booleanValue()) {
            joinDataSet.on("personid", "personid");
        }
        if (bindbillNumber.equals("er_tripreimbursebill")) {
            joinDataSet.on("triptypename", "triptypename");
        } else if (bindbillNumber.equals("er_dailyreimbursebill")) {
            joinDataSet.on("expenseitemname", "expenseitemname");
        }
        groupList.add("taskunpasscount");
        unionSet = joinDataSet.select(groupList.toArray(new String[groupList.size()]), new String[]{"tasktotalcount"}).finish();
        ArrayList<String> orderByList = new ArrayList<String>();
        if (this.istasktypedim.booleanValue()) {
            orderByList.add("tasktypename");
        }
        if (this.isbilltypedim.booleanValue()) {
            orderByList.add("billtypename");
        }
        if (this.isorgdim.booleanValue()) {
            orderByList.add("orgname");
        }
        if (this.ishandlepersondim.booleanValue()) {
            orderByList.add("personname");
        }
        if (bindbillNumber.equals("er_tripreimbursebill")) {
            orderByList.add("triptypename");
        } else if (bindbillNumber.equals("er_dailyreimbursebill")) {
            orderByList.add("expenseitemname");
        }
        String[] orderBy = orderByList.toArray(new String[orderByList.size()]);
        return unionSet.orderBy(orderBy);
    }

    private DataSet getDailyreimbursebillSet() {
        String fields = "TO_CHAR(id) as dailyreimbursebillid,expenseentryentity.expenseitem.name as expenseitemname";
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("er_dailyreimbursebill", "er_dailyreimbursebill", fields, null);
        return ds;
    }

    private DataSet getTripreimbursebillSet() {
        String fields = "TO_CHAR(id) as tripreimbursebillid,triptype.name as triptypename";
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("er_tripreimbursebill", "er_tripreimbursebill", fields, null);
        return ds;
    }

    private DataSet getTaskTotalSet(ReportQueryParam param, Object object) {
        String fields = this.getFields(param, "taskTotalFlag");
        QFilter[] filters = this.getFilters(param, "taskTotalFlag");
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("t_tk_taskhistory1", "task_taskhistory", fields, filters);
        return ds;
    }

    private DataSet getTaskUnpassSet(ReportQueryParam param, Object object) {
        ORM orm = ORM.create();
        String fields = this.getFields(param, "taskUnpassFlag");
        QFilter[] filters = this.getFilters(param, "taskUnpassFlag");
        DataSet ds = orm.queryDataSet("t_tk_taskhistory", "task_taskhistory", fields, filters);
        return ds;
    }

    private DataSet getUnpassReasonSet(ReportQueryParam param, Object object) {
        ORM orm = ORM.create();
        String unpassFields = this.getFields(param, "unpassFlag");
        QFilter[] filters = this.getWithdrawalFilters(param);
        DataSet unpassSet = orm.queryDataSet("t_tk_withdrawal_unpass", "task_withdrawal_unpass", unpassFields, filters);
        return unpassSet;
    }

    private String getFields(ReportQueryParam param, String flag) {
        ArrayList<String> fieldList = new ArrayList<String>();
        if ("taskTotalFlag".equals(flag) || "taskUnpassFlag".equals(flag)) {
            fieldList.add("sourcetaskid");
            fieldList.add("billid");
            if (this.istasktypedim.booleanValue()) {
                fieldList.add("tasktypeid.name as tasktypename");
                fieldList.add("tasktypeid.id as tasktypeid");
            }
            if (this.isbilltypedim.booleanValue()) {
                fieldList.add("billtype.name as billtypename");
                fieldList.add("billtype.id as billtypeid");
            }
            if (this.isorgdim.booleanValue()) {
                fieldList.add("orgid.name as orgname");
                fieldList.add("orgid.id as orgid");
            }
            if (this.ishandlepersondim.booleanValue()) {
                fieldList.add("personid.name as personname");
                fieldList.add("personid.number as personnumber");
                fieldList.add("personid.id as personid");
                fieldList.add("personid.picturefield as personpic");
            }
        } else if ("unpassFlag".equals(flag)) {
            fieldList.add("taskid");
            fieldList.add("withdrawal.id as withdrawalid");
            fieldList.add("withdrawal.name as description");
        }
        String fieldListStr = ((Object)fieldList).toString();
        return fieldListStr.substring(1, fieldListStr.length() - 1);
    }

    private String[] getGroupBy(ReportQueryParam param, String flag) {
        ArrayList<String> groupList = new ArrayList<String>(10);
        if ("reasonOnlyFlag".equals(flag)) {
            groupList.add("description");
            groupList.add("withdrawalid");
        } else if ("unpassReasonFlag".equals(flag)) {
            if (this.istasktypedim.booleanValue()) {
                groupList.add("tasktypename");
                groupList.add("tasktypeid");
            }
            if (this.isbilltypedim.booleanValue()) {
                groupList.add("billtypename");
                groupList.add("billtypeid");
            }
            if (this.isorgdim.booleanValue()) {
                groupList.add("orgname");
                groupList.add("orgid");
            }
            if (this.ishandlepersondim.booleanValue()) {
                groupList.add("personname");
                groupList.add("personid");
                groupList.add("personnumber");
                groupList.add("personpic");
            }
            groupList.add("description");
            groupList.add("withdrawalid");
        } else {
            groupList.add("billid");
            if (this.istasktypedim.booleanValue()) {
                groupList.add("tasktypename");
                groupList.add("tasktypeid");
            }
            if (this.isbilltypedim.booleanValue()) {
                groupList.add("billtypename");
                groupList.add("billtypeid");
            }
            if (this.isorgdim.booleanValue()) {
                groupList.add("orgname");
                groupList.add("orgid");
            }
            if (this.ishandlepersondim.booleanValue()) {
                groupList.add("personname");
                groupList.add("personnumber");
                groupList.add("personid");
                groupList.add("personpic");
            }
        }
        return groupList.toArray(new String[groupList.size()]);
    }

    private QFilter[] getFilters(ReportQueryParam param, String flag) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = null;
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        if ("taskTotalFlag".equals(flag) || "taskUnpassFlag".equals(flag)) {
            qfList.add(notQuaCheckTask);
            qfList.add(notAutoProcess);
            for (FilterItemInfo itemInfo : filterItems) {
                String propName = itemInfo.getPropName();
                if ("completetime".equals(propName)) {
                    qFilter = new QFilter("completetime", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("sharecenter.id".equals(propName)) {
                    qFilter = new QFilter("sscid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("tasktype.id".equals(propName)) {
                    qFilter = new QFilter("tasktypeid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("taskbill.id".equals(propName)) {
                    qFilter = new QFilter("billtype.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("handleperson".equals(propName)) {
                    qFilter = new QFilter("personid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("org".equals(propName)) {
                    qFilter = new QFilter("orgid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if (!"billtypename".equals(propName)) continue;
                qFilter = new QFilter("billtype.id", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
            }
            ArrayList<String> stateList = new ArrayList<String>();
            stateList.add(TaskStateEnum.AUDIT_NOTPASSED.getValue());
            if ("taskTotalFlag".equals(flag)) {
                stateList.add(TaskStateEnum.AUDIT_PASSED.getValue());
            }
            qFilter = new QFilter("state", "in", stateList);
            qfList.add(qFilter);
        } else if ("unpassReasonFlag".equals(flag)) {
            FilterItemInfo filterItem = filter.getFilterItem("unpassreasonfilter");
            qFilter = new QFilter("description", filterItem.getCompareType(), filterItem.getValue());
            qfList.add(qFilter);
        }
        return qfList.toArray(new QFilter[qfList.size()]);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columnList = super.getColumns(columns);
        TaskRptHelper.createDimensionColumns(columnList, this.getQueryParam(), columns);
        return columnList;
    }

    private QFilter[] getWithdrawalFilters(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = null;
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if (!"unpassreasonfilter.name".equals(propName)) continue;
            qFilter = new QFilter("withdrawal.name", itemInfo.getCompareType(), itemInfo.getValue());
            qfList.add(qFilter);
        }
        return qfList.toArray(new QFilter[qfList.size()]);
    }
}

