/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartqualitycheck;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieSeries;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.common.smartscheme.AlgorithmDetailEnum;
import kd.ssc.task.common.smartscheme.SmartQualityCheckPredict;

public class SmartSchemeAlgorithmRpt
extends AbstractReportFormPlugin {
    private static final String[] colors = new String[]{"#FFA940", "#F57582", "#45DAD1", "#40A9FF", "#73D13D", "#FFC53D", "#9F69E2", "#6682F5"};
    private static final String systemType = "ssc-task-formplugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"piechartap"});
    }

    public void afterCreateNewData(EventObject e) {
        QFilter statusQf;
        DynamicObjectCollection query;
        Chart pieChart = (Chart)this.getControl("piechartap");
        String correlationResult = SmartQualityCheckPredict.correlationUrl();
        if (correlationResult != null) {
            List resultMap;
            String predictResult;
            JSONObject resultJson = JSONObject.parseObject((String)correlationResult);
            ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(10);
            if (resultJson.get((Object)"err").equals("ok") && StringUtils.isNotBlank((CharSequence)(predictResult = resultJson.getString("result"))) && (resultMap = (List)SerializationUtils.fromJsonString((String)resultJson.getString("result"), List.class)).size() > 0) {
                resultMap.remove(resultMap.size() - 1);
                Collections.sort(resultMap, new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        BigDecimal importance1 = new BigDecimal(o1.get("importance") + "");
                        BigDecimal importance2 = new BigDecimal(o2.get("importance") + "");
                        return importance2.compareTo(importance1);
                    }
                });
                int index = 0;
                for (Map item : resultMap) {
                    BigDecimal value = new BigDecimal(item.get("importance") + "");
                    if (value.compareTo(new BigDecimal(0)) < 0) {
                        value = new BigDecimal(0);
                    }
                    if (index >= colors.length - 1) continue;
                    itemValues.add(new ItemValue(AlgorithmDetailEnum.getName(item.get("feature") + "") + "", (Number)value, colors[index]));
                    ++index;
                }
                if (index < resultMap.size()) {
                    StringBuilder otherName = new StringBuilder();
                    BigDecimal otherValue = new BigDecimal("0");
                    while (index < resultMap.size()) {
                        otherName.append(((Map)resultMap.get(index)).get("feature_name")).append('\uff1a').append(((Map)resultMap.get(index)).get("importance"));
                        otherValue = otherValue.add(new BigDecimal(((Map)resultMap.get(index)).get("importance") + ""));
                        ++index;
                    }
                    if (otherValue.compareTo(new BigDecimal(0)) < 0) {
                        otherValue = new BigDecimal(0);
                    }
                    itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SmartSchemeAlgorithmRpt_1", (String)systemType, (Object[])new Object[0]), (Number)otherValue, colors[colors.length - 1]));
                }
            }
            this.setPieChat(pieChart, itemValues.toArray(new ItemValue[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"task_modelinitrecord", (String)"*", (QFilter[])new QFilter[]{statusQf = new QFilter("status", "=", (Object)"0")}, (String)"version desc", (int)1)))) {
            DynamicObject info = (DynamicObject)query.get(0);
            this.getModel().setValue("trainnum", info.get("trainData"));
            this.getModel().setValue("updatenum", info.get("version"));
            this.getModel().setValue("lastupdatedate", info.get("lastTrainTime"));
        }
    }

    private void setPieChat(Chart pieChart, ItemValue[] data) {
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u8d28\u68c0\u7b97\u6cd5\u81ea\u8bad\u7ec3\u660e\u7ec6", (String)"SmartSchemeAlgorithmRpt_2", (String)systemType, (Object[])new Object[0]));
        series.setData(data);
        Label label = new Label();
        label.setShow(false);
        series.setLabel(label);
        series.setCenter("25%", "50%");
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("left", (Object)"56%");
        pieChart.setLegendPropValue("top", (Object)"15%");
        pieChart.refresh();
    }
}

