/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.voucher;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TaskbillVoucherPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(TaskbillVoucherPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billcondition", "taskhandleshowtext"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel parentModel = view.getParentView().getModel();
        Boolean isNeedVoucher = (Boolean)parentModel.getValue("isneedvoucher");
        if (!isNeedVoucher.booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"advconap"});
            view.setVisible(Boolean.FALSE, new String[]{"isvoucherhandler"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"advconap"});
            view.setVisible(Boolean.TRUE, new String[]{"isvoucherhandler"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        String newValue = null;
        int rowIndex = changeData.getRowIndex();
        if ("voucheroperation".equals(propName)) {
            newValue = (String)changeData.getNewValue();
            if ("1".equals(newValue)) {
                model.setValue("voucherstatctrl", (Object)"1", rowIndex);
                model.setValue("taskhandleshow", (Object)"", rowIndex);
                model.setValue("taskhandleshowtext", (Object)"", rowIndex);
            } else {
                model.setValue("taskhandleshow", (Object)"1,2,3,4,", rowIndex);
                model.setValue("taskhandleshowtext", (Object)ResManager.loadKDString((String)"\u9884\u89c8\u51ed\u8bc1,\u67e5\u770b\u51ed\u8bc1,\u751f\u6210\u51ed\u8bc1,\u5220\u9664\u51ed\u8bc1", (String)"TaskbillVoucherPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), rowIndex);
            }
        } else if ("taskhandleshowtext".equals(propName)) {
            newValue = (String)changeData.getNewValue();
            if (kd.bos.util.StringUtils.isEmpty((String)newValue)) {
                model.setValue("taskhandleshow", (Object)"", rowIndex);
            }
        } else if ("billcondition".equals(propName) && kd.bos.util.StringUtils.isEmpty((String)(newValue = (String)changeData.getNewValue()))) {
            model.setValue("billconditionjson_tag", (Object)"", rowIndex);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "billcondition": {
                IDataModel parentModel = view.getParentView().getModel();
                DynamicObject bindbill = (DynamicObject)parentModel.getValue("bindbill");
                if (bindbill == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6765\u6e90\u5355\u636e\u3002", (String)"TaskbillVoucherPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showVoucherCtrlRule(bindbill.getString("number"));
                break;
            }
            case "taskhandleshowtext": {
                int rowIndex = model.getEntryCurrentRowIndex("entryentityvoucher");
                String voucheroperation = (String)model.getValue("voucheroperation", rowIndex);
                String chooseoperations = (String)model.getValue("taskhandleshow", rowIndex);
                this.showTaskHandleShow(voucheroperation, chooseoperations);
                break;
            }
        }
    }

    private void showVoucherCtrlRule(String entityNumber) {
        if (kd.bos.util.StringUtils.isEmpty((String)entityNumber)) {
            log.error("\u5f02\u5e38\uff1ashowVoucherCtrlRule()\u63a5\u6536\u7684entityNumber\u4e3a" + entityNumber);
            return;
        }
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_voucherruleconfig");
        showParam.setCustomParam("taskBill", (Object)entityNumber);
        showParam.setCustomParam("billconditionjson", this.getModel().getValue("billconditionjson_tag"));
        showParam.setHasRight(true);
        showParam.setShowTitle(true);
        showParam.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u914d\u7f6e", (String)"TaskbillVoucherPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        showParam.getOpenStyle().setShowType(ShowType.NonModal);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "voucherruleconfig"));
        this.getView().showForm(showParam);
    }

    private void showTaskHandleShow(String voucheroperation, String chooseoperations) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_taskhandleshow");
        showParam.setCustomParam("voucheroperation", (Object)voucheroperation);
        showParam.setCustomParam("chooseoperations", (Object)chooseoperations);
        showParam.setHasRight(true);
        showParam.setShowTitle(true);
        showParam.getOpenStyle().setShowType(ShowType.NonModal);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "taskhandleshow"));
        this.getView().showForm(showParam);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        IDataModel model = this.getModel();
        Map ret = (Map)e.getReturnData();
        if (e.getActionId() != null) {
            switch (e.getActionId()) {
                case "voucherruleconfig": {
                    int rowIndex = model.getEntryCurrentRowIndex("entryentityvoucher");
                    String filter = (String)ret.get("filter");
                    String voucherCtrlRuleJson = (String)ret.get("filterCondition");
                    String andLogic = "";
                    String operateLogic = "";
                    StringBuilder sbFilter = new StringBuilder();
                    if (StringUtils.isNotEmpty((String)filter) && StringUtils.isNotEmpty((String)voucherCtrlRuleJson)) {
                        sbFilter.append('(').append(filter).append(')');
                        FilterCondition fc2 = (FilterCondition)SerializationUtils.fromJsonString((String)voucherCtrlRuleJson, FilterCondition.class);
                        List filterRows = fc2.getFilterRow();
                        andLogic = ((SimpleFilterRow)filterRows.get(filterRows.size() - 1)).getLogic();
                        operateLogic = "0".equals(andLogic) ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"TaskbillVoucherPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"TaskbillVoucherPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                        sbFilter.append(operateLogic);
                    }
                    model.setValue("billcondition", (Object)sbFilter.toString(), rowIndex);
                    model.setValue("billconditionjson_tag", ret.get("filterCondition"), rowIndex);
                    break;
                }
                case "taskhandleshow": {
                    int currRowIndex = model.getEntryCurrentRowIndex("entryentityvoucher");
                    String textvalue = (String)ret.get("textvalue");
                    String code = (String)ret.get("code");
                    model.setValue("taskhandleshow", (Object)code, currRowIndex);
                    model.setValue("taskhandleshowtext", (Object)textvalue, currRowIndex);
                    break;
                }
            }
        }
    }
}

