/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkBillClassifyFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PARENT = "parent";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String CLASSIFY_ENTITY_NAME = "ssc_billmangerclassify";
    private static final String BILL_MANAGER_ENTITY_NAME = "ssc_billmanger";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject evt) {
        BasedataEdit parent = (BasedataEdit)this.getControl(PARENT);
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String fieldName = edit.getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)PARENT)) {
            this.addWorkBillClassifyFilter(e);
        }
    }

    private void addWorkBillClassifyFilter(BeforeF7SelectEvent e) {
        ArrayList<Long> variableIds = new ArrayList<Long>(16);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter statusFilter = new QFilter(STATUS, "=", (Object)"C");
        DynamicObjectCollection workBillClassifies = QueryServiceHelper.query((String)CLASSIFY_ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        if (!CollectionUtils.isEmpty((Collection)workBillClassifies)) {
            for (DynamicObject classify : workBillClassifies) {
                Long id = classify.getLong("id");
                QFilter groupFilter = new QFilter("group", "=", (Object)id);
                boolean beenRef = QueryServiceHelper.exists((String)BILL_MANAGER_ENTITY_NAME, (QFilter[])new QFilter[]{groupFilter});
                if (beenRef) continue;
                variableIds.add(id);
            }
            Long selfId = (Long)this.getModel().getValue("id");
            variableIds.removeIf(i -> i.equals(selfId));
            QFilter treeAddFilter = new QFilter("id", "in", variableIds);
            List treeFilters = ((ListShowParameter)e.getFormShowParameter()).getTreeFilterParameter().getQFilters();
            treeFilters.add(treeAddFilter);
            QFilter addFilter = new QFilter("id", "in", variableIds);
            List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(addFilter);
        }
    }
}

