/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.monitor.ExceptionHandlingResultEnum;
import kd.ssc.monitor.ExceptionStatusEnum;

public class ScenarioDefTreeListPlugin
extends StandardTreeListPlugin {
    private static final String OP_NEW = "new";
    private static final String OP_AUTHORIZE = "mon_authorize";
    private static final String OP_EDIT_SOLUTION = "edit_solution";
    private static final Log log = LogFactory.getLog(ScenarioDefTreeListPlugin.class);

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        switch (operateKey) {
            case "new": {
                if (!this.isRoot()) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5728\u6839\u8282\u70b9\u65b0\u589e\u573a\u666f\u5b9a\u4e49\u3002", (String)"ScenarioDefListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mon_authorize": {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                if (listSelectedData.size() > 1) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ScenarioDefListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                String useOrg = this.getPageCache().get("createOrg");
                if (useOrg == null) {
                    args.setCancel(true);
                    return;
                }
                Long scenarioDefPK = (Long)listSelectedData.get(0).getPrimaryKeyValue();
                QFilter[] qFilters = new QFilter[]{new QFilter("ssc", "=", (Object)Long.valueOf(useOrg)), new QFilter("scenariodef", "=", (Object)scenarioDefPK)};
                DynamicObject authorize = QueryServiceHelper.queryOne((String)"ssc_mon_authorize", (String)"id", (QFilter[])qFilters);
                BillShowParameter sp = new BillShowParameter();
                sp.setFormId("ssc_mon_authorize");
                sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                sp.setCustomParam("ssc", (Object)Long.parseLong(useOrg));
                sp.setCustomParam("scenariodef", (Object)scenarioDefPK);
                if (authorize == null) {
                    log.info(String.format("\u4e3a\u5f53\u524d\u7ec4\u7ec7id-%s\u7684\u573a\u666fid-%s\u672a\u914d\u7f6e\u89c4\u5219\u6388\u6743\uff0c\u8fdb\u5165\u65b0\u589e\u3002", useOrg, scenarioDefPK));
                    sp.setStatus(OperationStatus.ADDNEW);
                } else {
                    log.info(String.format("\u4e3a\u5f53\u524d\u7ec4\u7ec7id-%s\u7684\u573a\u666fid-%s\u8fdb\u884c\u89c4\u5219\u6388\u6743id-%s\uff0c\u8fdb\u5165\u7f16\u8f91\u3002", useOrg, scenarioDefPK, authorize.get("id")));
                    sp.setPkId(authorize.get("id"));
                    sp.setStatus(OperationStatus.EDIT);
                }
                this.getView().showForm((FormShowParameter)sp);
                break;
            }
            case "edit_solution": {
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ScenarioDefTreeListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.showFormToExceptionSolution(selectedRows);
                break;
            }
        }
    }

    private boolean isRoot() {
        return this.getTreeModel().getRoot().getId().equals(this.getTreeModel().getCurrentNodeId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        switch (operateKey) {
            case "disable": {
                List successPkIds = args.getOperationResult().getSuccessPkIds();
                if (CollectionUtils.isEmpty((Collection)successPkIds)) {
                    return;
                }
                QFilter pkIdFilter = new QFilter("scenario", "in", (Object)successPkIds);
                QFilter statusFilter = new QFilter("status", "=", (Object)ExceptionStatusEnum.UN_PROCESSED.getValue());
                DynamicObject[] exceptionDos = BusinessDataServiceHelper.load((String)"ssc_exception", (String)"id,status,handle_entry.handling_time,handle_entry.handling_result,handle_entry.handler", (QFilter[])new QFilter[]{pkIdFilter, statusFilter});
                if (exceptionDos == null || exceptionDos.length == 0) {
                    return;
                }
                Long userId = UserServiceHelper.getCurrentUserId();
                for (DynamicObject exceptionDo : exceptionDos) {
                    exceptionDo.set("status", (Object)ExceptionStatusEnum.DISABLED.getValue());
                    DynamicObjectCollection clos = exceptionDo.getDynamicObjectCollection("handle_entry");
                    DynamicObject newRow = clos.addNew();
                    newRow.set("handling_time", (Object)new Date());
                    newRow.set("handling_result", (Object)ExceptionHandlingResultEnum.DISABLED.getValue());
                    newRow.set("handler", (Object)userId);
                }
                SaveServiceHelper.save((DynamicObject[])exceptionDos);
                break;
            }
        }
    }

    public void treeToolbarClick(EventObject e) {
        Control ctl = (Control)e.getSource();
        String key = ctl.getKey();
        if (key.equals("btndel")) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                super.treeToolbarClick(e);
                return;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(currentNodeId + "")), new QFilter("preset", "=", (Object)"1")};
            QFilter groupFilter = new QFilter("group", "=", (Object)Long.parseLong(currentNodeId + ""));
            if (QueryServiceHelper.exists((String)"ssc_scenario_type", (QFilter[])qFilters)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u573a\u666f\u7c7b\u578b\u4e0d\u53ef\u5220\u9664\u3002", (String)"ScenarioDefListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else if (QueryServiceHelper.exists((String)"ssc_scenario_def", (QFilter[])groupFilter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u573a\u666f\u7c7b\u578b\u4e0b\u5df2\u6709\u573a\u666f\u4e0d\u53ef\u5220\u9664\u3002", (String)"ScenarioDefListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                super.treeToolbarClick(e);
            }
        } else {
            super.treeToolbarClick(e);
        }
    }

    private void showFormToExceptionSolution(ListSelectedRowCollection selectedRows) {
        Long defId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        String customFilterSer = this.getPageCache().get("customfilter");
        List customFilterList = (List)SerializationUtils.fromJsonString((String)customFilterSer, ArrayList.class);
        Long sscId = Long.valueOf(this.getPageCache().get("createOrg"));
        BillShowParameter billShowParameter = new BillShowParameter();
        QFilter filter1 = new QFilter("id", "=", (Object)defId);
        QFilter[] qFilters = new QFilter[]{filter1};
        DynamicObject scenarioDefDo = QueryServiceHelper.queryOne((String)"ssc_scenario_def", (String)"id,createorg,preset,solution", (QFilter[])qFilters);
        Long createOrg = scenarioDefDo.getLong("createorg");
        boolean isPreset = scenarioDefDo.getBoolean("preset");
        Long solutionId = scenarioDefDo.getLong("solution");
        if (isPreset) {
            billShowParameter.setPkId((Object)solutionId);
            billShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            boolean success = this.initNotPreSet(sscId, billShowParameter, createOrg, solutionId);
            if (!success) {
                return;
            }
        }
        billShowParameter.setFormId("ssc_solution");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCustomParam("defId", (Object)defId.toString());
        if (createOrg != 0L) {
            billShowParameter.setCustomParam("createOrg", (Object)createOrg.toString());
        }
        billShowParameter.setCustomParam("isPreset", (Object)isPreset);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private boolean initNotPreSet(Long sscId, BillShowParameter billShowParameter, Long createOrg, Long solutionId) {
        if (solutionId != null && solutionId != 0L) {
            billShowParameter.setPkId((Object)solutionId);
            if (sscId.equals(createOrg)) {
                billShowParameter.setStatus(OperationStatus.EDIT);
            } else {
                billShowParameter.setStatus(OperationStatus.VIEW);
            }
        } else if (sscId.equals(createOrg)) {
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u573a\u666f\u65e0\u89e3\u51b3\u65b9\u6848\uff0c\u5982\u9700\u7ef4\u62a4\uff0c\u9700\u5207\u6362\u81f3\u521b\u5efa\u7ec4\u7ec7\u8fdb\u884c\u65b0\u589e\u7ef4\u62a4\u3002", (String)"ScenarioDefTreeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

