/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor.admin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.monitor.ExceptionStatusEnum;
import kd.ssc.monitor.SolutionHelper;

public class AdminExceptionListPlugin
extends AbstractListPlugin {
    List<FilterColumn> listFilterColumns;
    private static final String INIT_FLAG = "AdminExceptionListPlugin#init";
    private static final Log log = LogFactory.getLog(AdminExceptionListPlugin.class);

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName = args.getFieldName();
        if (!(args instanceof FilterColumnSetFilterEvent)) {
            return;
        }
        FilterColumnSetFilterEvent event = (FilterColumnSetFilterEvent)args;
        List sscIdList = event.getCommonFilterValue("ssc.name");
        List<Long> orgIdList = AdminExceptionListPlugin.convertLongList(sscIdList);
        this.getPageCache().put("orgIdList", JSON.toJSONString(orgIdList));
        List statusObjList = event.getCommonFilterValue("status");
        List<String> statusList = AdminExceptionListPlugin.convertStringList(statusObjList);
        this.getPageCache().put("statusList", JSON.toJSONString(statusList));
        List taskBillObjList = event.getCommonFilterValue("taskbill.name");
        List<Long> taskBillList = AdminExceptionListPlugin.convertLongList(taskBillObjList);
        this.getPageCache().put("taskBillList", JSON.toJSONString(taskBillList));
        List taskTypeObjList = event.getCommonFilterValue("tasktype.name");
        List<Long> taskTypeList = AdminExceptionListPlugin.convertLongList(taskTypeObjList);
        this.getPageCache().put("taskTypeList", JSON.toJSONString(taskTypeList));
        if ("scenario.name".equals(fieldName)) {
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ssc_scenario_def", orgIdList, (boolean)true);
            if (orgFilter != null) {
                args.addCustomQFilter(orgFilter);
            }
        } else if ("taskbill.name".equals(fieldName)) {
            if (CollectionUtils.isNotEmpty(orgIdList)) {
                QFilter qFilter1 = new QFilter("ssccenter", "in", orgIdList);
                args.addCustomQFilter(qFilter1);
            }
        } else if ("tasktype.name".equals(fieldName) && CollectionUtils.isNotEmpty(orgIdList)) {
            QFilter qFilter1 = new QFilter("orgfield", "in", orgIdList);
            args.addCustomQFilter(qFilter1);
        }
    }

    private static List<Long> convertLongList(List<Object> list) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Object o : list) {
                String sscId = (String)o;
                if (!StringUtils.isNotEmpty((String)sscId)) continue;
                orgIdList.add(Long.valueOf(sscId));
            }
        }
        return orgIdList;
    }

    private static List<String> convertStringList(List<Object> list) {
        ArrayList<String> statusList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Object o : list) {
                String status = (String)o;
                if (!StringUtils.isNotEmpty((String)status)) continue;
                statusList.add(String.valueOf(status));
            }
        }
        return statusList;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (this.getPageCache().get(INIT_FLAG) == null) {
            this.getPageCache().put(INIT_FLAG, "true");
            FilterColumn statusFilter = args.getFilterColumn("status");
            List defaultSteps = statusFilter.getDefaultValues();
            if (CollectionUtils.isEmpty((Collection)defaultSteps)) {
                statusFilter.setDefaultValue(ExceptionStatusEnum.UN_PROCESSED.getValue());
            }
            String status = statusFilter.getDefaultValues().get(0).toString();
            this.setButtonByState(status);
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (e.getMainOrgQFilter() != null) {
            e.getMainOrgQFilter().or("ssc", "=", (Object)0);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String curFieldName;
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        if (currentCommonFilter == null) {
            return;
        }
        switch (curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0)) {
            case "ssc.id": {
                customlist.removeIf(t -> ((List)t.get("FieldName")).get(0).equals("taskbill.id"));
                customlist.removeIf(t -> ((List)t.get("FieldName")).get(0).equals("tasktype.id"));
                customlist.removeIf(t -> ((List)t.get("FieldName")).get(0).equals("scenario.id"));
            }
            case "status": {
                String status = ExceptionStatusEnum.UN_PROCESSED.getValue();
                for (Map customMap : customlist) {
                    List listValue = (List)customMap.get("Value");
                    List listFieldName = (List)customMap.get("FieldName");
                    String fieldName = (String)listFieldName.get(0);
                    if (!"status".equals(fieldName) || listValue.isEmpty()) continue;
                    String key = listValue.get(0).toString();
                    if (ExceptionStatusEnum.UN_PROCESSED.getValue().equals(key)) {
                        status = ExceptionStatusEnum.UN_PROCESSED.getValue();
                        continue;
                    }
                    if (ExceptionStatusEnum.PROCESSED.getValue().equals(key)) {
                        status = ExceptionStatusEnum.PROCESSED.getValue();
                        continue;
                    }
                    if (!ExceptionStatusEnum.DISABLED.getValue().equals(key)) continue;
                    status = ExceptionStatusEnum.DISABLED.getValue();
                }
                this.setButtonByState(status);
                break;
            }
        }
    }

    private void setButtonByState(String status) {
        IFormView view = this.getView();
        if (status.equals(ExceptionStatusEnum.UN_PROCESSED.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"tblretry"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tblretry"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        switch (operateKey) {
            case "show_solution": {
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AdminExceptionListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long pkId1 = (Long)selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject exceptionDo1 = BusinessDataServiceHelper.loadSingle((String)"ssc_exception", (String)"id,scenario.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId1)});
                Long defId = exceptionDo1.getLong("scenario.id");
                SolutionHelper.openSolutionForm((IFormView)this.getView(), (Long)defId);
                break;
            }
            case "show_tasklist": {
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AdminExceptionListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long pkId2 = (Long)selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject exceptionDo2 = BusinessDataServiceHelper.loadSingle((String)"ssc_exception", (String)"id,excep_billno,excep_billid,taskbill,ssc,taskid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId2)});
                String taskId = exceptionDo2.getString("taskid");
                if (!"0".equals(taskId)) {
                    this.openFormListById("task_task", "task_administrate", ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406", (String)"AdminExceptionListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), Long.valueOf(taskId), params);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u573a\u666f\u53d1\u751f\u65f6\uff0c\u672a\u751f\u6210\u5171\u4eab\u4efb\u52a1\u3002", (String)"AdminExceptionListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        Long pkId = (Long)currentRow.getPrimaryKeyValue();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        DynamicObject exceptionDo = BusinessDataServiceHelper.loadSingle((String)"ssc_exception", (String)"id,excep_billno,excep_billid,taskbill,scenario.id,ssc,taskid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
        switch (fieldName) {
            case "excep_billno": {
                args.setCancel(true);
                Long excepBillId = exceptionDo.getLong("excep_billid");
                DynamicObject taskBill = (DynamicObject)exceptionDo.get("taskbill");
                String taskBillNumber = taskBill.getString("bindbill.number");
                this.openFormListById(taskBillNumber, "bos_list", null, excepBillId, params);
                break;
            }
            case "scenario_name": {
                args.setCancel(true);
                Long scenarioId = exceptionDo.getLong("scenario.id");
                this.openScenarioForm(scenarioId);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("retry")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void openFormListById(String billFormId, String formId, String caption, Long pkId, Map<String, Object> customParams) {
        ListShowParameter listShowParameter = new ListShowParameter();
        if (customParams != null) {
            listShowParameter.setCustomParams(customParams);
        }
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.setFormId(formId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (pkId != null && pkId != 0L) {
            listShowParameter.addLinkQueryPkId((Object)pkId);
        }
        if (StringUtils.isNotEmpty((String)caption)) {
            listShowParameter.setCaption(caption);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void openScenarioForm(Long scenarioId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("ssc_scenario_def");
        billShowParameter.setPkId((Object)scenarioId);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

