/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor.mine;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.task.dis.BillCusFilter;

public class MyExceptionListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long userId = UserServiceHelper.getCurrentUserId();
        QFilter sscFilter = this.createListFilter("orgIdList", "ssc");
        QFilter taskBillFilter = this.createListFilter("taskBillList", "taskbill");
        QFilter taskTypeFilter = this.createListFilter("taskTypeList", "tasktype");
        String statusListJson = this.getPageCache().get("statusList");
        List statusList = (List)JSON.parseObject((String)statusListJson, List.class);
        QFilter statusFilter = null;
        if (CollectionUtils.isNotEmpty((Collection)statusList)) {
            statusFilter = new QFilter("status", "in", (Object)statusList);
        }
        Map<Long, List<DynamicObject>> myAuthorizeMap = this.filterMyAuthorizeMap(userId, sscFilter);
        DynamicObject[] exceptionDos = this.getExceptionDos(sscFilter, taskBillFilter, taskTypeFilter, statusFilter, myAuthorizeMap.keySet());
        HashSet<Long> myExceptionIdSet = new HashSet<Long>(16);
        for (DynamicObject exceptionDo : exceptionDos) {
            this.filterMyExceptionIdSet(userId, myAuthorizeMap, exceptionDo, myExceptionIdSet);
        }
        QFilter pkIdFilter = new QFilter("id", "in", myExceptionIdSet);
        QFilter finalHandlerFilter = new QFilter("final_handler", "=", (Object)userId);
        pkIdFilter.or(finalHandlerFilter);
        e.addCustomQFilter(pkIdFilter);
    }

    private QFilter createListFilter(String pageJsonKey, String property) {
        String orgIdListJson = this.getPageCache().get(pageJsonKey);
        List idList = (List)JSON.parseObject((String)orgIdListJson, List.class);
        QFilter filter = null;
        if (CollectionUtils.isNotEmpty((Collection)idList)) {
            filter = new QFilter(property, "in", (Object)idList);
        }
        return filter;
    }

    private DynamicObject[] getExceptionDos(QFilter sscFilter, QFilter taskBillFilter, QFilter taskTypeFilter, QFilter statusFilter, Set<Long> myScenarioIdList) {
        QFilter scenarioFilter = new QFilter("scenario", "in", myScenarioIdList);
        DynamicObject[] exceptionDos = BusinessDataServiceHelper.load((String)"ssc_exception", (String)"id,scenario,excep_billid,taskbill,tasktype", (QFilter[])new QFilter[]{sscFilter, taskBillFilter, taskTypeFilter, statusFilter, scenarioFilter}, null);
        return exceptionDos;
    }

    private void filterMyExceptionIdSet(Long userId, Map<Long, List<DynamicObject>> myAuthorizeMap, DynamicObject exceptionDo, Set<Long> myExceptionIdSet) {
        Long scenarioId = exceptionDo.getLong("scenario.id");
        if (scenarioId == 0L) {
            return;
        }
        List<DynamicObject> sscMonAuthorizeList = myAuthorizeMap.get(scenarioId);
        if (CollectionUtils.isEmpty(sscMonAuthorizeList)) {
            return;
        }
        Long exceptionId = exceptionDo.getLong("id");
        Long billId = exceptionDo.getLong("excep_billid");
        Long taskType1 = exceptionDo.getLong("tasktype.id");
        Long taskBill1 = exceptionDo.getLong("taskbill.id");
        for (DynamicObject sscMonAuthorize : sscMonAuthorizeList) {
            this.doFilterMyExceptionIdSet(userId, myExceptionIdSet, sscMonAuthorize, exceptionId, billId, taskType1, taskBill1);
        }
    }

    private void doFilterMyExceptionIdSet(Long userId, Set<Long> myExceptionIdSet, DynamicObject sscMonAuthorize, Long exceptionId, Long billId, Long taskType1, Long taskBill1) {
        boolean inTaskType = sscMonAuthorize.getBoolean("intasktype");
        boolean inTaskBill = sscMonAuthorize.getBoolean("intaskbill");
        DynamicObjectCollection clos = sscMonAuthorize.getDynamicObjectCollection("entryentity");
        for (DynamicObject authorizeDo : clos) {
            MulBasedataDynamicObjectCollection assigneeClos;
            QFilter billFilter;
            QFilter idFilter;
            String entityName;
            String billCusFilterJson;
            Long taskBill2;
            Long taskType2;
            if (inTaskType && !(taskType2 = Long.valueOf(authorizeDo.getLong("tasktype.id"))).equals(taskType1) || inTaskBill && (!(taskBill2 = Long.valueOf(authorizeDo.getLong("taskbill.id"))).equals(taskBill1) || StringUtils.isNotEmpty((String)(billCusFilterJson = authorizeDo.getString("filter"))) && !QueryServiceHelper.exists((String)(entityName = authorizeDo.getString("taskbill.bindbill.number")), (QFilter[])new QFilter[]{idFilter = new QFilter("id", "=", (Object)billId), billFilter = BillCusFilter.getBillFilter(entityName, billCusFilterJson)})) || CollectionUtils.isEmpty((Collection)(assigneeClos = (MulBasedataDynamicObjectCollection)authorizeDo.get("assignee"))) || !this.exitAssignee(assigneeClos, userId)) continue;
            myExceptionIdSet.add(exceptionId);
        }
    }

    private Map<Long, List<DynamicObject>> filterMyAuthorizeMap(Long userId, QFilter sscFilter) {
        DynamicObject[] authorizeDos;
        HashMap<Long, List<DynamicObject>> myAuthorizeMap = new HashMap<Long, List<DynamicObject>>(16);
        block0: for (DynamicObject sscMonAuthorize : authorizeDos = BusinessDataServiceHelper.load((String)"ssc_mon_authorize", (String)"id,scenariodef,intasktype,intaskbill,entryentity.tasktype,entryentity.taskbill,entryentity.filter,entryentity.assignee", (QFilter[])new QFilter[]{sscFilter})) {
            DynamicObjectCollection clos = sscMonAuthorize.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)clos)) continue;
            Long scenarioId = sscMonAuthorize.getLong("scenariodef.id");
            ArrayList<DynamicObject> sscMonAuthorizeList = (ArrayList<DynamicObject>)myAuthorizeMap.get(scenarioId);
            if (sscMonAuthorizeList == null) {
                sscMonAuthorizeList = new ArrayList<DynamicObject>(8);
            }
            for (DynamicObject authorizeDo : clos) {
                MulBasedataDynamicObjectCollection assigneeClos = (MulBasedataDynamicObjectCollection)authorizeDo.get("assignee");
                if (CollectionUtils.isEmpty((Collection)assigneeClos) || !this.exitAssignee(assigneeClos, userId)) continue;
                sscMonAuthorizeList.add(sscMonAuthorize);
                myAuthorizeMap.put(scenarioId, sscMonAuthorizeList);
                continue block0;
            }
        }
        return myAuthorizeMap;
    }

    private boolean exitAssignee(MulBasedataDynamicObjectCollection assigneeClos, Long userId) {
        for (DynamicObject assigneeDo : assigneeClos) {
            Long baseDataId = (Long)assigneeDo.get("fbasedataid.id");
            if (!userId.equals(baseDataId)) continue;
            return true;
        }
        return false;
    }
}

