/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.overdue;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.workcalendar.CalRemainingTime;
import kd.ssc.task.service.overdue.IRemainingTimeService;
import kd.ssc.task.workcalendar.pojo.RemainingTimeInfo;
import kd.ssc.task.workcalendar.pojo.SimpleJob;
import kd.ssc.task.workcalendar.pojo.SimpleJobStateTime;

public class RemainingTimeServiceImpl
implements IRemainingTimeService {
    private static final Log log = LogFactory.getLog(RemainingTimeServiceImpl.class);

    @Override
    public Map<Long, RemainingTimeInfo> calRemainingTime(DataSet taskData, boolean isQuality, String callSource, Map<String, Object> paramMap) {
        log.info(String.format("\u8ba1\u7b97\u5269\u4f59\u65f6\u95f4\u4e0e\u8d85\u671f\u72b6\u6001start,isQuality:%s,callSource:%s", isQuality, callSource));
        HashMap<Long, SimpleJob> simpleJobMap = new HashMap<Long, SimpleJob>(16);
        HashMap<Long, List<SimpleJobStateTime>> simpleJobStateChangeMap = new HashMap<Long, List<SimpleJobStateTime>>(16);
        CalRemainingTime cal = new CalRemainingTime();
        cal.parseJobData(simpleJobMap, simpleJobStateChangeMap, taskData, isQuality);
        Map<Long, RemainingTimeInfo> remainingTimeInfoMap = cal.getReminderTimeMap(simpleJobMap, simpleJobStateChangeMap);
        if (StringUtils.isNotEmpty((String)callSource)) {
            switch (callSource) {
                case "1": {
                    cal.updateToDB(remainingTimeInfoMap);
                    if (!isQuality) break;
                    QualityCheckSchemeUtil.changeQualitySampleLib(remainingTimeInfoMap);
                    break;
                }
                case "2": {
                    cal.updateToDB(remainingTimeInfoMap);
                    this.savePriorityChangeRecord(simpleJobMap, remainingTimeInfoMap);
                    break;
                }
                case "3": 
                case "5": 
                case "6": {
                    cal.updateToDB2(remainingTimeInfoMap);
                    break;
                }
                case "4": {
                    break;
                }
            }
        }
        log.info("\u8ba1\u7b97\u5269\u4f59\u65f6\u95f4\u4e0e\u8d85\u671f\u72b6\u6001end");
        return remainingTimeInfoMap;
    }

    public void savePriorityChangeRecord(Map<Long, SimpleJob> simpleJobMap, Map<Long, RemainingTimeInfo> remainingTimeInfoMap) {
        if (simpleJobMap != null) {
            log.info("\u4fdd\u5b58\u4f18\u5148\u7ea7\u6539\u53d8\u65e5\u5fd7start");
            ArrayList<DynamicObject> changeRecordList = new ArrayList<DynamicObject>(8);
            for (Map.Entry<Long, SimpleJob> entry : simpleJobMap.entrySet()) {
                Long jobId = entry.getKey();
                SimpleJob row = entry.getValue();
                BigDecimal remainTime = null;
                BigDecimal taskDuration = row.getTaskduration();
                RemainingTimeInfo info = remainingTimeInfoMap.get(jobId);
                if (info != null) {
                    remainTime = info.getReminderTime();
                }
                if (remainTime != null && remainTime.compareTo(taskDuration) < 0) {
                    taskDuration = remainTime;
                }
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"task_prioritychangerecord");
                obj.set("job", (Object)jobId);
                obj.set("changetime", (Object)new Date());
                obj.set("limittime", (Object)taskDuration);
                changeRecordList.add(obj);
            }
            if (CollectionUtils.isNotEmpty(changeRecordList)) {
                SaveServiceHelper.save((DynamicObject[])changeRecordList.toArray(new DynamicObject[0]));
            }
            log.info("\u4fdd\u5b58\u4f18\u5148\u7ea7\u6539\u53d8\u65e5\u5fd7end");
        }
    }
}

