/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.achieve;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ExtrapointSaveValidator
extends AbstractValidator {
    private static final BigDecimal ZERO = new BigDecimal(new BigInteger("0"), 2);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject extraPoint = dataEntity.getDataEntity();
            BigDecimal score = extraPoint.getBigDecimal("score");
            DynamicObject achieveTarget = extraPoint.getDynamicObject("target");
            if (score == null || ZERO.equals(score) || achieveTarget == null) continue;
            boolean hasSetUp = achieveTarget.getBoolean("setup");
            boolean hasSetDown = achieveTarget.getBoolean("setdown");
            BigDecimal maxScore = achieveTarget.getBigDecimal("maxscore");
            BigDecimal minScore = achieveTarget.getBigDecimal("minscore");
            if (hasSetUp && maxScore != null && maxScore.compareTo(score) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u52a0\u51cf\u5206\u503c\u5927\u4e8e\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u3002", (String)"ExtraPointsListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!hasSetDown || minScore == null || minScore.compareTo(score) <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u52a0\u51cf\u5206\u503c\u5c0f\u4e8e\u6307\u6807\u5206\u503c\u6700\u5c0f\u503c\u3002", (String)"ExtraPointsListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

