/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;
import kd.ssc.smartcs.util.ExceptionHandler;
import kd.ssc.task.opplugin.smartcs.util.ErrorMsgBuilder;

public class AreaDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final String AI_AREA_ID = "aiareaid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(AI_AREA_ID);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] deleteSuccessDyn = e.getDataEntities();
        if (deleteSuccessDyn == null || deleteSuccessDyn.length == 0) {
            return;
        }
        ArrayList<DynamicObject> continueDelDynList = new ArrayList<DynamicObject>(Arrays.asList(deleteSuccessDyn));
        for (DynamicObject dyo : deleteSuccessDyn) {
            try {
                AIMetaDataSynchrnizedUtil.deleteAreaForBatching(Collections.singletonList(dyo.getLong(AI_AREA_ID)));
            }
            catch (KDException ex) {
                continueDelDynList.remove(dyo);
                this.operationResult.addErrorInfo((OperateErrorInfo)ErrorMsgBuilder.buildErrMessage(dyo, (Exception)((Object)ex), ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57df\u5220\u9664", (String)"", (String)"", (Object[])new Object[0])));
                ExceptionHandler.saveErrLog((String)dyo.getDataEntityType().getName(), (Object)dyo.getPkValue(), (Throwable)ex);
            }
        }
        e.setDataEntities(continueDelDynList.toArray(new DynamicObject[0]));
    }
}

