/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.result.SubjectResult;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;
import kd.ssc.smartcs.util.ExceptionHandler;
import kd.ssc.task.opplugin.smartcs.SubjectSaveValidator;
import kd.ssc.task.opplugin.smartcs.util.ErrorMsgBuilder;

public class SubjectSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String AREA = "area";
    private static final String IS_SUBJECT = "subject";
    private static final String SUBJECT_NUMBER = "subjectnum";
    private static final String AI_SUBJECT_ID = "aisubjectid";
    private static final String SUBJECT_NAME = "name";
    private Set<Long> updateDataIds = new HashSet<Long>(1);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add(AREA);
        fields.add(IS_SUBJECT);
        fields.add(SUBJECT_NUMBER);
        fields.add(AI_SUBJECT_ID);
        fields.add(SUBJECT_NAME);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SubjectSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (this.getOption().containsVariable("from_sync")) {
            return;
        }
        List datas = e.getValidExtDataEntities();
        for (ExtendedDataEntity data : datas) {
            boolean updateObj = data.getDataEntity().getDataEntityState().getFromDatabase();
            if (!updateObj) continue;
            this.updateDataIds.add((Long)data.getDataEntity().getPkValue());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] saveSuccessDyn = e.getDataEntities();
        if (saveSuccessDyn == null || saveSuccessDyn.length == 0) {
            return;
        }
        ArrayList<DynamicObject> continueSaveDynList = new ArrayList<DynamicObject>(Arrays.asList(saveSuccessDyn));
        for (DynamicObject dyo : saveSuccessDyn) {
            try {
                this.syncEachSubject(dyo);
            }
            catch (Exception ex) {
                continueSaveDynList.remove(dyo);
                this.operationResult.addErrorInfo((OperateErrorInfo)ErrorMsgBuilder.buildErrMessage(dyo, ex, ResManager.loadKDString((String)"\u77e5\u8bc6\u7c7b\u76ee\u540c\u6b65", (String)"SubjectSavePlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0])));
                ExceptionHandler.saveErrLog((String)dyo.getDataEntityType().getName(), (Object)dyo.getPkValue(), (Throwable)ex);
            }
        }
        e.setDataEntities(continueSaveDynList.toArray(new DynamicObject[0]));
    }

    private void syncEachSubject(DynamicObject dyo) {
        boolean isSubject = this.subject(dyo);
        if (isSubject) {
            Long id = (Long)dyo.getPkValue();
            long aiSubjectId = dyo.getLong(AI_SUBJECT_ID);
            Long areaId = this.getAIAreaId(this.getAreaId(dyo));
            String name = dyo.getString(SUBJECT_NAME) + "";
            String number = dyo.getString("number");
            if (this.updateDataIds.contains(id)) {
                if (aiSubjectId == 0L) {
                    ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u7c7b\u76ee\u65f6\uff0c\u65e0\u6cd5\u83b7\u5f97AI\u7c7b\u76eeid", (String)"SubjectSavePlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    throw new KDException(code, new Object[0]);
                }
                AIMetaDataSynchrnizedUtil.updateSubject((Long)aiSubjectId, (Long)areaId, (String)name, (String)number);
            } else {
                SubjectResult result = AIMetaDataSynchrnizedUtil.addSubject((Long)areaId, (String)name, (String)number);
                dyo.set(AI_SUBJECT_ID, (Object)result.getId());
            }
        }
    }

    private Long getAIAreaId(Long areaId) {
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject area = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"aiareaid", (QFilter[])new QFilter[]{qFilter});
        if (area == null || area.getLong("aiareaid") == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u65b0\u589e\u6216\u66f4\u65b0\u79d1\u76ee\u65f6\u672a\u83b7\u5f97\u6240\u5c5e\u9886\u57dfid\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u9886\u57dfid\u4e3a\uff1a%s", (String)"SubjectSavePlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), areaId));
            throw new KDException(code, new Object[0]);
        }
        return area.getLong("aiareaid");
    }

    private Long getAreaId(DynamicObject dyo) {
        Object value = dyo.get(AREA);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        return (Long)value;
    }

    private boolean subject(DynamicObject dyo) {
        return dyo.getBoolean(IS_SUBJECT);
    }
}

