/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sscbillmanger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.workbill.WorkBillCommonHelper;
import kd.ssc.task.opplugin.sscbillmanger.GenIscObjectValidatorPlugin;
import kd.ssc.workbill.util.ISCUtil;

public class GenIscObjectPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(GenIscObjectPlugin.class);
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final HashSet<String> excludeProps = new HashSet<String>(){
        {
            this.add("sourcebilltype");
            this.add("billstatus");
            this.add("linkconfig");
            this.add("sourcebillid");
            this.add("extparam");
            this.add("extparam_tag");
            this.add("flownumber");
        }
    };

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new GenIscObjectValidatorPlugin());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        OperationResult operationResult = this.getOperationResult();
        ValidateResultCollection collection = operationResult.getValidateResult();
        List validateResults = collection.getValidateErrors();
        List successPkIds = operationResult.getSuccessPkIds();
        ArrayList<DynamicObject> genISCObjData = new ArrayList<DynamicObject>();
        for (DynamicObject data : dataEntities) {
            DynamicObject sourceISCObject;
            if (!successPkIds.contains(data.getPkValue())) continue;
            long targetId = data.getLong("targetid");
            DynamicObject targetISCObject = BusinessDataServiceHelper.loadSingle((Object)targetId, (String)ISC_METADATA_SCHEMA);
            if (targetISCObject == null) {
                successPkIds.remove(data.getPkValue());
                ValidationErrorInfo info = new ValidationErrorInfo("", data.getPkValue(), 0, 0, "errorcode_001", "", ResManager.loadKDString((String)"\u672a\u540c\u6b65\u76ee\u6807\u5bf9\u8c61\uff0c\u8bf7\u5148\u540c\u6b65\u76ee\u6807\u5bf9\u8c61\u3002", (String)"GenIscObjectPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                ValidateResult validateResult = new ValidateResult();
                validateResult.addErrorInfo((OperateErrorInfo)info);
                validateResults.add(validateResult);
                continue;
            }
            long sourceId = data.getLong("sourceid");
            if (sourceId != 0L) {
                sourceISCObject = QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (Object)sourceId) ? BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)ISC_METADATA_SCHEMA) : BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA);
            } else {
                if (sourceId != 0L) continue;
                sourceISCObject = BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA);
            }
            List<DynamicObject> sourceISCObjectList = this.getSourceObjectData(targetISCObject, sourceISCObject, data);
            try {
                DynamicObject[] entities = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])sourceISCObjectList.toArray(new DynamicObject[0]));
                if (entities.length > 0) {
                    String sourceNumber = data.getString("source_number");
                    List mainISC = Arrays.stream(entities).filter(en -> sourceNumber.equals(en.getString("number"))).collect(Collectors.toList());
                    if (mainISC.size() > 0) {
                        data.set("sourceid", ((DynamicObject)mainISC.get(0)).getPkValue());
                    }
                }
                genISCObjData.add(data);
            }
            catch (Exception exception) {
                log.error("GenIscObjectPlugin\u751f\u6210\u96c6\u6210\u5bf9\u8c61\u5931\u8d25\uff1a" + exception.getMessage(), (Throwable)exception);
                successPkIds.remove(data.getPkValue());
                ValidationErrorInfo info = new ValidationErrorInfo("", data.getPkValue(), 0, 0, "errorcode_001", "", ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"GenIscObjectPlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                ValidateResult validateResult = new ValidateResult();
                validateResult.addErrorInfo((OperateErrorInfo)info);
                validateResults.add(validateResult);
            }
        }
        try {
            SaveServiceHelper.save((DynamicObject[])genISCObjData.toArray(genISCObjData.toArray(new DynamicObject[0])));
        }
        catch (Throwable throwable) {
            String numbers = genISCObjData.stream().map(dyo -> dyo.getString("number")).collect(Collectors.joining(","));
            log.error("genISCObjData\u751f\u6210\u96c6\u6210\u5bf9\u8c61\u6210\u529f\uff0c\u4f46\u56de\u5199\u5171\u4eab\u5de5\u5355\u7ba1\u7406-\u6e90\u96c6\u6210\u5bf9\u8c61id\u5931\u8d25\uff0c\u5931\u8d25\u5de5\u5355\u7f16\u7801\uff1a" + numbers, throwable);
            throw new RuntimeException(throwable);
        }
    }

    private List<DynamicObject> getSourceObjectData(DynamicObject targetObject, DynamicObject sourceObject, DynamicObject workBillData) {
        long group = workBillData.getLong("source_datas.id");
        String sourceNumber = workBillData.getString("source_number");
        String sourceName = workBillData.getString("source_name");
        sourceObject.set("group", (Object)group);
        sourceObject.set("number", (Object)sourceNumber);
        sourceObject.set("name", (Object)sourceName);
        if (sourceObject.getLong("creator.id") == 0L) {
            ISCUtil.setISCObjectBaseInfo((DynamicObject)sourceObject, (String)"STRUCT");
        }
        String isvPrefix = WorkBillCommonHelper.getIsvPrefix();
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("prop_entryentity");
        entryentity.removeIf(p -> excludeProps.contains(p.getString("prop_name")));
        return ISCUtil.buildISCObject((DynamicObject)targetObject, (DynamicObject)sourceObject, (long)group, (String)sourceNumber, (String)isvPrefix);
    }
}

