/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.api.smartcs;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UrlModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.ssc.mircoservice.helper.SmartCustomerServiceHelper;
import kd.ssc.mircoservice.result.ServiceResult;

public class SmartcsAITextModelApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(SmartcsAITextModelApiPlugin.class);
    private static final ThreadLocal<String> command = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAICommand(AICommandEvent e) {
        String c = e.getCommand().getCommand();
        logger.info("SmartcsAITextModelApiPlugin doAICommand:{} accept a request:", (Object)JSON.toJSONString((Object)e));
        ApiResult apiResult = null;
        try {
            command.set(c);
            ServiceResult serviceResult = this.invokeService(e);
            apiResult = serviceResult.toApiResultWithoutData();
            if (apiResult.getSuccess()) {
                this.setApiResultData(apiResult, (ServiceResult<String>)serviceResult);
            } else {
                this.setApiBizErrorResultData(apiResult, (ServiceResult<String>)serviceResult);
            }
        }
        catch (Exception ex) {
            apiResult = ApiResult.ex((Throwable)ex);
            logger.error("SmartcsAITextModelApiPlugin doAICommand:{} occur exception:{}", (Object)c, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        finally {
            command.remove();
            logger.info("SmartcsAITextModelApiPlugin doAICommand:{} response result:{}", (Object)c, (Object)JSON.toJSONString((Object)apiResult));
            e.setResult(apiResult);
        }
    }

    private ServiceResult invokeService(AICommandEvent e) {
        AICommand aiCommand = e.getCommand();
        String params = JSON.toJSONString((Object)aiCommand.getParameter());
        String jsonResult = SmartCustomerServiceHelper.callCustomerService((String)params);
        return (ServiceResult)JSON.parseObject((String)jsonResult, ServiceResult.class);
    }

    private void setApiBizErrorResultData(ApiResult apiResult, ServiceResult<String> serviceResult) {
        String message = serviceResult.getMessage();
        logger.info("SmartcsAITextModelApiPlugin data:{} from microservice", (Object)message);
        if (message != null) {
            ResponseModel content = ResponseModel.createTextResponse((String)message);
            apiResult.setData((Object)content);
            apiResult.setSuccess(true);
            apiResult.setErrorCode("success");
        }
    }

    private void setApiResultData(ApiResult apiResult, ServiceResult<String> serviceResult) {
        String data = (String)serviceResult.getData();
        logger.info("SmartcsAITextModelApiPlugin data:{} from microservice", (Object)data);
        if (data != null) {
            String url = this.getProtocol() + "://chat?openId=" + data;
            UrlModel urlModel = this.createUrlModel(url);
            ResponseModel content = ResponseModel.createUrlResponse((UrlModel)urlModel);
            apiResult.setData((Object)content);
        }
    }

    private String getProtocol() {
        String protocol = "cloudhub-private";
        try {
            AppParam appParam = new AppParam();
            appParam.setAppId("83bfebc8000037ac");
            appParam.setViewType("15");
            appParam.setOrgId(Long.valueOf(100000L));
            appParam.setActBookId(Long.valueOf(0L));
            Map stringObjectMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            if (stringObjectMap == null) {
                logger.error("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\uff0c\u7cfb\u7edf\u53c2\u6570\u4e3a\u7a7a");
                return protocol;
            }
            Object yzjurl = stringObjectMap.get("yzjurl");
            if ("https://www.yunzhijia.com".equals(yzjurl)) {
                return "cloudhub";
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return protocol;
        }
        return protocol;
    }

    private UrlModel createUrlModel(String url) {
        UrlModel urlModel = new UrlModel();
        urlModel.setTitle(ResManager.loadKDString((String)"\u4eba\u5de5\u5ba2\u670d", (String)"SmartcsAITextModelApiPlugin_1", (String)"ssc-task-webapi", (Object[])new Object[0]));
        urlModel.setContent(ResManager.loadKDString((String)"\u4eba\u5de5\u5ba2\u670d", (String)"SmartcsAITextModelApiPlugin_1", (String)"ssc-task-webapi", (Object[])new Object[0]));
        urlModel.setUrl(url);
        urlModel.setIframe(true);
        return urlModel;
    }
}

