/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.api.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ssc.task.api.model.BillInfo;
import kd.ssc.task.api.model.UpdateTaskPriority;

@ApiController(value="ssc", desc="\u5171\u4eab\u4e2d\u5fc3\u4efb\u52a1\u670d\u52a1\u63a5\u53e3")
@ApiMapping(value="/task")
public class UpdateTaskPriorityApiController {
    @ApiPostMapping(value="/updateTaskPriority", desc="\u4fee\u6539\u4efb\u52a1\u4f18\u5148\u7ea7\u63a5\u53e3")
    @ApiErrorCodes(value={@ApiErrorCode(code="ssc.100001", desc="\u4f18\u5148\u7ea7\u6570\u503c\u5fc5\u987b\u662f[1,100]\u7684\u6574\u6570"), @ApiErrorCode(code="ssc.100002", desc="\u5355\u636e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71000"), @ApiErrorCode(code="ssc.100003", desc="\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a")})
    public CustomApiResult<?> updateTaskPriority(@NotNull @Valid @ApiRequestBody(value="\u4f18\u5148\u7ea7\u4fe1\u606f") UpdateTaskPriority updateTaskPriority) {
        Integer taskPriority = updateTaskPriority.getTaskPriority();
        List<BillInfo> billInfoList = updateTaskPriority.getBillInfoList();
        if (taskPriority > 100 || taskPriority < 1) {
            return CustomApiResult.fail((String)"ssc.100001", (String)ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u6570\u503c\u5fc5\u987b\u4e3a1\u81f3100\u7684\u6574\u6570\u3002", (String)"UpdateTaskPriorityApiController_1", (String)"ssc-task-webapi", (Object[])new Object[0]));
        }
        if (billInfoList.size() == 0) {
            return CustomApiResult.fail((String)"ssc.100003", (String)ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateTaskPriorityApiController_2", (String)"ssc-task-webapi", (Object[])new Object[0]));
        }
        if (billInfoList.size() > 1000) {
            return CustomApiResult.fail((String)"ssc.100002", (String)ResManager.loadKDString((String)"\u5355\u636e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"UpdateTaskPriorityApiController_0", (String)"ssc-task-webapi", (Object[])new Object[0]));
        }
        ArrayList billList = new ArrayList(billInfoList.size());
        for (BillInfo billInfo : billInfoList) {
            HashMap<String, Object> bill = new HashMap<String, Object>(4);
            bill.put("billId", billInfo.getBillId());
            bill.put("billType", billInfo.getBillType());
            billList.add(bill);
        }
        Object resultData = DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"updateTaskPriority", (Object[])new Object[]{billList, taskPriority});
        CustomApiResult result = new CustomApiResult();
        result.setStatus(true);
        result.setMessage(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u66f4\u65b0\u6210\u529f\u3002", (String)"UpdateTaskPriorityApiController_3", (String)"ssc-task-webapi", (Object[])new Object[0]));
        result.setData(resultData);
        return result;
    }

    private boolean checkBillIdType(Object billId) {
        if (!(billId instanceof Long)) {
            if (billId instanceof String) {
                try {
                    Long.parseLong((String)billId);
                }
                catch (Exception e) {
                    return false;
                }
            }
            try {
                long e = ((Integer)billId).intValue();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return true;
    }
}

