/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.extendplugin.base.TaskExtendBill;
import kd.ssc.task.util.EasTaskExpenseHelper;

public class TaskPaymentBill
extends TaskExtendBill
implements HyperLinkClickListener,
BeforeF7SelectListener,
ClickListener {
    private static final String CHCHE_TASKPAYBILL_APPLAYID_VALUE = "CHCHE_TASKPAYBILL_APPLAYID_VALUE";

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid list = (EntryGrid)this.getControl("entries");
        list.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit expensetype = (BasedataEdit)this.getControl("expensetype");
        expensetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if ("approvedmoney".equals(propertyName)) {
            BigDecimal amtloc = (BigDecimal)changeData.getNewValue();
            BigDecimal nottaxmoney = (BigDecimal)model.getValue("nottaxmoney", changeData.getRowIndex());
            BigDecimal tax = amtloc.subtract(nottaxmoney);
            model.setValue("taxmoney", (Object)tax, changeData.getRowIndex());
        } else if ("taxrate".equals(propertyName)) {
            BigDecimal taxrate = (BigDecimal)changeData.getNewValue();
            BigDecimal amountAppproved = (BigDecimal)model.getValue("approvedmoney", changeData.getRowIndex());
            BigDecimal nottaxmoney = amountAppproved.divide(taxrate.add(new BigDecimal("1")), amountAppproved.precision(), 4);
            model.setValue("nottaxmoney", (Object)nottaxmoney, changeData.getRowIndex());
            BigDecimal tax = amountAppproved.subtract(nottaxmoney);
            model.setValue("taxmoney", (Object)tax, changeData.getRowIndex());
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initPositionAndCostCompany();
    }

    public void initPositionAndCostCompany() {
        DynamicObject firstrow;
        String costcompany = "";
        DynamicObject data = this.getModel().getDataEntity();
        costcompany = ((DynamicObject)data.get("company")).getString("name");
        Label costcompanyv = (Label)this.getControl("costcompanyv");
        costcompanyv.setText(costcompany);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskID = (String)formShowParameter.getCustomParams().get("taskID");
        FormShowParameter parFormShowPara = this.getView().getParentView().getFormShowParameter();
        String pooltype = (String)parFormShowPara.getCustomParams().get("pooltype");
        if (StringUtils.isNull((String)pooltype)) {
            pooltype = (String)parFormShowPara.getCustomParams().get("pooltype-mytask");
        }
        DynamicObject task = null;
        task = !pooltype.equals("2") ? BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task")) : BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_taskhistory"));
        DynamicObject applier = task.getDynamicObject("creator");
        String company = "";
        String dept = "";
        long deptID = UserServiceHelper.getUserMainOrgId((long)applier.getLong("id"));
        OrgServiceHelper orgSerHelper = new OrgServiceHelper();
        DynamicObject bizOrg = orgSerHelper.getBizOrg(Long.valueOf(deptID), "01");
        dept = bizOrg.getString("name");
        this.getModel().setValue("dept", (Object)dept);
        Map companyInfo = OrgServiceHelper.getCompanyfromOrg((Object)deptID);
        company = (String)companyInfo.get("name");
        this.getModel().setValue("appliercompany", (Object)company);
        String applierid = String.valueOf(applier.getLong("id"));
        String picturefield = (String)applier.get("picturefield");
        String position = "";
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)applierid, (String)"bos_user");
        if (userObject != null && (firstrow = (DynamicObject)userObject.getDynamicObjectCollection("entryentity").get(0)) != null) {
            position = firstrow.getString("position");
        }
        Label positionLabel = (Label)this.getControl("position");
        positionLabel.setText(position);
        this.getPageCache().put(CHCHE_TASKPAYBILL_APPLAYID_VALUE, applierid);
        EasTaskExpenseHelper.showCreditInfoForm(this.getView(), applier.getLong("id"));
        Image picture = (Image)this.getControl("imageap");
        picture.setUrl(picturefield);
        this.getModel().setValue("dept", (Object)dept);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            String userId = this.getPageCache().get(CHCHE_TASKPAYBILL_APPLAYID_VALUE);
            IFormView view = this.getView();
            EasTaskExpenseHelper.showCreditFilesForm(view, userId);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        if (arg0.getFieldName().equals("contractnumber")) {
            this.openUrl("http://icrm.kingdee.com:81/icrm/pm/cm/contract/cmProcureContracts!viewWorkflow.action?number=", "&operateState=VIEW", "contractnumber");
        } else if (arg0.getFieldName().equals("settlementnumber")) {
            this.openUrl("http://icrm.kingdee.com:81/icrm/workflowCenter!viewWorkflow.action?number=", "&operateState=VIEW", "settlementnumber");
        }
    }

    protected void openUrl(String urlHead, String urlEnd, String fieldName) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entries");
        String contractnumber = this.getModel().getValue(fieldName, rowIndex).toString();
        String url = urlHead + contractnumber + urlEnd;
        this.getView().openUrl(url);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (name.equals("expensetype")) {
            ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
            lsp.setMultiSelect(false);
        }
    }
}

