/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.ssc.task.bill.TaskBillHandler;
import kd.ssc.task.bill.TaskBillHandlerFactory;

@KSObject
public class CoeffieientsEdit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public static DynamicObjectCollection getEntryInfo() {
        ORM orm = ORM.create();
        String selectFields = "id,entryentity.tasktype tasktype,basetype billtype, entryentity.id entryid,entryentity.tasktype.name tasktypeName";
        try (DataSet dataset = orm.queryDataSet("tk.OpinionsEditPlugin.getEntryInfo", "task_taskquantcoefficient", selectFields, null);){
            DynamicObjectCollection cc;
            DynamicObjectCollection dynamicObjectCollection = cc = orm.toPlainDynamicObjectCollection(dataset);
            return dynamicObjectCollection;
        }
    }

    @KSMethod
    public static DynamicObject getOpinionInfoByTaskTypeAndBillType(Long tasktype, Long basetype) {
        ORM orm = ORM.create();
        QFilter f = new QFilter("entryentity.tasktype", "=", (Object)tasktype);
        QFilter g = new QFilter("basetype", "=", (Object)basetype);
        DynamicObject dataset = orm.queryOne("task_taskquantcoefficient", "id", new QFilter[]{f, g});
        dataset = orm.getById("task_taskquantcoefficient", dataset.getPkValue());
        return dataset;
    }

    @KSMethod
    public static HashMap getBindBillNumberAndKey(Long billtypeId) {
        DynamicObject bindBill = CoeffieientsEdit.getBindBillValue(billtypeId);
        DynamicObject bindBill2 = (DynamicObject)bindBill.get("bindbill");
        String entityKey = bindBill2.getString("number");
        String entityName = bindBill2.getLocaleString("name").toString();
        HashMap<String, String> billMap = new HashMap<String, String>();
        billMap.put("entityKey", entityKey);
        billMap.put("entityName", entityName);
        return billMap;
    }

    public static DynamicObject getBindBillValue(Long billtypeId) {
        QFilter f = new QFilter("id", "=", (Object)billtypeId);
        DynamicObject bindBill = ORM.create().queryOne("task_taskbill", new QFilter[]{f});
        return bindBill;
    }

    @KSMethod
    public static List<Map<String, Object>> sortLeftCard(DynamicObjectCollection entryInfo) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject entryDynamic : entryInfo) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", entryDynamic.getString("tasktypeName"));
            map.put("tasktype", entryDynamic.getLong("tasktype"));
            map.put("billtype", entryDynamic.getLong("billtype"));
            list.add(map);
        }
        CoeffieientsEdit.listSort(list);
        return list;
    }

    public static void listSort(List<Map<String, Object>> resultList) {
        Collections.sort(resultList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String name1 = (String)o1.get("name");
                String name2 = (String)o2.get("name");
                if (name1 == null && name2 == null) {
                    return 0;
                }
                Collator instance = Collator.getInstance(Locale.CHINA);
                return instance.compare(name1, name2);
            }
        });
    }

    @KSMethod
    public static void update(DynamicObject obj) {
        ORM orm = ORM.create();
        orm.update(obj);
    }

    @KSMethod
    public static String validEntry(DynamicObjectCollection entryCol) {
        if (entryCol == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        StringBuffer errorMsg = null;
        StringBuilder error = new StringBuilder(ResManager.loadKDString((String)"\u5206\u5f55\uff1a", (String)"CoeffieientsEdit_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        HashSet<Integer> seqindex = null;
        boolean iserror = false;
        for (DynamicObject dynamicObject : entryCol) {
            map = new HashMap<String, String>();
            long expense = dynamicObject.getLong("expensetype.id");
            if (expense == 0L) {
                expense = dynamicObject.getLong("expenseitem.id");
            }
            String seq = String.valueOf(dynamicObject.get("seq"));
            map.put("name", String.valueOf(expense));
            map.put("seq", seq);
            list.add(map);
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            errorMsg = new StringBuffer();
            seqindex = new HashSet<Integer>();
            seqindex.add(Integer.valueOf((String)((Map)list.get(i)).get("seq")));
            for (int j = list.size() - 1; j > i; --j) {
                String nametail;
                String namehead = String.valueOf(((Map)list.get(j)).get("name"));
                if (!namehead.equals(nametail = String.valueOf(((Map)list.get(i)).get("name")))) continue;
                errorMsg.append((String)((Map)list.get(i)).get("name"));
                seqindex.add(Integer.valueOf((String)((Map)list.get(j)).get("seq")));
                list.remove(j);
                errorMsg.delete(0, errorMsg.length());
                errorMsg.append(seqindex);
            }
            if (errorMsg.length() <= 0) continue;
            error.append(errorMsg).append(ResManager.loadKDString((String)"\u884c\u76f8\u540c", (String)"CoeffieientsEdit_1", (String)"ssc-task-ext", (Object[])new Object[0])).append("\n\r");
            iserror = true;
        }
        if (iserror) {
            return error.toString();
        }
        return null;
    }

    @KSMethod
    public static DynamicObject newDynamicObject(DynamicObjectCollection mainCollection) {
        return new DynamicObject(mainCollection.getDynamicObjectType());
    }

    @KSMethod
    public static void updateTaskCoefficient(long tasktypeid, long billtypeid) {
        ORM orm = ORM.create();
        DynamicObjectCollection taskInfo = CoeffieientsEdit.getTaskInfo(tasktypeid, billtypeid);
        DynamicObject billType = CoeffieientsEdit.getErpNumber(billtypeid);
        String erpNumber = billType.getString("externalerp.number");
        String bindBillNumber = billType.getString("bindbill.number");
        HashMap costCompanyMap = new HashMap();
        DynamicObject coefficientInfo = CoeffieientsEdit.queryTaskCoefficients(billtypeid, tasktypeid);
        if (coefficientInfo == null) {
            return;
        }
        BigDecimal coefficient = coefficientInfo.getBigDecimal("coefficientshead");
        if (taskInfo != null) {
            for (DynamicObject singleTaskInfo : taskInfo) {
                String bizdata = singleTaskInfo.getString("bizdata_tag");
                if ("eas".equalsIgnoreCase(erpNumber)) {
                    TaskBillHandler handler = TaskBillHandlerFactory.getBillHandlerFactory((String)erpNumber, (String)bindBillNumber);
                    costCompanyMap = handler.getOpinionField(bindBillNumber, bizdata);
                    coefficient = CoeffieientsEdit.compareCoefficientValue(tasktypeid, coefficientInfo, costCompanyMap, coefficient, "expensetype.id");
                } else {
                    costCompanyMap = CoeffieientsEdit.getNextField(bindBillNumber, billtypeid);
                    coefficient = CoeffieientsEdit.compareCoefficientValue(tasktypeid, coefficientInfo, costCompanyMap, coefficient, "expenseitem.id");
                }
                singleTaskInfo.set("coefficient", (Object)coefficient);
                orm.update(singleTaskInfo);
            }
        }
    }

    public static DynamicObject queryTaskCoefficients(Object billtypeId, Object tasktypeId) {
        ORM orm = ORM.create();
        QFilter h = new QFilter("basetype", "=", billtypeId);
        QFilter j = new QFilter("entryentity.tasktype", "=", tasktypeId);
        DynamicObject coefficientInfo = orm.queryOne("task_taskquantcoefficient", new QFilter[]{h, j});
        if (coefficientInfo == null) {
            return null;
        }
        coefficientInfo = orm.getById("task_taskquantcoefficient", coefficientInfo.getPkValue());
        return coefficientInfo;
    }

    public static BigDecimal compareCoefficientValue(Long taskTypeId, DynamicObject coefficientInfo, Map<String, Object> costCompanyMap, BigDecimal coefficient, String fieldkey) {
        DynamicObjectCollection mainDynamicCo = coefficientInfo.getDynamicObjectCollection("entryentity");
        block0: for (DynamicObject mainDynamicbb : mainDynamicCo) {
            long tasktype = mainDynamicbb.getLong("tasktype_id");
            if (tasktype != taskTypeId) continue;
            DynamicObjectCollection mainCollection = mainDynamicbb.getDynamicObjectCollection("subentryentity");
            for (DynamicObject dimensionEntryDynamic : mainCollection) {
                Long expenseid;
                Long fieldKey = (Long)costCompanyMap.get("fieldKey");
                if (!fieldKey.equals(expenseid = Long.valueOf(dimensionEntryDynamic.getLong(fieldkey)))) continue;
                coefficient = dimensionEntryDynamic.getBigDecimal("coefficientssub");
                continue block0;
            }
        }
        return coefficient;
    }

    public static Map<String, Object> getNextField(String bindBillNumber, Long billTypeId) {
        HashMap<String, Object> costCompanyMap = new HashMap<String, Object>();
        ORM orm = ORM.create();
        DynamicObject bill = orm.getById(bindBillNumber, (Object)billTypeId);
        if (bill != null) {
            DynamicObjectCollection billCollection = bill.getDynamicObjectCollection("entryentity");
            DynamicObject billObject = (DynamicObject)billCollection.get(0);
            Object field = billObject.get("expenseitem");
            costCompanyMap.put("fieldKey", field);
        }
        return costCompanyMap;
    }

    public static DynamicObject getErpNumber(Long billTypeId) {
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number,bindbill.id,bindbill.number,bindbill.name", new QFilter[]{new QFilter("id", "=", (Object)billTypeId)});
        return billType;
    }

    public static DynamicObjectCollection getTaskInfo(long tasktypeid, long billtypeid) {
        ORM orm = ORM.create();
        QFilter f = new QFilter("billtype", "=", (Object)billtypeid);
        QFilter h = new QFilter("tasktypeid", "=", (Object)tasktypeid);
        DynamicObjectCollection dataset = orm.query("task_task", new QFilter[]{f, h});
        return dataset;
    }
}

