/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.orgchange;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgChangeCheckDetail;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BaseDataServiceHelper {
    private static final Log log = LogFactory.getLog(BaseDataServiceHelper.class);
    private static final String ENTITY_BIZAPP = "bos_devportal_bizapp";
    private static final String ENTITY_BDDEFCTRLSTRTGY = "bd_bddefctrlstrtgy";
    private static final String APP_SSC = "ssc";
    private static final String APP_SOM = "som";

    public List<OrgChangeCheckDetail> changeRootOrgBdUp(long oldRootId, long newRootId) {
        log.info("changeRootOrgBdUp start\uff1aoldRootId = {}, newRootId = {}", (Object)oldRootId, (Object)newRootId);
        ArrayList<OrgChangeCheckDetail> checkDetails = new ArrayList<OrgChangeCheckDetail>(16);
        List<DynamicObject> allAppList = this.getAllApp(Arrays.asList(APP_SSC, APP_SOM));
        List<String> allDefCtrlEntityList = this.getAllDefCtrlEntity(allAppList);
        for (String entityId : allDefCtrlEntityList) {
            try {
                this.doCheckDetails(oldRootId, entityId, checkDetails);
            }
            catch (Exception e) {
                log.error("changeRootOrgBdUp error\uff1aentityId =" + entityId, (Throwable)e);
            }
        }
        log.info("changeRootOrgBdUp end\uff1aoldRootId = {}, newRootId = {}", (Object)oldRootId, (Object)newRootId);
        return checkDetails;
    }

    private void doCheckDetails(long oldRootId, String entityId, List<OrgChangeCheckDetail> checkDetails) {
        String selectFields = "id,number,ctrlstrategy";
        QFilter orgFilter = new QFilter("createorg", "=", (Object)oldRootId);
        QFilter csFilter = new QFilter("ctrlstrategy", "!=", (Object)CtrlStrategyEnum.PRIVATE.getCtrlStrategy());
        DynamicObjectCollection dataDos = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{orgFilter, csFilter});
        if (!CollectionUtils.isEmpty((Collection)dataDos)) {
            log.info("changeRootOrgBdUp \uff1aentityId = {}, size = {}", (Object)entityId, (Object)dataDos.size());
            for (DynamicObject dataDo : dataDos) {
                OrgChangeCheckDetail assistantCheckDetail = new OrgChangeCheckDetail();
                assistantCheckDetail.setEntity(entityId);
                assistantCheckDetail.setBdNumber(dataDo.getString("number"));
                assistantCheckDetail.setReason(ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u7ef4\u62a4\u7684\u975e\u79c1\u6709\u6570\u636e", (String)"BaseDataServiceHelper_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                assistantCheckDetail.setSolution(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u65e7\u6839\u7ec4\u7ec7\u521b\u5efa\u7684\u975e\u79c1\u6709\u6570\u636e\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u4e1a\u52a1\u5224\u65ad\u662f\u5426\u9700\u8981\u8f6c\u8ba9\u3002\u53ef\u901a\u8fc7\u624b\u5de5\u3010\u7ba1\u7406\u6743\u8f6c\u8ba9\u3011\u8fdb\u884c\u5904\u7406", (String)"BaseDataServiceHelper_2", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                checkDetails.add(assistantCheckDetail);
            }
        } else {
            log.info("changeRootOrgBdUp \uff1aentityId = {}, size = {}", (Object)entityId, (Object)0);
        }
    }

    private List<DynamicObject> getAllApp(List<String> standardAppList) {
        ArrayList<DynamicObject> allAppList = new ArrayList<DynamicObject>();
        QFilter numberFilter = new QFilter("number", "in", standardAppList);
        DynamicObject[] standardApps = BusinessDataServiceHelper.load((String)ENTITY_BIZAPP, (String)"id,number,name", (QFilter[])new QFilter[]{numberFilter});
        if (standardApps != null && standardApps.length != 0) {
            for (DynamicObject standardApp : standardApps) {
                allAppList.add(standardApp);
                String standardAppid = standardApp.getString("id");
                String standardAppNumber = standardApp.getString("number");
                ArrayList<DynamicObject> childAppList = new ArrayList<DynamicObject>();
                this.getChildApp(standardAppid, childAppList);
                if (!CollectionUtils.isEmpty(childAppList)) {
                    allAppList.addAll(childAppList);
                }
                log.info("standardAppNumber = {}, childApp size = {}", (Object)standardAppNumber, (Object)childAppList.size());
            }
        }
        log.info("allApp size = {}", (Object)allAppList.size());
        return allAppList;
    }

    private void getChildApp(String standardAppid, List<DynamicObject> childAppList) {
        QFilter parentIdFilter = new QFilter("parentid", "=", (Object)standardAppid);
        DynamicObject[] childApps = BusinessDataServiceHelper.load((String)ENTITY_BIZAPP, (String)"id,number,name", (QFilter[])new QFilter[]{parentIdFilter});
        if (childApps != null && childApps.length != 0) {
            for (DynamicObject extApp : childApps) {
                childAppList.add(extApp);
                String extAppid = extApp.getString("id");
                this.getChildApp(extAppid, childAppList);
            }
        }
    }

    private List<String> getAllDefCtrlEntity(List<DynamicObject> allAppList) {
        List appIdList;
        QFilter entityFilter;
        DynamicObject[] bdCtrlStrtgyDos;
        ArrayList<String> allDefCtrlEntityList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(allAppList) && (bdCtrlStrtgyDos = BusinessDataServiceHelper.load((String)ENTITY_BDDEFCTRLSTRTGY, (String)"basedataid.number,appsystem.id", (QFilter[])new QFilter[]{entityFilter = new QFilter("appsystem.id", "in", appIdList = allAppList.stream().map(p -> (String)p.get("id")).collect(Collectors.toList()))})) != null && bdCtrlStrtgyDos.length != 0) {
            for (DynamicObject bdCtrlStrtgyDo : bdCtrlStrtgyDos) {
                String entityId = bdCtrlStrtgyDo.getString("basedataid.number");
                allDefCtrlEntityList.add(entityId);
            }
        }
        log.info("allDefCtrlEntity size = {}", (Object)allDefCtrlEntityList.size());
        return allDefCtrlEntityList;
    }
}

