/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AchieveIndicatorClassifyUpgradeServiceImpl
implements IUpgradeService {
    private static Map<Long, Long> idNewKindMap = new HashMap<Long, Long>(4);
    private static final Set<Long> PRESET_ACHIEVE;
    private static final String AIGO_KEY = "fi.ssc.AchieveIndicatorClassifyUpGradeServiceImpl";
    private static final String QUERY_SQL = "select fid,fparentid from t_tk_achievetarget";
    private static final String UPDATE_KIND_ORG = "update t_tk_achievekind set fcreateorgid = ? where fid in (1716567382384048128,1716567142503413760,1716564493422703616,1716566900206860288)";
    private static final String UPDATE_ACHIEVE_TARGET_GROUP = "update t_tk_achievetarget set fgroupid = ? where fid = ?";
    private static final String DEL_PRESET_ACHIEVE_STARTEGY = "delete from t_tk_achievetarget_u where fdataid in (1266614852818883584,1266616596860818432,1266602771419812864,1266610778916574208)";
    private static final String INSERT_PRESET_ACHIEVE_STRATEGY = "insert into t_tk_achievetarget_u(fdataid,fuseorgid) values(?,?)";
    private static final String UPDATE_PRESET_ACHIEVE_STRATEGY = "update t_tk_achievetarget set fctrlstrategy = '5',fcreateorgid = ? where fid in (1266614852818883584,1266616596860818432,1266602771419812864,1266610778916574208)";
    private static final String DELETE_PRESET_ACHIEVE = "delete from t_tk_achievetarget where fid in (1265197028707835904,1265198320863844352,1265197756159531008,1265197999445942272)";
    private static final String DELETE_PRESET_ACHIEVE_STRATWGY = "delete from t_tk_achievetarget_u where fdataid in (1265197028707835904,1265198320863844352,1265197756159531008,1265197999445942272)";
    private static final String DELETE_PRESET_ACHIEVE_L = "delete from t_tk_achievetarget_l where fid in (1265197028707835904,1265198320863844352,1265197756159531008,1265197999445942272)";
    private static final String DEL_ACHIEVETARGET_USEREG = "delete from t_tk_achievetargetusereg where fdataid in (1266614852818883584, 1266616596860818432, 1266602771419812864, 1266610778916574208)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap idParentMap = new HashMap();
        DataSet ds = DB.queryDataSet((String)AIGO_KEY, (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_SQL);
        Object object = null;
        try {
            ds.forEach(row -> {
                Long parentId;
                Long newGroupId;
                Long fid = row.getLong("fid");
                if (!idNewKindMap.containsKey(fid) && (newGroupId = idNewKindMap.get(parentId = row.getLong("fparentid"))) != null) {
                    idParentMap.put(fid, newGroupId);
                }
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(idParentMap.size());
        for (Map.Entry entry : idParentMap.entrySet()) {
            Object[] obj = new Object[]{entry.getValue(), entry.getKey()};
            paramList.add(obj);
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        long l = OrgUnitServiceHelper.getRootOrgId();
        ArrayList<Object[]> params = new ArrayList<Object[]>(4);
        for (Long fdataid : PRESET_ACHIEVE) {
            Object[] obj = new Object[]{fdataid, l};
            params.add(obj);
        }
        StringBuilder sb = new StringBuilder();
        try (TXHandle txHandle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_KIND_ORG, (Object[])new Object[]{l});
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_ACHIEVE_TARGET_GROUP, paramList);
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)DEL_PRESET_ACHIEVE_STARTEGY, (Object[])new Object[0]);
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)INSERT_PRESET_ACHIEVE_STRATEGY, params);
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_PRESET_ACHIEVE_STRATEGY, (Object[])new Object[]{l});
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)DELETE_PRESET_ACHIEVE, (Object[])new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)DELETE_PRESET_ACHIEVE_L, (Object[])new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)DELETE_PRESET_ACHIEVE_STRATWGY, (Object[])new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)DEL_ACHIEVETARGET_USEREG, (Object[])new Object[0]);
        }
        upgradeResult.setLog(sb.toString());
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }

    static {
        idNewKindMap.put(1265197028707835904L, 1716567382384048128L);
        idNewKindMap.put(1265198320863844352L, 1716567142503413760L);
        idNewKindMap.put(1265197756159531008L, 1716564493422703616L);
        idNewKindMap.put(1265197999445942272L, 1716566900206860288L);
        PRESET_ACHIEVE = new HashSet<Long>(Arrays.asList(1266614852818883584L, 1266616596860818432L, 1266602771419812864L, 1266610778916574208L));
    }
}

