/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.workbill.fieldcfg.TextAreaFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.TextFieldCfg;

public class WorkBillFieldPropertyUpgradeServiceImpl
implements IUpgradeService {
    private static final String QUERY_FIELD_ENTRY = "select fdetailid,ffieldtype,ffieldpropertyjson_tag from t_tk_field_subentry where ffieldtype in('Text','TextArea') order by fdetailid";
    private static final String UPDATE_PROPERTY_SQL = "update t_tk_field_subentry set ffieldproperty = ?, ffieldpropertyjson_tag = ? where fdetailid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String algoKey = this.getClass() + ".beforeExecuteSqlWithResult()";
        try (TXHandle h = TX.requiresNew((String)"ssc_task_work_bill_field_property_upgrade");){
            try {
                this.workBillFieldPropertyUpgrade(algoKey);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setErrorInfo(e.getMessage());
                result.setLog(ResManager.loadKDString((String)"\u5de5\u5355\u5b57\u6bb5\u5c5e\u6027\u53d8\u66f4\u8bb0\u5f55\u5347\u7ea7\u5931\u8d25", (String)"WorkBillFieldPropertyUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
                result.setSuccess(false);
            }
        }
        result.setLog(ResManager.loadKDString((String)"\u5de5\u5355\u5b57\u6bb5\u5c5e\u6027\u53d8\u66f4\u8bb0\u5f55\u5347\u7ea7\u6210\u529f", (String)"WorkBillFieldPropertyUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        result.setSuccess(true);
        return result;
    }

    private void workBillFieldPropertyUpgrade(String algoKey) {
        try (DataSet dataSet = DB.queryDataSet((String)(algoKey + "_0"), (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_FIELD_ENTRY);){
            ArrayList<Object[]> params = new ArrayList<Object[]>(1100);
            for (Row row : dataSet) {
                Long fdetailid = row.getLong("fdetailid");
                String ffieldtype = row.getString("ffieldtype");
                String ffieldpropertyjsonTag = row.getString("ffieldpropertyjson_tag");
                TextFieldCfg textFieldCfg = ffieldtype.equals("Text") ? new TextFieldCfg() : new TextAreaFieldCfg();
                int maxLength = textFieldCfg.getMaxLength();
                if (StringUtils.isEmpty((String)ffieldpropertyjsonTag)) {
                    ffieldpropertyjsonTag = JSON.toJSONString((Object)textFieldCfg);
                } else {
                    JSONObject jsonObject = JSON.parseObject((String)ffieldpropertyjsonTag);
                    maxLength = jsonObject.getIntValue("maxLength");
                    if (maxLength == 0) {
                        maxLength = textFieldCfg.getMaxLength();
                        jsonObject.put("maxLength", (Object)maxLength);
                        ffieldpropertyjsonTag = jsonObject.toJSONString();
                    }
                }
                String fieldProperty = String.format(ResManager.loadKDString((String)"\u957f\u5ea6%s", (String)"WorkBillFieldPropertyUpgradeServiceImpl_2", (String)"ssc-task-upgradeservice", (Object[])new Object[0]), maxLength);
                params.add(new Object[]{fieldProperty, ffieldpropertyjsonTag, fdetailid});
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_PROPERTY_SQL, params);
                params.clear();
            }
            if (params.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_PROPERTY_SQL, params);
            }
        }
    }
}

