/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import kd.sys.ricc.common.util.setter.D;

public class IscUtil {
    public static final String STRING = "string";
    public static final String INTEGER = "integer";

    private IscUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String mur32(Object ... values) {
        String s = IscUtil.toString(values);
        int h = IscUtil.hash(ByteBuffer.wrap(s.getBytes(D.UTF_8)), 1937006962);
        return Integer.toHexString(h).toUpperCase();
    }

    public static int hash(ByteBuffer buf, int seed) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int m = 1540483477;
        int r = 24;
        int h = seed ^ buf.remaining();
        while (buf.remaining() >= 4) {
            int k = buf.getInt();
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getInt();
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        buf.order(byteOrder);
        return h;
    }

    public static String toString(Object ... values) {
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            Object v = values[0];
            return v == null ? "" : v.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (Object v : values) {
            sb.append(v).append('\n');
        }
        return sb.toString();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return D.s(value) == null;
        }
        if (value instanceof Number) {
            return D.l(value) == 0L;
        }
        return false;
    }

    public static String formatDataType(String type) {
        String transType = null;
        switch (type = type.trim().toLowerCase(Locale.ENGLISH)) {
            case "string": {
                transType = STRING;
                break;
            }
            case "ilocalestring": {
                transType = STRING;
                break;
            }
            case "int": {
                transType = INTEGER;
                break;
            }
            case "integer": {
                transType = INTEGER;
                break;
            }
            case "long": {
                transType = "long";
                break;
            }
            case "boolean": {
                transType = "boolean";
                break;
            }
            case "date": {
                transType = "datetime";
                break;
            }
            case "bigdecimal": {
                transType = "decimal";
                break;
            }
            case "double": {
                transType = "double";
                break;
            }
            case "dynamicobject": {
                transType = "REF";
                break;
            }
            case "entrytype": {
                transType = "ENTRY";
                break;
            }
            default: {
                transType = type;
            }
        }
        return transType;
    }
}

