/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class VchtemplateImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(VchtemplateImpl.class);
    private static final String PROCESS_CLASS = "kd.fi.ai.util.DapFileUtil";
    public static final String ORG = "org";

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        sdpOutputParams.setExportFilePath("");
        if (sdpInputParams == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"VchtemplateImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        Map customParam = sdpInputParams.getParam();
        String entityName = (String)customParam.get("entityname");
        Map inputParam = (Map)customParam.get("custparam");
        Object org = inputParam.get(ORG);
        if (org == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u83b7\u53d6\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u5931\u8d25\uff01", (String)"VchtemplateImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]));
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        Long orgId = Long.parseLong(org.toString());
        int hasExportPermission = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)"iep", (String)"ai_vchtemplate", (String)"4730fc9f000004ae");
        if (hasExportPermission != 1) {
            String permTips = ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u6a21\u677f\u7684\u5bfc\u51fa\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5", (String)"VchtemplateImpl_7", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(permTips);
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        Map resMap = CommonUtil.getLongArrByRowCollection((ListSelectedRowCollection)sdpInputParams.getSelectRows(), (String)entityName);
        long[] selectedIds = (long[])resMap.get("ids");
        sdpOutputParams.setSelectedInfo((String)resMap.get("selectedInfo"));
        Class clazz = TypesContainer.getOrRegister((String)PROCESS_CLASS);
        Method method = null;
        try {
            method = clazz.getMethod("exportTemplate", String.class, long[].class);
            Map result = (Map)method.invoke(clazz.newInstance(), sdpInputParams.getLocalPath(), selectedIds);
            Object errMessage = result.get("error");
            if (StringUtils.isNotBlank(errMessage)) {
                sdpOutputParams.append(errMessage.toString());
            } else {
                sdpOutputParams.setExportFilePath((String)result.get("fileName"));
            }
        }
        catch (Exception e) {
            logger.error("\u51ed\u8bc1\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\u3002", (Throwable)e);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\u3002%1$s", (String)"VchtemplateImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e)), (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)sdpInputParams.getSelectRows().size(), (int)sdpInputParams.getSelectRows().size());
        return sdpOutputParams;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        int hasExportPermission;
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        sdpOutputParams.setSuccess(false);
        String fileUrl = (String)sdpInputParams.getParam().get("fileUrl");
        Map custParam = (Map)sdpInputParams.getParam().get("custparam");
        if (custParam.isEmpty()) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\uff01", (String)"VchtemplateImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        Object org = custParam.get(ORG);
        if (org == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u83b7\u53d6\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u5931\u8d25\uff01", (String)"VchtemplateImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        Object orgNumber = custParam.get("org_number");
        Long orgId = this.getOrgId(org, orgNumber);
        if (orgId == 0L) {
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e\u7684\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u5728\u5f53\u524d\u7cfb\u7edf\u627e\u4e0d\u5230\u6216\u8005\u4e0d\u7b26\u5408\u51ed\u8bc1\u6a21\u677f\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u8fc7\u6ee4\u6761\u4ef6\uff0c\u7ec4\u7ec7id\uff1a%1$s\uff0c\u7ec4\u7ec7\u7f16\u7801\uff1a%2$s", (String)"VchtemplateImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]), org, orgNumber));
            return sdpOutputParams;
        }
        int hasViewPermission = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)"iep", (String)"ai_vchtemplate", (String)"47150e89000000ac");
        HashSet<String> noPermissionItemName = new HashSet<String>(2);
        if (hasViewPermission != 1) {
            noPermissionItemName.add(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"VchtemplateImpl_8", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        if ((hasExportPermission = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)"iep", (String)"ai_vchtemplate", (String)"4730fc9f000003ae")) != 1) {
            noPermissionItemName.add(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"VchtemplateImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        if (!noPermissionItemName.isEmpty()) {
            String msgTpl = ResManager.loadKDString((String)"\u6ca1\u6709\u51ed\u8bc1\u6a21\u677f\u7684%s\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5", (String)"VchtemplateImpl_10", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(msgTpl, noPermissionItemName));
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String tempFileUrl = FileUtils.getTempUrlFormFileUrl((String)fileUrl, (int)0);
        Class clazz = TypesContainer.getOrRegister((String)PROCESS_CLASS);
        Method method = null;
        try {
            method = clazz.getMethod("uploadRule", String.class, Long.class);
            Map result = (Map)method.invoke(clazz.newInstance(), tempFileUrl, orgId);
            Object errMessage = result.get("ERROR");
            if (StringUtils.isNotBlank(errMessage)) {
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\uff0c%s", (String)"VchtemplateImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]), errMessage.toString()));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("\u51ed\u8bc1\u6a21\u677f\u5bfc\u5165\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            sdpOutputParams.append(e.getMessage(), (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    private long getOrgId(Object org, Object orgNumber) {
        ArrayList orgIdList;
        Long orgId = Long.parseLong(org.toString());
        QFilter vchFilter = this.getVchFilter();
        if (vchFilter != null && (orgIdList = (ArrayList)vchFilter.getValue()).contains(orgId)) {
            logger.info(String.format("\u5bfc\u5165\u51ed\u8bc1\u6a21\u677f\u901a\u8fc7id\u627e\u5230\u7ec4\u7ec7\u4fe1\u606f\uff0cid\u4e3a\uff1a%s", orgId));
            return orgId;
        }
        QFilter qFilter = new QFilter("number", "=", orgNumber);
        qFilter.and(vchFilter);
        DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id,number", (QFilter[])qFilter.toArray());
        if (orgInfo != null) {
            logger.info(String.format("\u5bfc\u5165\u51ed\u8bc1\u6a21\u677f\u901a\u8fc7\u7f16\u7801\u627e\u5230\u7ec4\u7ec7\u4fe1\u606f\uff0c\u7f16\u7801\u4e3a\uff1a%s", orgNumber));
            return orgInfo.getLong("id");
        }
        return 0L;
    }

    private QFilter getVchFilter() {
        QFilter qFilter = null;
        try {
            Class clazz = TypesContainer.getOrRegister((String)"kd.fi.ai.formplugin.ImportVchTemplatePlugin");
            Method method = clazz.getMethod("beforeF7Select", BeforeF7SelectEvent.class);
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(ORG);
            BeforeF7SelectEvent beforeF7SelectEvent = new BeforeF7SelectEvent(fieldEdit, 0, null);
            beforeF7SelectEvent.setFormShowParameter((FormShowParameter)new ListShowParameter());
            method.invoke(clazz.newInstance(), beforeF7SelectEvent);
            beforeF7SelectEvent.getCustomQFilters();
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            List qfilterList = filterParam.getQFilters();
            qFilter = (QFilter)qfilterList.get(0);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("\u83b7\u53d6\u51ed\u8bc1\u6a21\u677f\u754c\u9762\u70b9\u51fb\u5bfc\u5165\u65f6\u9009\u62e9\u7ec4\u7ec7\u7684\u8fc7\u6ee4\u6761\u4ef6\u51fa\u9519\u3002", (Throwable)e);
        }
        return qFilter;
    }
}

