/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class WFModelImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(WFModelImpl.class);
    private final DcxmlSerializer serializer = new DcxmlSerializer(DeployModel.getDCBinder());
    private static final String WFMODEL_NUMBER = "key";

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u8ba1 \u5bfc\u51fa\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"WFModelImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "wf", "wf_model", this.getModelName(), sdpOutputParams, "4730fc9f000004ae");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        Map param = sdpInputParams.getParam();
        String entityName = (String)param.get("entityname");
        String entityNumber = (String)param.get("entitynumber");
        ListSelectedRowCollection rows = sdpInputParams.getSelectRows();
        if (rows.isEmpty()) {
            String filters = DataPacketHelper.getFilters(param);
            rows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
        }
        int size = rows.size();
        String zipFilename = entityName + System.currentTimeMillis() + ".zip";
        String fullPath = sdpInputParams.getLocalPath() + File.separator + zipFilename;
        File zipFile = FileUtils.createFile((String)kd.bos.util.FileUtils.checkFileUrl((String)fullPath));
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        ArrayList<Long> errorDataIds = new ArrayList<Long>();
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            int i = 1;
            for (ListSelectedRow row : rows) {
                selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i++, row.getNumber(), row.getName()));
                long id = (Long)row.getPrimaryKeyValue();
                DeployFile deployFile = null;
                try {
                    deployFile = this.getRepositoryService().getDeployModel(id);
                }
                catch (Exception e) {
                    errorDataIds.add(id);
                    String errorMsg = String.format(ResManager.loadKDString((String)"%1$s%2$s\u5bfc\u51fa\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%3$s", (String)"WFModelImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), entityName, id, CommonUtil.getExceptionDetailInfo((Throwable)e));
                    sdpOutputParams.getDevError().append(errorMsg);
                    logger.error(errorMsg);
                }
                if (errorDataIds.isEmpty() && deployFile != null) {
                    DataPacketHelper.exportWfToZipFile(out, deployFile);
                }
                ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)size, (int)i);
            }
            sdpOutputParams.setSuccess(true);
        }
        catch (Exception e) {
            sdpOutputParams.setSuccess(false);
            String msg = String.format(CommonConstant.getExportFileErrorTip(), entityName);
            sdpOutputParams.append(msg, (Throwable)e);
            logger.error(msg, (Throwable)e);
        }
        if (!errorDataIds.isEmpty()) {
            sdpOutputParams.setSuccess(false);
            ArrayList errModelNumbers = new ArrayList();
            DynamicObjectCollection errModels = QueryServiceHelper.query((String)"wf_model", (String)WFMODEL_NUMBER, (QFilter[])new QFilter("id", "in", errorDataIds).toArray());
            errModels.forEach(errModel -> errModelNumbers.add(errModel.getString(WFMODEL_NUMBER)));
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"%1$s\u53ef\u80fd\u5b58\u5728\u810f\u6570\u636e\u5bfc\u81f4\u5bfc\u51fa\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770bmonitor\u65e5\u5fd7\u8fdb\u884c\u6392\u67e5\uff0c\u5f02\u5e38\u6570\u636eid\uff1a%2$s, \u5bf9\u5e94\u6d41\u7a0b\u8bbe\u8ba1\u7f16\u7801\uff1a%3$s", (String)"WFModelImpl_2", (String)"sys-ricc-business", (Object[])new Object[0]), entityName, ((Object)errorDataIds).toString(), ((Object)errModelNumbers).toString()));
        }
        sdpOutputParams.setSelectedInfo(selectedInfo.toString());
        if (sdpOutputParams.isSuccess()) {
            sdpOutputParams.setExportFilePath(zipFile.getAbsolutePath());
        }
        return sdpOutputParams;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        Map param = sdpInputParams.getParam();
        String fileUrl = (String)param.get("fileUrl");
        String zipFileName = (String)param.get("fileName");
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String entityName = guide.getString("name");
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "wf", "wf_model", this.getModelName(), sdpOutputParams, "47150e89000000ac", "4730fc9f000003ae");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        HashMap<String, String> procFileMap = new HashMap<String, String>(8);
        int successCount = 0;
        int total = 0;
        try (InputStream inputStream = fileService.getInputStream(fileUrl);
             ZipInputStream zipIn = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), Charset.forName("GBK"));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                ++total;
                String fileName = zipEntry.getName();
                if (!fileName.endsWith(".process")) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u542b\u6709\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\uff1a%2$s", (String)"WFModelImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]), zipFileName, fileName);
                    sdpOutputParams.append(msg);
                    continue;
                }
                String content = DataPacketHelper.getZipFileContent(zipIn);
                String errMsg = this.checkAndDeployModel(zipFileName, procFileMap, fileName, content);
                if (!StringUtils.isEmpty((String)errMsg)) {
                    sdpOutputParams.append(errMsg);
                    continue;
                }
                ++successCount;
            }
        }
        catch (Exception e) {
            sdpOutputParams.setSuccess(false);
            String msg = String.format(CommonConstant.getImportFileErrorTip(), entityName);
            sdpOutputParams.append(msg, (Throwable)e);
            logger.error(msg, (Throwable)e);
            return sdpOutputParams;
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("successCount", successCount);
        params.put("failedCount", total - successCount);
        sdpOutputParams.setParam(params);
        return sdpOutputParams;
    }

    private RepositoryService getRepositoryService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
    }

    private String checkAndDeployModel(String zipFileName, Map<String, String> procFileMap, String fileName, String content) {
        if (StringUtils.isEmpty((String)content)) {
            String msgTpl = ResManager.loadKDString((String)"%1$s: %2$s \u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"WFModelImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]);
            return String.format(msgTpl, zipFileName, fileName);
        }
        this.serializer.setColloctionIgnorePKValue(true);
        DeployModel deployModel = (DeployModel)this.serializer.deserializeFromString(content, null);
        if (deployModel == null) {
            String msgTpl = ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6 %s \u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u662f\u6709\u6548\u7684process\u6587\u4ef6\uff01", (String)"WFModelImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]);
            return String.format(msgTpl, fileName);
        }
        List models = deployModel.getModels();
        DynamicObject model = (DynamicObject)models.get(0);
        String wfModelNumber = model.getString(WFMODEL_NUMBER);
        String entrabill = model.getString("entrabill");
        String procFile = procFileMap.get(wfModelNumber);
        if (procFile != null) {
            return String.format(ResManager.loadKDString((String)"%1$s \u4e0e  %2$s\u4e2d\u7684%3$s\u6587\u4ef6\u4e2d\u7684\u6d41\u7a0b\u91cd\u590d\uff01", (String)"WFModelImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]), procFile, zipFileName, fileName);
        }
        procFileMap.put(wfModelNumber, String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684%2$s\u6587\u4ef6", (String)"WFModelImpl_7", (String)"sys-ricc-business", (Object[])new Object[0]), zipFileName, fileName));
        if (!QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entrabill)})) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e %s \u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165\uff01", (String)"WFModelImpl_8", (String)"sys-ricc-business", (Object[])new Object[0]), entrabill);
        }
        QFilter[] filters = new QFilter[]{new QFilter(WFMODEL_NUMBER, "=", (Object)wfModelNumber), new QFilter("entrabill", "!=", (Object)entrabill)};
        if (QueryServiceHelper.exists((String)"wf_model", (QFilter[])filters)) {
            return String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u7f16\u7801\u4e3a %s \u7684\u5176\u4ed6\u5355\u636e\u6d41\u7a0b\uff0c\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"WFModelImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]), wfModelNumber);
        }
        ImportExportProcessUtil.checkProcessTypeConsistent((String)wfModelNumber, (String)model.getString("type"), (boolean)false);
        QFilter[] qFilters = new QFilter[]{new QFilter(WFMODEL_NUMBER, "=", (Object)wfModelNumber)};
        boolean isCover = QueryServiceHelper.exists((String)"wf_model", (QFilter[])qFilters);
        boolean isCoverSummaryCfg = true;
        this.getRepositoryService().deployModel(deployModel, isCover, Boolean.valueOf(isCoverSummaryCfg));
        WfUtils.addLog((String)"wf_model", (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6d41\u7a0b", (String)"WFModelImpl_10", (String)"sys-ricc-business", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u6d41\u7a0bID: %1$s \u7f16\u7801: %2$s", (String)"WFModelImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]), String.valueOf(((DynamicObject)models.get(0)).getPkValue()), wfModelNumber));
        return null;
    }

    private String getModelName() {
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u8bbe\u8ba1", (String)"WFModelImpl_12", (String)"sys-ricc-business", (Object[])new Object[0]);
    }
}

