/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.business.configitem.check.ConfigCheck;
import kd.sys.ricc.exception.RiccBizException;

public abstract class AbstractConfigCheckItem
implements ConfigCheck {
    private static final Log logger = LogFactory.getLog(AbstractConfigCheckItem.class);
    private static final DBRoute SYS_DB_ROUTE = DBRoute.of((String)"sys");
    private Long checkItemId;
    private List<Long> excludeConfigItemIds;
    private String checkResult;
    private String log = "";

    public Long getCheckItemId() {
        return this.checkItemId;
    }

    public void setCheckItemId(Long checkItemId) {
        this.checkItemId = checkItemId;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public List<Long> getExcludeConfigItemIds() {
        return this.excludeConfigItemIds;
    }

    public void setExcludeConfigItemIds(List<Long> excludeConfigIds) {
        this.excludeConfigItemIds = excludeConfigIds;
    }

    public String getCheckResult() {
        return this.checkResult;
    }

    public void setCheckResult(String checkResult) {
        this.checkResult = checkResult;
    }

    public boolean isSkip(DynamicObject configItem) {
        long configId = (Long)configItem.getPkValue();
        return this.getExcludeConfigItemIds().contains(configId);
    }

    @Override
    public void execute(DynamicObject configItem, String taskNo, long checkBillId, int seq) {
        try {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
            paramsMap.put("excludeConfigIds", this.getExcludeConfigItemIds());
            paramsMap.put("configItem", configItem);
            paramsMap.put("taskNo", taskNo);
            if (this.isSkip(configItem)) {
                this.setCheckResult("ignore");
                this.setLog(ResManager.loadKDString((String)"\u8be5\u68c0\u67e5\u9879\u8df3\u8fc7\u8be5\u914d\u7f6e\u9879\uff0c\u65e0\u987b\u68c0\u67e5\u3002", (String)"AbstractConfigCheckItem_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            } else {
                this.doAction(paramsMap);
            }
        }
        catch (Exception e) {
            logger.error("\u5065\u5eb7\u68c0\u67e5\u4efb\u52a1\u5206\u5f55\u65e5\u5fd7\uff1a", (Throwable)e);
            this.setCheckResult("failed");
            this.setLog(e.toString());
        }
        this.report(configItem, checkBillId, seq);
    }

    public void doAction(Map<String, Object> paramsMap) {
    }

    private void report(DynamicObject configItem, long checkBillId, int seq) {
        long entryId = DB.genLongId((String)"t_ricc_configchecklogs");
        String entryLog = this.getLog();
        int logMaxSize = 500;
        if (entryLog.length() > logMaxSize) {
            entryLog = this.getLog().substring(0, logMaxSize);
        }
        Object[] params = new Object[]{checkBillId, entryId, seq, this.getCheckItemId(), configItem.getPkValue(), this.getCheckResult(), entryLog};
        String entrySql = "INSERT INTO T_RICC_CONFIGCHECKLOGS (FID, FENTRYID, FSEQ, FLOG_CHECKITEM, FLOG_CONFIGITEM, FCHECKRESULT, FLOG) values (?, ?, ?, ?, ?, ?, ?);";
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)SYS_DB_ROUTE, (String)entrySql, (Object[])params);
                this.setLog("");
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw new RiccBizException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

