/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.sys.ricc.business.configitem.check.AbstractConfigCheckItem;

public class ConfigCheckProcessor {
    private List<AbstractConfigCheckItem> checkItems;
    private int seq = 0;

    public List<AbstractConfigCheckItem> getCheckItems() {
        return this.checkItems;
    }

    private void setCheckItems(List<AbstractConfigCheckItem> checkItems) {
        this.checkItems = checkItems;
    }

    public static ConfigCheckProcessor build(DynamicObject configCheckBill) {
        ConfigCheckProcessor checkProcessor = new ConfigCheckProcessor();
        DynamicObjectCollection checkItemEntry = configCheckBill.getDynamicObjectCollection("checkitem_entry");
        ArrayList<AbstractConfigCheckItem> checkItemList = new ArrayList<AbstractConfigCheckItem>(checkItemEntry.size());
        for (DynamicObject entry : checkItemEntry) {
            DynamicObject checkItem = entry.getDynamicObject("task_checkitems");
            String plugin = checkItem.getString("impl");
            AbstractConfigCheckItem configCheckItem = (AbstractConfigCheckItem)TypesContainer.createInstance((String)plugin);
            configCheckItem.setCheckItemId(checkItem.getLong("id"));
            DynamicObjectCollection excludeConfig = entry.getDynamicObjectCollection("excludeconfigs");
            List<Long> excludeConfigIds = excludeConfig.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
            configCheckItem.setExcludeConfigItemIds(excludeConfigIds);
            checkItemList.add(configCheckItem);
        }
        checkProcessor.setCheckItems(checkItemList);
        return checkProcessor;
    }

    public void check(DynamicObject configItem, String taskNo, long checkBillId) {
        for (AbstractConfigCheckItem checkItem : this.getCheckItems()) {
            if (this.isSuspend(checkBillId)) {
                return;
            }
            checkItem.execute(configItem, taskNo, checkBillId, this.seq);
            ++this.seq;
        }
    }

    private boolean isSuspend(long checkBillId) {
        String suspendKey = "ITEMCHECK_SUSPEND_" + checkBillId;
        return AppCache.get((String)"ricc").get(suspendKey, String.class) != null;
    }
}

