/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.microservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.impl.microservice.MicroServiceHandler;
import kd.sys.ricc.business.datapacket.core.impl.microservice.MicroServiceParam;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.FileTransferType;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class MicroServiceImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(MicroServiceImpl.class);
    public static final String EXPORT_PACKET = "exportPacket";
    public static final String IMPORT_PACKET = "importPacket";
    public static final String CLOUD = "cloud";
    public static final String APP_ID = "appid";
    public static final String SERVICE_NAME = "servicename";
    public static final String BATCH_COUNT = "batchcount";
    public static final String PARAMS = "params";
    private final MicroServiceHandler microServiceHandler = new MicroServiceHandler();
    public static final String BYTE_ARR = "byte_arr";

    private String getMicroFail() {
        return ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5206\u6279\u5904\u7406\u6570\u636e\u51fa\u9519\uff0c\u6279\u6b21\u7f16\u53f7\uff1a%s\uff0c\u9519\u8bef\u539f\u56e0\uff1a", (String)"MicroServiceImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    @Override
    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        ListSelectedRowCollection selectedRows = sdpInputParams.getSelectRows();
        Map<String, Object> param = sdpInputParams.getParam();
        String entityNumber = (String)param.get("entitynumber");
        String entityName = (String)param.get("entityname");
        if (selectedRows.isEmpty()) {
            logger.info("\u5fae\u670d\u52a1\u65b9\u5f0f\u6279\u91cf\u6253\u5305\u5bfc\u51fa\u6570\u636e\u5f00\u59cb");
            String filters = DataPacketHelper.getFilters(param);
            logger.info("\u5fae\u670d\u52a1\u6279\u91cf\u6253\u5305\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)filters);
            selectedRows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
            if (selectedRows.isEmpty()) {
                sdpOutputParams.setSuccess(false);
                sdpOutputParams.append(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa", (String)"MicroServiceImpl_18", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return sdpOutputParams;
            }
        }
        logger.info(String.format("%s\u5fae\u670d\u52a1\u6253\u5305\u67e5\u8be2\u7684\u6570\u636eid\u4e3a\uff1a{}", entityNumber), selectedRows.getPrimaryKeyValues());
        int totalSize = selectedRows.size();
        String serviceConfig = (String)param.get("serviceconfig");
        JSONObject obj = JSON.parseObject((String)serviceConfig);
        int batchCount = obj.getIntValue(BATCH_COUNT);
        String fileTransferType = obj.getString("filetransfertype");
        String custParamStr = obj.getString(PARAMS);
        MicroServiceParam microServiceParam = this.getMicroServiceParam(obj, EXPORT_PACKET);
        List splitList = BatchSplitUtil.splitBatch((List)selectedRows, (int)batchCount);
        HashMap<String, Object> microParamMap = new HashMap<String, Object>(5);
        microParamMap.put("entity_number", entityNumber);
        microParamMap.put("entity_name", entityName);
        microParamMap.put("file_transfer_type", fileTransferType);
        microParamMap.put(PARAMS, custParamStr);
        microServiceParam.setParas(microParamMap);
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        int successCount = 0;
        ArrayList relyBdList = new ArrayList(2);
        ArrayList multiDataList = new ArrayList(2);
        for (int i = 0; i < splitList.size(); ++i) {
            Map resultMap;
            List oneBatchList = (List)splitList.get(i);
            microParamMap.put("listSelectedRowList", oneBatchList);
            try {
                resultMap = (Map)this.microServiceHandler.execute(microServiceParam);
            }
            catch (Exception e) {
                sdpOutputParams.append(String.format(this.getMicroFail(), i + 1), e);
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            if (this.isRightMicroServiceParams(resultMap, EXPORT_PACKET, fileTransferType, sdpOutputParams)) {
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            int code = (Integer)resultMap.get("code");
            if (code != 0) {
                sdpOutputParams.append(String.format(this.getMicroFail(), i + 1) + resultMap.get("msg"), (String)resultMap.get("dev_msg"));
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            String localDir = sdpInputParams.getLocalPath();
            if (!this.getFileToLocal(localDir, sdpOutputParams, fileTransferType, resultMap, i)) {
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            List batchRelybdList = resultMap.getOrDefault("relybd_list", Collections.emptyList());
            relyBdList.addAll(batchRelybdList);
            List batchMultDataList = resultMap.getOrDefault("multidata_list", Collections.emptyList());
            multiDataList.addAll(batchMultDataList);
            ScheduleUtil.addPacketFeedbackProgress(addPacketProgress, totalSize, successCount += oneBatchList.size());
        }
        String selectedInfo = this.setBatchSelectedInfo(splitList, totalSize, entityName);
        sdpOutputParams.setSuccess(totalSize == successCount);
        if (sdpOutputParams.isSuccess()) {
            sdpOutputParams.setSelectedInfo(selectedInfo);
            String zipName = FileUtils.dirToZip((String)sdpInputParams.getLocalPath(), (String)entityName);
            sdpOutputParams.setExportFilePath(zipName);
            Map<String, Object> outputParams = sdpOutputParams.getParam();
            outputParams.put("relybd_list", relyBdList);
            outputParams.put("multidata_list", multiDataList);
        }
        ScheduleUtil.addPacketProgressComplete(addPacketProgress);
        return sdpOutputParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFileToLocal(String localDir, SdpOutputParams sdpOutputParams, String fileTransferType, Map<String, Object> resultMap, int i) {
        String fileName = System.currentTimeMillis() + "";
        InputStream fileInputStream = null;
        if (FileTransferType.TempFile.getValue().equals(fileTransferType)) {
            String exportUrl = (String)resultMap.get("export_url");
            TempFileCacheDownloadable.Content content = FileUtils.getCacheContentFromTempUrl((String)exportUrl);
            if (content == null) {
                sdpOutputParams.append(String.format(this.getMicroFail(), i + 1));
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u4ece\u4e34\u65f6\u6587\u4ef6\u5730\u5740\uff1a%s, \u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"MicroServiceImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]), exportUrl));
                sdpOutputParams.setSuccess(false);
                return false;
            }
            fileName = i + "_" + content.getFilename();
            fileInputStream = content.getInputStream();
        } else {
            byte[] byteArr = (byte[])resultMap.get(BYTE_ARR);
            String returnFileName = (String)resultMap.get("file_name");
            if (returnFileName != null) {
                fileName = i + "_" + FileUtils.getFileNameFromPath((String)returnFileName);
            }
            if (byteArr == null || byteArr.length == 0) {
                sdpOutputParams.append(String.format(this.getMicroFail(), i + 1));
                sdpOutputParams.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u4ece\u8fd4\u56de\u7684byte \u6570\u7ec4\u4e2d\u83b7\u53d6\u4e0d\u5230\u6587\u4ef6\u3002", (String)"MicroServiceImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                sdpOutputParams.setSuccess(false);
                return false;
            }
            fileInputStream = new ByteArrayInputStream(byteArr);
        }
        File tmp = FileUtils.createFile((String)(localDir + File.separator + fileName));
        try (FileOutputStream os = new FileOutputStream(tmp);){
            FileUtils.inputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)os);
        }
        catch (IOException e) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"%s\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"MicroServiceImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]), this.getMicroFail(), i + 1), e);
            sdpOutputParams.setSuccess(false);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5fae\u670d\u52a1\u6d41\u5173\u95ed\u5931\u8d25\u3002", (Throwable)e);
                }
            }
        }
        return true;
    }

    public String setBatchSelectedInfo(List<List<ListSelectedRow>> splitList, int totalSize, String entityName) {
        StringBuilder selectedInfo = new StringBuilder();
        int batchNum = 1;
        int serialNum = 1;
        boolean emptyName = false;
        for (List<ListSelectedRow> listSelectedRows : splitList) {
            selectedInfo.append(String.format(ResManager.loadKDString((String)"----\u5206\u6279\u6570\u636e\uff0c\u6279\u6b21\u7f16\u53f7\uff1a%s----%n", (String)"MicroServiceImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]), batchNum));
            for (ListSelectedRow listSelectedRow : listSelectedRows) {
                if (StringUtils.isEmpty((String)listSelectedRow.getNumber()) && StringUtils.isEmpty((String)listSelectedRow.getName())) {
                    selectedInfo.append(String.format("%s\t\t%s\t\t%n", serialNum++, listSelectedRow.getPrimaryKeyValue()));
                    emptyName = true;
                    continue;
                }
                selectedInfo.append(String.format("%s\t\t%s\t\t%s%n", serialNum++, listSelectedRow.getNumber(), listSelectedRow.getName()));
            }
            ++batchNum;
        }
        selectedInfo.insert(0, emptyName ? String.format("%1$s\t\t%2$sid%n", CommonConstant.getSerialNumTitle(), entityName) : String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        selectedInfo.insert(0, String.format(ResManager.loadKDString((String)"\u603b\u6570\u636e\uff1a%d\u6761%n", (String)"MicroServiceImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]), totalSize));
        return selectedInfo.toString();
    }

    public boolean isRightMicroServiceParams(Map<String, Object> resultMap, String method, String fileTransferType, SdpOutputParams sdpOutputParams) {
        if (resultMap == null || resultMap.isEmpty()) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002%1$s\u65b9\u6cd5\u9700\u8981\u8fd4\u56demap\u53c2\u6570\u4e3a%2$s", (String)"MicroServiceImpl_7", (String)"sys-ricc-platform", (Object[])new Object[0]), method, EXPORT_PACKET.equals(method) ? ResManager.loadKDString((String)"code,msg,export_url\uff08\u4f20\u8f93\u7c7b\u578b\u4e3a\u4e34\u65f6\u6587\u4ef6\u65f6\uff09\uff0cbyte_arr\uff08\u4f20\u8f93\u7c7b\u578b\u4e3abyte\u6570\u7ec4\u65f6\uff09", (String)"MicroServiceImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]) : "code,msg"));
            return true;
        }
        if (!resultMap.containsKey("code")) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u8fd4\u56de\u53c2\u6570\u5f02\u5e38\uff0c\u5fc5\u987b\u8fd4\u56decode\uff08\u5fae\u670d\u52a1\u6267\u884c\u72b6\u6001\uff09\u3002", (String)"MicroServiceImpl_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        int code = Integer.parseInt(resultMap.getOrDefault("code", 1).toString());
        if (code != 0 && !resultMap.containsKey("msg")) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5904\u7406\u7684\u6570\u636e\u672a\u6210\u529f\u65f6\uff0c\u5fc5\u987b\u8fd4\u56demsg\uff08\u9519\u8bef\u4fe1\u606f\uff09,\u53ef\u9009\u8fd4\u56dedev_msg\uff08\u5806\u6808\u4fe1\u606f\uff09\u3002", (String)"MicroServiceImpl_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        if (code == 0 && EXPORT_PACKET.equals(method)) {
            return !this.isRightExportMicroServiceParams(resultMap, fileTransferType, sdpOutputParams);
        }
        return false;
    }

    public boolean isRightExportMicroServiceParams(Map<String, Object> resultMap, String fileTransferType, SdpOutputParams sdpOutputParams) {
        if (FileTransferType.ByteArray.getValue().equals(fileTransferType)) {
            if (!resultMap.containsKey(BYTE_ARR)) {
                sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5fc5\u987b\u8fd4\u56debyte_arr\uff08\u5bfc\u51fa\u7684byte\u6570\u7ec4\uff09\u3002", (String)"MicroServiceImpl_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return false;
            }
        } else if (!resultMap.containsKey("export_url")) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5fc5\u987b\u8fd4\u56deexport_url\uff08\u5bfc\u51fa\u7684\u4e34\u65f6\u6587\u4ef6\u5730\u5740\uff09\u3002", (String)"MicroServiceImpl_12", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        Map<String, Object> param = sdpInputParams.getParam();
        Map customParam = (Map)param.get("custparam");
        String fileUrl = (String)param.get("fileUrl");
        String fileName = (String)param.get("fileName");
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String serviceConfig = guide.getString("plugin");
        JSONObject obj = JSON.parseObject((String)serviceConfig);
        String fileTransferType = obj.getString("filetransfertype");
        String microCustomParamStr = obj.getString(PARAMS);
        MicroServiceParam microServiceParam = this.getMicroServiceParam(obj, IMPORT_PACKET);
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        int totalFileNum = 0;
        int successFileNum = 0;
        HashMap<String, Object> microParamMap = new HashMap<String, Object>(8);
        microParamMap.put("entity_number", guide.getString("page.number"));
        microParamMap.put("entity_name", guide.getString("name"));
        microParamMap.put("file_transfer_type", fileTransferType);
        microParamMap.put(PARAMS, microCustomParamStr);
        microServiceParam.setParas(microParamMap);
        if (customParam != null) {
            microParamMap.putAll(customParam);
        }
        if (fileName.endsWith(".zip")) {
            try (InputStream inputStream = fileService.getInputStream(fileUrl);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry entry;
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    ++totalFileNum;
                    boolean importSuccess = this.executeMicroImportPacket(fileTransferType, microServiceParam, sdpOutputParams, microParamMap, zipInputStream, entry.getName());
                    if (!importSuccess) continue;
                    ++successFileNum;
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                sdpOutputParams.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"MicroServiceImpl_15", (String)"sys-ricc-platform", (Object[])new Object[0]), e);
                sdpOutputParams.setSuccess(false);
            }
        } else {
            try (InputStream inputStream = fileService.getInputStream(fileUrl);){
                totalFileNum = 1;
                boolean importSuccess = this.executeMicroImportPacket(fileTransferType, microServiceParam, sdpOutputParams, microParamMap, inputStream, fileName);
                if (importSuccess) {
                    successFileNum = 1;
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                sdpOutputParams.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"MicroServiceImpl_15", (String)"sys-ricc-platform", (Object[])new Object[0]), e);
                sdpOutputParams.setSuccess(false);
            }
        }
        this.getFileImportTips(sdpOutputParams, totalFileNum, successFileNum);
        return sdpOutputParams;
    }

    private boolean executeMicroImportPacket(String fileTransferType, MicroServiceParam microServiceParam, SdpOutputParams sdpOutputParams, Map<String, Object> microParamMap, InputStream fileInputStream, String fileName) throws IOException {
        microParamMap.put("file_name", fileName);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Map resultMap;
            FileUtils.inputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream);
            this.getImportFileParams(fileTransferType, microParamMap, fileName, byteArrayOutputStream);
            try {
                resultMap = (Map)this.microServiceHandler.execute(microServiceParam);
            }
            catch (Exception e) {
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5206\u6279\u5bfc\u5165\u6570\u636e\u51fa\u9519\uff0c\u6279\u6b21\u6587\u4ef6\uff1a%1$s, \u9519\u8bef\u539f\u56e0\uff1a%2$s", (String)"MicroServiceImpl_13", (String)"sys-ricc-platform", (Object[])new Object[0]), fileName, e.getMessage()), e);
                sdpOutputParams.setSuccess(false);
                boolean bl = false;
                if (byteArrayOutputStream != null) {
                    if (var9_8 != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        byteArrayOutputStream.close();
                    }
                }
                return bl;
            }
            if (this.isRightMicroServiceParams(resultMap, IMPORT_PACKET, fileTransferType, sdpOutputParams)) {
                boolean e = false;
                return e;
            }
            int code = (Integer)resultMap.get("code");
            if (code != 0) {
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\uff1a%1$s, \u6570\u636e\u5904\u7406\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%2$s", (String)"MicroServiceImpl_14", (String)"sys-ricc-platform", (Object[])new Object[0]), fileName, resultMap.get("msg")), (String)resultMap.get("dev_msg"));
                sdpOutputParams.setSuccess(false);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public void getImportFileParams(String fileTransferType, Map<String, Object> microParamMap, String fileName, ByteArrayOutputStream byteArrayOutputStream) {
        if (FileTransferType.TempFile.getValue().equals(fileTransferType)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempFileUrl = cache.saveAsUrl(fileName, byteArrayOutputStream.toByteArray(), 28800);
            if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
            }
            microParamMap.put("import_url", tempFileUrl);
        } else {
            microParamMap.put(BYTE_ARR, byteArrayOutputStream.toByteArray());
        }
    }

    public void getFileImportTips(SdpOutputParams sdpOutputParams, int totalFileNum, int successFileNum) {
        if (successFileNum == totalFileNum) {
            sdpOutputParams.setSuccess(true);
        } else if (successFileNum > 0) {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u4e0d\u6210\u529f\u7684\u6587\u4ef6\uff0c\u603b\u6587\u4ef6\u6570\uff1a%1$s,\u6210\u529f\u6587\u4ef6\u6570\uff1a%2$s", (String)"MicroServiceImpl_16", (String)"sys-ricc-platform", (Object[])new Object[0]), totalFileNum, successFileNum));
            sdpOutputParams.setSuccess(false);
        } else {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5168\u90e8\u5bfc\u5165\u4e0d\u6210\u529f\u7684\uff0c\u603b\u6587\u4ef6\u6570\uff1a%s\uff1b", (String)"MicroServiceImpl_17", (String)"sys-ricc-platform", (Object[])new Object[0]), totalFileNum));
            sdpOutputParams.setSuccess(false);
        }
        Map<String, Object> param = sdpOutputParams.getParam();
        param.put("successCount", successFileNum);
        param.put("failedCount", totalFileNum - successFileNum);
        sdpOutputParams.setParam(param);
    }

    public MicroServiceParam getMicroServiceParam(JSONObject obj, String methodName) {
        String cloudNumber = obj.getString(CLOUD);
        String appNumber = obj.getString(APP_ID);
        String serviceName = obj.getString(SERVICE_NAME);
        MicroServiceParam microServiceParam = new MicroServiceParam();
        microServiceParam.setCloudNumber(cloudNumber);
        microServiceParam.setAppNumber(appNumber);
        microServiceParam.setServiceName(serviceName);
        microServiceParam.setMethodName(methodName);
        return microServiceParam;
    }

    @Override
    public Map<String, Object> provideData(Map<String, Object> params) {
        String serviceConfig = (String)params.get("serviceconfig");
        JSONObject obj = JSON.parseObject((String)serviceConfig);
        MicroServiceParam microServiceParam = this.getMicroServiceParam(obj, "provideData");
        Map<String, Object> resultMap = new HashMap(2);
        StringBuilder errMessage = new StringBuilder();
        try {
            resultMap = (Map)this.microServiceHandler.execute(microServiceParam);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u9884\u89c8\u5fae\u670d\u52a1\u51fa\u9519", (Throwable)e);
            errMessage.append(e.getMessage());
        }
        resultMap.put("errMessage", errMessage.toString());
        resultMap.put("success", false);
        return resultMap;
    }
}

