/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.dataref;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class BaseDataCheckRefrenceBusiness {
    private static final Log log = LogFactory.getLog(BaseDataCheckRefrenceBusiness.class);
    private static final String ENTITY_BD_IGNORE_REF_CHECK = "bd_ignorerefcheck";
    private static final String SQL_READSAMETABLEOBJECTTYPES = "select fid from t_meta_mainentityinfo where ftablename = ? and fpkfieldname = ?  ";
    private static final String SQL_READOBJECTTYPEREF = "select t1.FObjectTypeId, t1.FTableName, t1.FFieldName, t3.FDBRoute, t4.ftablename as fmaintable, t1.fassttypeid, t1.FSqlLoadIdByTime  from t_meta_objecttyperef t1 inner join t_meta_entitydesign t2 on (t1.FObjectTypeId = t2.FNumber) left join t_meta_bizapp t3 on (t2.fbizappid = t3.fid) left join t_meta_mainentityinfo t4 on (t1.FObjectTypeId = t4.fid) ";
    private static final String SQL_READFLEXTYPEREF = "select t0.fformid, t1.fflexfield, t1.fassistanttype from t_bas_flex t0 inner join t_bas_flex_property t1 on (t0.fid = t1.fid) where t1.fvaluesource in (%s) ";
    private static Set<String> ignoreRefEntityIds = new HashSet<String>();
    private static Set<String> asstTypeIds = new HashSet<String>(1);

    public static Set<String> getAsstTypeIds() {
        return asstTypeIds;
    }

    public static Set<String> getIgnoreRefEntityIds() {
        return ignoreRefEntityIds;
    }

    public static List<BaseDataRefenceKey> getAllRefKeys(BasedataEntityType baseEntityType) {
        ArrayList<BaseDataRefenceKey> list = new ArrayList<BaseDataRefenceKey>();
        List<String> bdEntityNumbers = BaseDataCheckRefrenceBusiness.loadSameTableObjectTypes(baseEntityType);
        if (bdEntityNumbers.isEmpty()) {
            return list;
        }
        Set<String> ignoreRefs = BaseDataCheckRefrenceBusiness.loadIgnoreRefCheckSetting(baseEntityType, new HashSet<String>(bdEntityNumbers));
        if (ignoreRefEntityIds == null) {
            ignoreRefEntityIds = new HashSet<String>();
        }
        ignoreRefEntityIds.addAll(ignoreRefs);
        list.addAll(BaseDataCheckRefrenceBusiness.loadObjectTypeRefs(baseEntityType, bdEntityNumbers));
        list.addAll(BaseDataCheckRefrenceBusiness.loadFlexTypeRefs(baseEntityType, bdEntityNumbers));
        return list;
    }

    private static List<String> loadSameTableObjectTypes(BasedataEntityType baseEntityType) {
        if (StringUtils.isBlank((CharSequence)baseEntityType.getAlias()) || baseEntityType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)baseEntityType.getPrimaryKey().getAlias())) {
            return new ArrayList<String>();
        }
        Object[] selectParams = new SqlParameter[]{new SqlParameter("FTableName", 12, (Object)String.valueOf(baseEntityType.getAlias().toLowerCase())), new SqlParameter("FPkFieldName", 12, (Object)String.valueOf(baseEntityType.getPrimaryKey().getAlias().toLowerCase()))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_READSAMETABLEOBJECTTYPES, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> entityNumbers = new ArrayList<String>(16);
                while (rs.next()) {
                    entityNumbers.add(rs.getString("FId"));
                }
                return entityNumbers;
            }
        });
    }

    private static List<BaseDataRefenceKey> loadObjectTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FRefObjectTypeId" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = SQL_READOBJECTTYPEREF;
        if (strParams.size() == 1) {
            sql = sql + "where t1.FRefObjectTypeId = ? ";
        } else {
            sql = sql + "where t1.FRefObjectTypeId in (%s)";
            sql = String.format(sql, StringUtils.join((Object[])strParams.toArray(), (String)","));
        }
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

            public List<BaseDataRefenceKey> handle(ResultSet rs) throws SQLException {
                ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>();
                while (rs.next()) {
                    String tableName = rs.getString("FTableName");
                    String refAsstType = rs.getString("FAsstTypeId");
                    if (!BaseDataCheckRefrenceBusiness.getAsstTypeIds().isEmpty() && StringUtils.isNotBlank((CharSequence)refAsstType) && !BaseDataCheckRefrenceBusiness.getAsstTypeIds().contains(refAsstType)) continue;
                    String objectTypeId = rs.getString("FObjectTypeId");
                    if (BaseDataCheckRefrenceBusiness.getIgnoreRefEntityIds().contains(objectTypeId) || !StringUtils.isNotBlank((CharSequence)tableName)) continue;
                    BaseDataRefenceKey ref = BaseDataRefenceKey.create((BasedataEntityType)baseEntityType, null);
                    ref.setRefDBRouteKey(rs.getString("FDBRoute"));
                    ref.setRefEntityKey(rs.getString("FObjectTypeId"));
                    ref.setRefMainTable(rs.getString("FMainTable"));
                    ref.setRefTable(tableName);
                    ref.setRefCol(rs.getString("FFieldName"));
                    ref.setSqlLoadIdByTime(rs.getString("FSqlLoadIdByTime"));
                    refs.add(ref);
                }
                return refs;
            }
        });
    }

    private static Set<String> loadIgnoreRefCheckSetting(BasedataEntityType baseEntityType, Set<String> refBDTypeNames) {
        HashSet<String> ignoreRefs = new HashSet<String>(0);
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet(BaseDataCheckRefrenceBusiness.class.getSimpleName() + ".loadIgnoreRefCheckSetting", ENTITY_BD_IGNORE_REF_CHECK, "id, entitynumber, ignoreall, baseentitynumber", qFilters);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String refEntity = row.getString("entitynumber");
                Boolean ignoreall = row.getBoolean("ignoreall");
                String baseEntity = row.getString("baseentitynumber");
                if (ignoreall.booleanValue()) {
                    ignoreRefs.add(refEntity);
                    continue;
                }
                if (!refBDTypeNames.contains(baseEntity)) continue;
                ignoreRefs.add(refEntity);
            }
        }
        catch (Throwable exp) {
            log.error(exp);
        }
        return ignoreRefs;
    }

    private static List<BaseDataRefenceKey> loadFlexTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FValueSource" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = String.format(SQL_READFLEXTYPEREF, StringUtils.join((Object[])strParams.toArray(), (String)","));
        try {
            List bdrList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

                public List<BaseDataRefenceKey> handle(ResultSet rs) throws SQLException {
                    ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>();
                    while (rs.next()) {
                        String refAsstType = rs.getString("fassistanttype");
                        if (!BaseDataCheckRefrenceBusiness.getAsstTypeIds().isEmpty() && StringUtils.isNotBlank((CharSequence)refAsstType) && !BaseDataCheckRefrenceBusiness.getAsstTypeIds().contains(refAsstType)) continue;
                        BaseDataRefenceKey ref = BaseDataRefenceKey.create((BasedataEntityType)baseEntityType, null);
                        ref.setRefEntityKey(rs.getString("fformid"));
                        ref.setRefCol("FValue");
                        ref.setRefFlexProperty(true);
                        ref.setRefFlexField(rs.getString("FFlexField"));
                        if (!StringUtils.isNotBlank((CharSequence)ref.getRefFlexField())) continue;
                        refs.add(ref);
                    }
                    return refs;
                }
            });
            Object[] ids = new String[bdrList.size()];
            int i = 0;
            for (BaseDataRefenceKey baseDataRefenceKey : bdrList) {
                ids[i++] = baseDataRefenceKey.getRefEntityKey();
            }
            String inStr = StringUtils.join((Object[])ids, (String)"','");
            String sql1 = String.format("select fid, ftablename from t_meta_mainentityinfo where fid in ('%s')", inStr);
            Map refs = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql1, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> refs = new HashMap<String, String>(16);
                    while (rs.next()) {
                        refs.put(rs.getString(1), rs.getString(2));
                    }
                    return refs;
                }
            });
            for (BaseDataRefenceKey ref : bdrList) {
                String tab = (String)refs.get(ref.getRefEntityKey());
                ref.setRefTable(tab + "_bd");
            }
            return bdrList;
        }
        catch (Exception exp) {
            return new ArrayList<BaseDataRefenceKey>(0);
        }
    }
}

