/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schemeconfig.actions;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.schemeconfig.AbstractIscInitAction;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class CreateIscLinkAction
extends AbstractIscInitAction {
    private static final String CURRENT_TYPE = "currenttype";
    private static final String SERVER_IP = "server_ip";
    private static final String SERVER_PORT = "server_port";
    private static final String ISC_IERP_LINK = "isc_database_link";
    private static final String SRC = "src";
    private static final String ISC_RESOURCE_PATH = "/kd/sys/ricc/datasource/ricc_isc_data_source_A298.dts";
    private static final long TAR_DC_ID = 1262271600149923840L;
    private static final long SRC_DC_ID = 1262273189019387904L;
    private static final String DBLINK_ID = "dblink_id";

    public CreateIscLinkAction() {
        this.setId(1553603468705404932L);
        this.setName(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u8fde\u63a5", (String)"CreateIscLinkAction_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
    }

    @Override
    public void doAction() {
        DynamicObject schemeConfig = BusinessDataServiceHelper.loadSingle((Object)1384008697021203456L, (String)"ricc_schemeconfig");
        DynamicObject iscLink = this.updateOrGenIscLinkObj(schemeConfig);
        DynamicObject iscSelfLink = this.getOrGenSelfLink();
        DynamicObject[] iscDataSources = this.getOrImportIscDataSource();
        if (iscDataSources.length <= 1) {
            this.setStatus(4);
            this.getMsg().append(ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91\u6570\u636e\u6e90\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u67e5\u770b\u6267\u884c\u8be6\u60c5", (String)"CreateIscLinkAction_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        OperationResult result = SaveServiceHelper.saveOperate((String)ISC_IERP_LINK, (DynamicObject[])new DynamicObject[]{iscLink, iscSelfLink}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            this.setStatus(4);
            this.getMsg().append(ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91\u8fde\u63a5\u914d\u7f6e\u5931\u8d25\uff0c", (String)"CreateIscLinkAction_2", (String)"sys-ricc-platform", (Object[])new Object[0])).append(result.getMessage()).append(result.getValidateResult()).append(result.getAllErrorOrValidateInfo());
            return;
        }
        this.saveIscDataSource(schemeConfig, iscDataSources);
        this.setStatus(3);
        this.getMsg().append(ResManager.loadKDString((String)"\u96c6\u6210\u8fde\u63a5\u521b\u5efa\u6210\u529f", (String)"CreateIscLinkAction_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.setProgress(5);
    }

    private DynamicObject updateOrGenIscLinkObj(DynamicObject dyo) {
        DynamicObject iscLink;
        boolean exists = QueryServiceHelper.exists((String)ISC_IERP_LINK, (Object)1437037436273191936L);
        if (!exists) {
            iscLink = BusinessDataServiceHelper.newDynamicObject((String)ISC_IERP_LINK);
            iscLink.set("id", (Object)1437037436273191936L);
            iscLink.set("number", (Object)"ricc_ierp_link");
            iscLink.set("name", (Object)ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3_\u76ee\u6807\u6570\u636e\u4e2d\u5fc3", (String)"CreateIscLinkAction_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
            iscLink.set("database_type", (Object)"ierp");
            iscLink.set("appid", (Object)"ricc");
            iscLink.set("enable", (Object)"1");
            iscLink.set("isv", (Object)CreateIscLinkAction.getPreRiccIsv());
            iscLink.set("status", (Object)"C");
        } else {
            iscLink = BusinessDataServiceHelper.loadSingle((Object)1437037436273191936L, (String)ISC_IERP_LINK);
        }
        iscLink.set(SERVER_IP, (Object)dyo.getString(SERVER_IP));
        iscLink.set(SERVER_PORT, dyo.get(SERVER_PORT));
        iscLink.set("appsecret_new", dyo.get("appsecret"));
        iscLink.set("account", dyo.get("account"));
        iscLink.set("tenant", dyo.get("tenant"));
        iscLink.set("web_app", dyo.get("webapp"));
        iscLink.set("http_protocal", dyo.get("httpprotocal"));
        iscLink.set("user", dyo.get("user"));
        iscLink.set("newpwd", dyo.get("userpwd"));
        iscLink.set("icid", (Object)"zh_CN");
        iscLink.set("ierp_proxy_user", (Object)dyo.getDynamicObject("ierpproxyuser"));
        return iscLink;
    }

    private DynamicObject[] getOrImportIscDataSource() {
        MainEntityType entityIscDataSource = EntityMetadataCache.getDataEntityType((String)"isc_data_source");
        DynamicObject[] iscDataSources = BusinessDataServiceHelper.load((Object[])new Object[]{1262271600149923840L, 1262273189019387904L}, (DynamicObjectType)entityIscDataSource);
        if (iscDataSources.length <= 0) {
            String str = this.loadIscResource(ISC_RESOURCE_PATH);
            DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{str, Boolean.TRUE});
            iscDataSources = BusinessDataServiceHelper.load((Object[])new Object[]{1262271600149923840L, 1262273189019387904L}, (DynamicObjectType)entityIscDataSource);
        }
        return iscDataSources;
    }

    private String loadIscResource(String path) {
        URL url = this.getClass().getResource(path);
        if (null == url) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u96c6\u6210\u6570\u636e\u6e90\u9884\u7f6e\u6587\u4ef6", (String)"CreateIscLinkAction_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        String str = null;
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            str = FileUtils.inputStreamToString((InputStream)in);
        }
        catch (IOException e) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u9884\u7f6e\u7684\u96c6\u6210\u4e91\u6570\u636e\u6e90\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"CreateIscLinkAction_5", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e)), (Throwable)e);
        }
        return str;
    }

    private DynamicObject getOrGenSelfLink() {
        DynamicObject selfLink = BusinessDataServiceHelper.loadSingle((String)ISC_IERP_LINK, (QFilter[])new QFilter("id", "=", (Object)1533952130870752256L).toArray());
        if (selfLink == null) {
            selfLink = BusinessDataServiceHelper.newDynamicObject((String)ISC_IERP_LINK);
            selfLink.set("id", (Object)1533952130870752256L);
            selfLink.set("number", (Object)"ricc_current_link");
            selfLink.set("name", (Object)new LocaleString("zh_CN", SysParaUtil.getPreIscSelfLinkName()));
            selfLink.set("database_type", (Object)"self");
            selfLink.set("isv", (Object)CreateIscLinkAction.getPreRiccIsv());
        }
        return selfLink;
    }

    private void saveIscDataSource(DynamicObject dyo, DynamicObject[] iscDataSources) {
        String currentType = dyo.getString(CURRENT_TYPE);
        if (SRC.equals(currentType)) {
            for (DynamicObject dc : iscDataSources) {
                if (String.valueOf(1262271600149923840L).equals(dc.getString("id"))) {
                    dc.set(DBLINK_ID, (Object)1533952130870752256L);
                    continue;
                }
                dc.set(DBLINK_ID, (Object)1437037436273191936L);
            }
        } else {
            for (DynamicObject dc : iscDataSources) {
                if (String.valueOf(1262271600149923840L).equals(dc.getString("id"))) {
                    dc.set(DBLINK_ID, (Object)1437037436273191936L);
                    continue;
                }
                dc.set(DBLINK_ID, (Object)1533952130870752256L);
            }
        }
        for (DynamicObject dc : iscDataSources) {
            dc.set("isv", (Object)CreateIscLinkAction.getPreRiccIsv());
        }
        SaveServiceHelper.save((DynamicObject[])iscDataSources);
    }

    private static String getPreRiccIsv() {
        return ResManager.loadKDString((String)"kingdee.\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3", (String)"CreateIscLinkAction_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }
}

