/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.transfer;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sys.ricc.business.datapacket.download.DataPacketDownLoader;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.transfer.TransferPacketFastProgress;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.log.AbstractLogRecord;
import kd.sys.ricc.common.log.LogRecorder;
import kd.sys.ricc.common.log.impl.ConfigLogImpl;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.Hex;

public class PacketFastTransferTask
extends AbstractSerailTask {
    private static final Log log = LogFactory.getLog(PacketFastTransferTask.class);
    private static final String ZIP_SUFFIX = ".zip";
    private final ConfigLogImpl configLog = new ConfigLogImpl();
    private TransferPacketFastProgress transferProcess;
    private int selectedPacketCount = 0;
    private int successTransferCount = 0;
    private int failPacketCount = 0;
    private DynamicObject[] selectedDataPackets;
    private List<Map<String, Object>> loginParamList = new ArrayList<Map<String, Object>>(16);
    private List<String> transferTypeList;
    private Object packetLogs;

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        this.initTask(map);
        this.handleDataPackets();
        this.getProcess().complete();
    }

    private void initTask(Map<String, Object> map) {
        this.packetLogs = map.get("packetLogIdMap");
        String selectRowsStr = (String)map.get("selectRows");
        ListSelectedRowCollection listSelectedRows = ListSelectedRowCollection.deSerialize((String)selectRowsStr);
        Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
        MainEntityType dataPacketType = EntityMetadataCache.getDataEntityType((String)"ricc_datapacket");
        this.selectedDataPackets = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)dataPacketType);
        this.selectedPacketCount = this.selectedDataPackets.length;
        String msgTpl = ResManager.loadKDString((String)"\u5171\u52fe\u9009 %1$s \u4e2a\u4f20\u8f93\u5305\u3002%n", (String)"PacketFastTransferTask_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.getProcess().feedbackTitle(String.format(msgTpl, this.selectedPacketCount));
        this.transferTypeList = (List)map.get("transfertype");
        this.loginParamList = this.getLoginParamList(map);
    }

    private List<Map<String, Object>> getLoginParamList(Map<String, Object> map) {
        Object targetData = map.get("targetdata");
        if (targetData == null) {
            return this.loginParamList;
        }
        Map targetDataMap = (Map)targetData;
        List targetDataCenterIdList = targetDataMap.keySet().stream().map(Long::valueOf).collect(Collectors.toList());
        Map targetDataCenterDymMap = BusinessDataServiceHelper.loadFromCache((String)"ricc_destaccount", (QFilter[])new QFilter("id", "in", targetDataCenterIdList).toArray());
        for (Map.Entry targetDataEntry : targetDataMap.entrySet()) {
            Long targetDataCenterId = Long.valueOf((String)targetDataEntry.getKey());
            String targetDataCenterUser = (String)targetDataEntry.getValue();
            HashMap<String, Object> loginParamMap = new HashMap<String, Object>(6);
            DynamicObject targetDataCenter = (DynamicObject)targetDataCenterDymMap.get(targetDataCenterId);
            if (targetDataCenter == null) continue;
            loginParamMap.put("evnurl", targetDataCenter.getString("evnurl"));
            loginParamMap.put("appsecuret", targetDataCenter.getString("appsecuret"));
            loginParamMap.put("targetdatacenteruser", targetDataCenterUser);
            loginParamMap.put("accountId", targetDataCenter.getString("number"));
            loginParamMap.put("evntype", targetDataCenter.getString("evntype"));
            loginParamMap.put("tarDataCenterPk", targetDataCenterId);
            this.loginParamList.add(loginParamMap);
        }
        return this.loginParamList;
    }

    private void handleDataPackets() {
        for (int i = 0; i < this.selectedDataPackets.length; ++i) {
            DynamicObject dataPacket = this.selectedDataPackets[i];
            this.successTransferCount = 0;
            int index = 0;
            for (Map<String, Object> loginParam : this.loginParamList) {
                LogRecorder errMsg = new LogRecorder();
                Object packetId = dataPacket.get("id");
                String datapacketNum = dataPacket.getString("number");
                String transferType = this.transferTypeList.get(index);
                this.beforePacketTransfer((Long)packetId, loginParam, transferType);
                DynamicObjectCollection subPackets = dataPacket.getDynamicObjectCollection("subdatapacket");
                if (Objects.isNull(subPackets) || subPackets.isEmpty()) {
                    errMsg.append(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4e0d\u5b58\u5728\u5b50\u4f20\u8f93\u5305\u3002", (String)"PacketFastTransferTask_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    this.configLog.afterWriteLog(1, 0, (AbstractLogRecord)errMsg);
                    continue;
                }
                int subDataPacketSize = subPackets.size();
                boolean needSyn = "transferandsyn".equals(transferType) || "onlysyn".equals(transferType);
                int totalInLog = needSyn ? subDataPacketSize : 1;
                String dataStream = this.compressPacketToHexStr(dataPacket, datapacketNum, errMsg);
                if (dataStream != null) {
                    Map<String, Object> response = this.invokeTransferApi(loginParam, dataStream, datapacketNum, errMsg, transferType);
                    if (response != null) {
                        this.processApiResult(response, packetId, subDataPacketSize, totalInLog, errMsg);
                    } else {
                        this.configLog.afterWriteLog(totalInLog, 0, (AbstractLogRecord)errMsg);
                    }
                } else {
                    this.configLog.afterWriteLog(totalInLog, 0, (AbstractLogRecord)errMsg);
                }
                ++index;
            }
            if (this.successTransferCount != this.loginParamList.size()) {
                ++this.failPacketCount;
            }
            this.getProcess().feedbackProgress(this.selectedPacketCount, i, this.failPacketCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compressPacketToHexStr(DynamicObject dataPacket, String dataPacketNum, LogRecorder errMsg) {
        String dataStream = null;
        try {
            String zipPath = FileUtils.generateLocalPath();
            File zipFileDir = FileUtils.checkAndCreateDir((String)zipPath);
            String zipName = dataPacketNum + ZIP_SUFFIX;
            String zipFilePath = DataPacketDownLoader.packetToZip(dataPacket, zipPath, zipName);
            try (InputStream inputStream = Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]);){
                byte[] dataPacketBytes = FileUtils.inputStreamToByte((InputStream)inputStream);
                dataStream = Hex.encode((byte[])dataPacketBytes);
            }
            finally {
                FileUtils.deleteLocalFile((File)zipFileDir);
            }
        }
        catch (Exception e) {
            log.info("\u6253\u5305\u538b\u7f29\u5931\u8d25\u3002", (Object)e);
            String msgTpl = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u201c%s\u201d\u6587\u4ef6\u6570\u636e\u538b\u7f29\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff1a", (String)"PacketFastTransferTask_10", (String)"sys-ricc-platform", (Object[])new Object[0]);
            errMsg.append(String.format(msgTpl, dataPacketNum), (Throwable)e);
            return null;
        }
        return dataStream;
    }

    private void beforePacketTransfer(long id, Map<String, Object> loginParam, String transferType) {
        String tarLoginUser = loginParam.get("targetdatacenteruser").toString();
        long tarDataCenterPk = (Long)loginParam.get("tarDataCenterPk");
        Object packetLogId = null;
        if (this.packetLogs != null) {
            Map packetLogIdMap = (Map)this.packetLogs;
            packetLogId = packetLogIdMap.get(tarDataCenterPk);
        }
        if ("transferandsyn".equals(transferType)) {
            this.configLog.preWriteLog("5", this.taskId, id, tarDataCenterPk, tarLoginUser, packetLogId);
        } else {
            this.configLog.preWriteLog("1", this.taskId, id, tarDataCenterPk, tarLoginUser, packetLogId);
        }
    }

    private Map<String, Object> invokeTransferApi(Map<String, Object> loginParam, String dataStream, String datapacketNum, LogRecorder errMsg, String transferType) {
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("data", dataStream);
        data.put("packetNumber", datapacketNum);
        data.put("methodName", transferType);
        String response = null;
        try {
            response = ApiUtil.transfer(data, loginParam);
        }
        catch (Exception e) {
            log.error("\u4f20\u8f93\u5305\u7f16\u7801\uff1a" + datapacketNum + "\u7c7b\u578b\uff1a" + this.transferTypeList + "\uff0c\u5728\u7ebf\u4f20\u8f93\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\u3002", (Throwable)e);
            errMsg.append(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u5728\u7ebf\u4f20\u8f93\u53d1\u751f\u5f02\u5e38\uff1a", (String)"PacketFastTransferTask_8", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
            return null;
        }
        log.info("\u5728\u7ebf\u4f20\u8f93\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4fe1\u606f\uff1a" + response);
        return (Map)JSON.parseObject((String)response, Map.class);
    }

    private void processApiResult(Map<String, Object> resp, Object packetId, int subPacketSize, int totalInLog, LogRecorder errMsg) {
        LogRecorder syncMessage;
        String transferResult = (String)resp.get("data");
        try {
            syncMessage = (LogRecorder)SerializationUtils.fromJsonString((String)((String)resp.get("message")), LogRecorder.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6210LogRecorder\u5bf9\u8c61\u5931\u8d25\u3002", (Throwable)e);
            syncMessage = new LogRecorder();
            syncMessage.append(resp.get("message"));
        }
        if (transferResult == null) {
            String msgTpl = ResManager.loadKDString((String)"\u4f20\u8f93\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"PacketFastTransferTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            errMsg.append(String.format(msgTpl, syncMessage.getMessageStr()), syncMessage.getDevMessageStr());
            this.configLog.afterWriteLog(totalInLog, 0, (AbstractLogRecord)errMsg);
            return;
        }
        log.info("\u4f20\u8f93\u6216\u540c\u6b65\u8bbe\u7f6e\u6700\u540e\u72b6\u6001\uff1a" + transferResult);
        String entryLogsStr = syncMessage.getEntryLogs();
        int entrySynSuccessCount = 0;
        switch (transferResult) {
            case "0": {
                errMsg.append(ResManager.loadKDString((String)"\u4f20\u8f93\u6210\u529f\u3002", (String)"PacketFastTransferTask_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.configLog.afterWriteLog(1, 1, (AbstractLogRecord)errMsg);
                this.afterDownload(packetId);
                ++this.successTransferCount;
                break;
            }
            case "1": {
                errMsg.append(syncMessage.getMessageStr(), syncMessage.getDevMessageStr());
                this.configLog.afterWriteLog(totalInLog, 0, (AbstractLogRecord)errMsg);
                break;
            }
            case "3": {
                this.afterDownload(packetId);
                if (StringUtils.isEmpty((CharSequence)entryLogsStr)) {
                    errMsg.append(syncMessage.getMessageStr(), syncMessage.getDevMessageStr());
                } else {
                    errMsg.append(ResManager.loadKDString((String)"\u4f20\u8f93\u6210\u529f\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"PacketFastTransferTask_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    errMsg.appendDev(syncMessage.getDevMessageStr());
                    entrySynSuccessCount = this.parseEntrySynLog(entryLogsStr);
                }
                this.configLog.afterWriteEntryLog(subPacketSize, entrySynSuccessCount, (AbstractLogRecord)errMsg);
                break;
            }
            case "4": {
                this.afterDownload(packetId);
                errMsg.setMessage(ResManager.loadKDString((String)"\u4f20\u8f93\u6210\u529f\uff0c\u540c\u6b65\u6210\u529f\u3002", (String)"PacketFastTransferTask_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
                entrySynSuccessCount = this.parseEntrySynLog(entryLogsStr);
                this.configLog.afterWriteEntryLog(subPacketSize, entrySynSuccessCount, (AbstractLogRecord)errMsg);
                ++this.successTransferCount;
                break;
            }
            default: {
                String msgTpl = ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u8fd4\u56de\u7ed3\u679c\uff1a%s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PacketFastTransferTask_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
                errMsg.append(String.format(msgTpl, transferResult), syncMessage.getDevMessageStr());
                this.configLog.afterWriteLog(totalInLog, 0, (AbstractLogRecord)errMsg);
            }
        }
    }

    public TransferPacketFastProgress getProcess() {
        if (this.transferProcess == null) {
            this.transferProcess = new TransferPacketFastProgress(this.taskId, CommonConstant.getMsgTransferTaskName());
        }
        return this.transferProcess;
    }

    private void afterDownload(Object packetId) {
        ArrayList<Object> addDownloadPacketList = new ArrayList<Object>(1);
        addDownloadPacketList.add(packetId);
        CommonUtil.afterDownload(addDownloadPacketList);
    }

    private int parseEntrySynLog(String entryLogsStr) {
        int successEntryCount = 0;
        if (!StringUtils.isEmpty((CharSequence)entryLogsStr)) {
            Object[] entryLogs;
            for (Object entryLogObj : entryLogs = DynamicObjectSerializeUtil.deserialize((String)entryLogsStr, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ricc_log").getDynamicObjectCollection("synlogentry").getDynamicObjectType())) {
                DynamicObject entryLog = (DynamicObject)entryLogObj;
                String entrySynStatus = entryLog.getString("entrysynstatus");
                String entryLogTag = entryLog.getString("synlog_tag");
                int entrySuccessCount = entryLog.getInt("entrysuccesscount");
                int entryFailedCount = entryLog.getInt("entryfailedcount");
                if ("1".equals(entrySynStatus)) {
                    ++successEntryCount;
                }
                int seq = entryLog.getInt("seq");
                this.configLog.buildEntrySyncLogWithMsg(entrySynStatus, entryLogTag, seq, entrySuccessCount, entryFailedCount);
            }
        }
        return successEntryCount;
    }
}

