/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.datacompare;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.TransferUtil;

public class DataCompareToolPlugin
extends AbstractFormPlugin {
    private static final String QUERY = "query";
    private static final String ENTITY_TYPE = "billNumber";
    private static final String UNIQUE_KEY_TYPE = "uniquekeytype";
    private static final String UNIQUE_KEY_VALUE = "uniquekeyvalue";
    private static final String IDTYPE = "idtype";
    private static final String CALL_BACK_ID = "F7listCallBack";
    private static final String ID_TYPE_VALUE = "0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UNIQUE_KEY_VALUE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{IDTYPE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TransferUtil.setDefaultCenterAndUser((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (UNIQUE_KEY_TYPE.equals(key)) {
            this.getModel().setValue(UNIQUE_KEY_VALUE, null);
            String uniqueKeyType = (String)this.getModel().getValue(UNIQUE_KEY_TYPE);
            if ("id".equalsIgnoreCase(uniqueKeyType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{IDTYPE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{IDTYPE});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (UNIQUE_KEY_VALUE.equals(controlKey)) {
            DynamicObject selectDynamicObject = (DynamicObject)this.getModel().getValue("entitynumber");
            if (selectDynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u7c7b\u578b", (String)"DataCompareToolPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String uniqueKeyType = (String)this.getModel().getValue(UNIQUE_KEY_TYPE);
            if (StringUtils.isEmpty((String)uniqueKeyType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u5b9a\u552f\u4e00\u952e\u7c7b\u578b", (String)"DataCompareToolPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            if ("id".equalsIgnoreCase(uniqueKeyType) || "number".equalsIgnoreCase(uniqueKeyType)) {
                String entityNumber = selectDynamicObject.getString("number");
                ListShowParameter parameter = ShowParameterUtil.simpleListShowParameter((String)entityNumber, (ShowType)ShowType.Modal, null);
                parameter.setLookUp(true);
                parameter.setMultiSelect(false);
                StyleCss style = new StyleCss();
                style.setWidth("1000");
                style.setHeight("600");
                parameter.getOpenStyle().setInlineStyleCss(style);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_ID));
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u624b\u52a8\u8f93\u5165\u552f\u4e00\u952e\u503c\uff01\u53ea\u6709\u552f\u4e00\u952e\u7c7b\u578b\u4e3aid\u6216\u8005number\u65f6\uff0c\u624d\u80fd\u9009\u62e9\u552f\u4e00\u952e\u503c\uff0c\u5426\u5219\u53ea\u80fd\u624b\u52a8\u8f93\u5165\u3002", (String)"DataCompareToolPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALL_BACK_ID.equals(actionId)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
            if (selectedRows == null) {
                return;
            }
            String uniqueKeyType = this.getModel().getValue(UNIQUE_KEY_TYPE).toString();
            if ("id".equalsIgnoreCase(uniqueKeyType)) {
                this.getModel().setValue(UNIQUE_KEY_VALUE, selectedRows.get(0).getPrimaryKeyValue());
            } else if ("number".equalsIgnoreCase(uniqueKeyType)) {
                this.getModel().setValue(UNIQUE_KEY_VALUE, (Object)selectedRows.get(0).getNumber());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (QUERY.equals(operateKey)) {
            String targetCenterUser;
            DynamicObject desAccountObj = (DynamicObject)this.getModel().getValue("targetdatacenter");
            long destAccountPk = (Long)desAccountObj.getPkValue();
            Map loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)(targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser")));
            if (loginParams.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u3002", (String)"DataCompareToolPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            DynamicObject targetData = this.getTargetDestAccountData(loginParams);
            if (targetData == null) {
                return;
            }
            Map<String, Object> formParams = this.getFormParams();
            DynamicObject srcData = this.getSrcDestAccountData();
            if (srcData == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e2d\u7684\u5b9e\u4f53\u7c7b\u578b%1$s\u4e0d\u5b58\u5728%2$s\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"DataCompareToolPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), formParams.get(ENTITY_TYPE), formParams.get(UNIQUE_KEY_TYPE), formParams.get(UNIQUE_KEY_VALUE)));
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("entity", formParams.get(ENTITY_TYPE));
            customParams.put("srcData", srcData);
            customParams.put("targetData", targetData);
            this.showDiff(customParams);
        }
    }

    private DynamicObject getTargetDestAccountData(Map<String, Object> loginParams) {
        Map<String, Object> formParams = this.getFormParams();
        String response = ApiUtil.getDestAccountData(formParams, loginParams, (String)"biz");
        CustomApiResult apiResult = (CustomApiResult)JSON.parseObject((String)response, CustomApiResult.class);
        if (!apiResult.isStatus()) {
            this.getView().showErrorNotification(apiResult.getMessage());
            return null;
        }
        String responseData = (String)apiResult.getData();
        if (responseData == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4e2d\u7684\u5b9e\u4f53\u7c7b\u578b%1$s\u4e0d\u5b58\u5728%2$s\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002", (String)"DataCompareToolPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), formParams.get(ENTITY_TYPE), formParams.get(UNIQUE_KEY_TYPE), formParams.get(UNIQUE_KEY_VALUE)));
            return null;
        }
        MainEntityType dtType = EntityMetadataCache.getDataEntityType((String)((String)formParams.get(ENTITY_TYPE)));
        DynamicObject targetData = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)responseData, (DynamicObjectType)dtType)[0];
        return targetData;
    }

    private DynamicObject getSrcDestAccountData() {
        Map<String, Object> params = this.getFormParams();
        String idType = (String)params.get(IDTYPE);
        String value = (String)params.get(UNIQUE_KEY_VALUE);
        QFilter qFilter = ID_TYPE_VALUE.equals(idType) ? new QFilter("id", "=", (Object)Long.valueOf(value)) : new QFilter(params.get(UNIQUE_KEY_TYPE).toString(), "=", (Object)value);
        return BusinessDataServiceHelper.loadSingle((String)params.get(ENTITY_TYPE).toString(), (QFilter[])qFilter.toArray());
    }

    private Map<String, Object> getFormParams() {
        IDataModel model = this.getModel();
        DynamicObject selectDynamicObject = (DynamicObject)model.getValue("entitynumber");
        String entityNumber = selectDynamicObject.getString("number");
        String uniqueKeyType = model.getValue(UNIQUE_KEY_TYPE).toString();
        String uniqueKeyValue = model.getValue(UNIQUE_KEY_VALUE).toString();
        String idType = (String)model.getValue(IDTYPE);
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        if ("id".equalsIgnoreCase(uniqueKeyType) && ID_TYPE_VALUE.equals(idType)) {
            res.put(IDTYPE, ID_TYPE_VALUE);
        }
        res.put(ENTITY_TYPE, entityNumber);
        res.put(UNIQUE_KEY_TYPE, uniqueKeyType);
        res.put(UNIQUE_KEY_VALUE, uniqueKeyValue);
        return res;
    }

    private void showDiff(Map<String, Object> customParams) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)customParams.get("entity")));
        StringBuilder caption = new StringBuilder(ResManager.loadKDString((String)"\u6570\u636e\u5dee\u5f02\u5bf9\u6bd4", (String)"DataCompareToolPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
        String formName = dataEntityType.getDisplayName().toString();
        if (StringUtils.isNotEmpty((String)formName)) {
            caption.append("\u2014\u2014");
            caption.append(formName);
        }
        FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"ricc_diff_data_compare", (ShowType)ShowType.Modal, customParams, (String)caption.toString(), null);
        formShowParameter.setParentPageId(this.getView().getPageId());
        this.getView().showForm(formShowParameter);
    }
}

